/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.gui.Desktop;
import java.awt.Point;
import java.net.URL;
import javax.help.BadIDException;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;

public class Help {
    private static HelpBroker hb;

    private Help() {
    }

    public static void showHelpWindow(HelpId id) throws HelpSetException {
        ClassLoader cl = Desktop.class.getClassLoader();
        URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)"help/help");
        HelpSet hs = new HelpSet(cl, url);
        if (hb == null) {
            hb = hs.createHelpBroker();
        }
        try {
            hb.setCurrentID(id.toString());
        }
        catch (BadIDException bad) {
            System.out.println("Bad help link: " + id.toString() + ": must match a target in help.jhm");
            throw bad;
        }
        Point p = hb.getLocation();
        hb.setLocation(p);
        hb.setDisplayed(true);
    }

    public static void showHelpWindow() throws HelpSetException {
        Help.showHelpWindow(HelpId.Home);
    }

    public static enum HelpId {
        Home("home"),
        SequenceFeatureSettings("seqfeatures.settings"),
        StructureViewer("viewingpdbs"),
        PdbFts("pdbfts"),
        UniprotFts("uniprotfts");

        private String id;

        private HelpId(String loc) {
            this.id = loc;
        }

        public String toString() {
            return this.id;
        }
    }
}

