/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.FeatureColourI;
import jalview.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;

class FeatureIcon
implements Icon {
    FeatureColourI gcol;
    Color backg;
    boolean midspace = false;
    int width = 50;
    int height = 20;
    int s1;
    int e1;
    Color mpcolour = Color.white;

    FeatureIcon(FeatureColourI gfc, Color bg, int w, int h, boolean mspace) {
        this.gcol = gfc;
        this.backg = bg;
        this.width = w;
        this.height = h;
        this.midspace = mspace;
        if (this.midspace) {
            this.s1 = this.width / 3;
            this.e1 = this.s1 * 2;
        } else {
            this.e1 = this.s1 = this.width / 2;
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.gcol.isColourByLabel()) {
            g.setColor(this.backg);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(this.gcol.getMaxColour());
            g.setFont(new Font("Verdana", 0, 9));
            g.drawString(MessageManager.getString("label.label"), 0, 0);
        } else {
            Color minCol = this.gcol.getMinColour();
            g.setColor(minCol);
            g.fillRect(0, 0, this.s1, this.height);
            if (this.midspace) {
                g.setColor(Color.white);
                g.fillRect(this.s1, 0, this.e1 - this.s1, this.height);
            }
            g.setColor(this.gcol.getMaxColour());
            g.fillRect(0, this.e1, this.width - this.e1, this.height);
        }
    }
}

