/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.scoremodels.ScoreModels;
import jalview.analysis.scoremodels.SimilarityParams;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Cache;
import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.ComboBoxTooltipRenderer;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.PCAPanel;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class CalculationChooser
extends JPanel {
    private static boolean treeMatchGaps = true;
    private static final Font VERDANA_11PT = new Font("Verdana", 0, 11);
    private static final int MIN_TREE_SELECTION = 3;
    private static final int MIN_PCA_SELECTION = 4;
    AlignFrame af;
    JRadioButton pca;
    JRadioButton neighbourJoining;
    JRadioButton averageDistance;
    JComboBox<String> modelNames;
    JButton calculate;
    private JInternalFrame frame;
    private JCheckBox includeGaps;
    private JCheckBox matchGaps;
    private JCheckBox includeGappedColumns;
    private JCheckBox shorterSequence;
    final ComboBoxTooltipRenderer renderer = new ComboBoxTooltipRenderer();
    List<String> tips = new ArrayList<String>();
    private PCAPanel pcaPanel;

    public CalculationChooser(AlignFrame alignFrame) {
        this.af = alignFrame;
        this.init();
        this.af.alignPanel.setCalculationDialog(this);
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.setBackground(Color.white);
        this.frame.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                CalculationChooser.this.validateCalcTypes();
            }
        });
        this.pca = new JRadioButton(MessageManager.getString("label.principal_component_analysis"));
        this.pca.setOpaque(false);
        this.neighbourJoining = new JRadioButton(MessageManager.getString("label.tree_calc_nj"));
        this.neighbourJoining.setSelected(true);
        this.averageDistance = new JRadioButton(MessageManager.getString("label.tree_calc_av"));
        this.neighbourJoining.setOpaque(false);
        JPanel calcChoicePanel = new JPanel(new FlowLayout(0));
        calcChoicePanel.setOpaque(false);
        JPanel treePanel = new JPanel(new FlowLayout(0));
        treePanel.setOpaque(false);
        JvSwingUtils.createTitledBorder(treePanel, MessageManager.getString("label.tree"), true);
        JPanel pcaBorderless = new JPanel(new FlowLayout(0));
        Insets b = treePanel.getBorder().getBorderInsets(treePanel);
        pcaBorderless.setBorder(BorderFactory.createEmptyBorder(2, b.left, 2, b.right));
        pcaBorderless.setOpaque(false);
        pcaBorderless.add((Component)this.pca, 0);
        calcChoicePanel.add((Component)pcaBorderless, 0);
        treePanel.add(this.neighbourJoining);
        treePanel.add(this.averageDistance);
        calcChoicePanel.add(treePanel);
        ButtonGroup calcTypes = new ButtonGroup();
        calcTypes.add(this.pca);
        calcTypes.add(this.neighbourJoining);
        calcTypes.add(this.averageDistance);
        ActionListener calcChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculationChooser.this.validateCalcTypes();
            }
        };
        this.pca.addActionListener(calcChanged);
        this.neighbourJoining.addActionListener(calcChanged);
        this.averageDistance.addActionListener(calcChanged);
        this.modelNames = this.buildModelOptionsList();
        JPanel scoreModelPanel = new JPanel(new FlowLayout(1));
        scoreModelPanel.setOpaque(false);
        scoreModelPanel.add(this.modelNames);
        JPanel paramsPanel = new JPanel(new GridLayout(5, 1));
        paramsPanel.setOpaque(false);
        this.includeGaps = new JCheckBox("Include gaps");
        this.matchGaps = new JCheckBox("Match gaps");
        this.includeGappedColumns = new JCheckBox("Include gapped columns");
        this.shorterSequence = new JCheckBox("Match on shorter sequence");
        paramsPanel.add(new JLabel("Pairwise sequence scoring options"));
        paramsPanel.add(this.includeGaps);
        paramsPanel.add(this.matchGaps);
        paramsPanel.add(this.includeGappedColumns);
        paramsPanel.add(this.shorterSequence);
        this.calculate = new JButton(MessageManager.getString("action.calculate"));
        this.calculate.setFont(VERDANA_11PT);
        this.calculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculationChooser.this.calculate_actionPerformed();
            }
        });
        JButton close = new JButton(MessageManager.getString("action.close"));
        close.setFont(VERDANA_11PT);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculationChooser.this.close_actionPerformed();
            }
        });
        JPanel actionPanel = new JPanel();
        actionPanel.setOpaque(false);
        actionPanel.add(this.calculate);
        actionPanel.add(close);
        boolean includeParams = false;
        this.add((Component)calcChoicePanel, "Center");
        calcChoicePanel.add(scoreModelPanel);
        if (includeParams) {
            scoreModelPanel.add(paramsPanel);
        }
        this.add((Component)actionPanel, "South");
        int width = 350;
        int height = includeParams ? 420 : 240;
        this.setMinimumSize(new Dimension(325, height - 10));
        String title = MessageManager.getString("label.choose_calculation");
        if (this.af.getViewport().getViewName() != null) {
            title = title + " (" + this.af.getViewport().getViewName() + ")";
        }
        Desktop.addInternalFrame(this.frame, title, width, height, false);
        calcChoicePanel.doLayout();
        this.revalidate();
        this.frame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                CalculationChooser.this.af.alignPanel.setCalculationDialog(null);
            }
        });
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
    }

    protected void validateCalcTypes() {
        int size = this.af.getViewport().getAlignment().getHeight();
        if (this.af.getViewport().getSelectionGroup() != null) {
            size = this.af.getViewport().getSelectionGroup().getSize();
        }
        boolean checkPca = this.checkEnabled(this.pca, size, 4);
        boolean checkNeighbourJoining = this.checkEnabled(this.neighbourJoining, size, 3);
        boolean checkAverageDistance = this.checkEnabled(this.averageDistance, size, 3);
        if (checkPca || checkNeighbourJoining || checkAverageDistance) {
            this.calculate.setToolTipText(null);
            this.calculate.setEnabled(true);
        } else {
            this.calculate.setEnabled(false);
        }
        this.updateScoreModels(this.modelNames, this.tips);
    }

    private boolean checkEnabled(JRadioButton calc, int size, int minsize) {
        String ttip = MessageManager.formatMessage("label.you_need_at_least_n_sequences", minsize);
        calc.setEnabled(size >= minsize);
        if (!calc.isEnabled()) {
            calc.setToolTipText(ttip);
        } else {
            calc.setToolTipText(null);
        }
        if (calc.isSelected()) {
            this.modelNames.setEnabled(calc.isEnabled());
            if (calc.isEnabled()) {
                return true;
            }
            this.calculate.setToolTipText(ttip);
        }
        return false;
    }

    protected JComboBox<String> buildModelOptionsList() {
        final JComboBox<String> scoreModelsCombo = new JComboBox<String>();
        scoreModelsCombo.setRenderer(this.renderer);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                scoreModelsCombo.setToolTipText(CalculationChooser.this.tips.get(scoreModelsCombo.getSelectedIndex()));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                scoreModelsCombo.setToolTipText(null);
            }
        };
        for (Component c : scoreModelsCombo.getComponents()) {
            c.addMouseListener(mouseListener);
        }
        this.updateScoreModels(scoreModelsCombo, this.tips);
        this.renderer.setTooltips(this.tips);
        return scoreModelsCombo;
    }

    private void updateScoreModels(JComboBox<String> comboBox, List<String> toolTips) {
        Object curSel = comboBox.getSelectedItem();
        toolTips.clear();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        boolean nucleotide = this.af.getViewport().getAlignment().isNucleotide();
        List<ScoreModelI> models = CalculationChooser.getApplicableScoreModels(nucleotide, this.pca.isSelected());
        boolean selectedIsPresent = false;
        for (ScoreModelI sm : models) {
            if (curSel != null && sm.getName().equals(curSel)) {
                selectedIsPresent = true;
                curSel = sm.getName();
            }
            model.addElement(sm.getName());
            String tooltip = sm.getDescription();
            if (tooltip == null) {
                tooltip = MessageManager.getStringOrReturn("label.score_model_", sm.getName());
            }
            toolTips.add(tooltip);
        }
        if (selectedIsPresent) {
            model.setSelectedItem(curSel);
        }
        comboBox.setModel(model);
    }

    protected static List<ScoreModelI> getApplicableScoreModels(boolean nucleotide, boolean forPca) {
        ArrayList<ScoreModelI> filtered = new ArrayList<ScoreModelI>();
        ScoreModels scoreModels = ScoreModels.getInstance();
        for (ScoreModelI sm : scoreModels.getModels()) {
            if ((nucleotide || !sm.isProtein()) && (!nucleotide || !sm.isDNA())) continue;
            filtered.add(sm);
        }
        if (nucleotide && forPca && Cache.getDefault("BLOSUM62_PCA_FOR_NUCLEOTIDE", false)) {
            filtered.add(scoreModels.getBlosum62());
        }
        return filtered;
    }

    protected void calculate_actionPerformed() {
        boolean doPCA = this.pca.isSelected();
        String modelName = this.modelNames.getSelectedItem().toString();
        SimilarityParamsI params = this.getSimilarityParameters(doPCA);
        if (doPCA) {
            this.openPcaPanel(modelName, params);
        } else {
            this.openTreePanel(modelName, params);
        }
    }

    protected void openTreePanel(String modelName, SimilarityParamsI params) {
        AlignViewport viewport = this.af.getViewport();
        SequenceGroup sg = viewport.getSelectionGroup();
        if (sg != null && sg.getSize() < 3) {
            JvOptionPane.showMessageDialog(Desktop.desktop, MessageManager.formatMessage("label.you_need_at_least_n_sequences", 3), MessageManager.getString("label.not_enough_sequences"), 2);
            return;
        }
        String treeType = this.neighbourJoining.isSelected() ? "NJ" : "AV";
        this.af.newTreePanel(treeType, modelName, params);
    }

    protected void openPcaPanel(String modelName, SimilarityParamsI params) {
        AlignViewport viewport = this.af.getViewport();
        if (viewport.getSelectionGroup() != null && viewport.getSelectionGroup().getSize() < 4 && viewport.getSelectionGroup().getSize() > 0 || viewport.getAlignment().getHeight() < 4) {
            JvOptionPane.showInternalMessageDialog(this, MessageManager.formatMessage("label.you_need_at_least_n_sequences", 4), MessageManager.getString("label.sequence_selection_insufficient"), 2);
            return;
        }
        this.pcaPanel = new PCAPanel(this.af.alignPanel, modelName, params);
        new Thread(this.pcaPanel).start();
    }

    protected void closeFrame() {
        try {
            this.frame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    protected SimilarityParamsI getSimilarityParameters(boolean doPCA) {
        boolean includeGapGap = true;
        boolean includeGapResidue = true;
        boolean matchOnShortestLength = false;
        boolean matchGap = doPCA ? false : treeMatchGaps;
        return new SimilarityParams(includeGapGap, matchGap, includeGapResidue, matchOnShortestLength);
    }

    protected void close_actionPerformed() {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PCAPanel getPcaPanel() {
        return this.pcaPanel;
    }
}

