/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JalviewJmolBinding;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppJmol;
import jalview.gui.IProgressIndicator;
import jalview.gui.SeqPanel;
import jalview.gui.SequenceRenderer;
import jalview.io.DataSourceType;
import jalview.structure.StructureSelectionManager;
import jalview.util.BrowserLauncher;
import java.awt.Container;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolViewer;
import org.jmol.java.BS;
import org.openscience.jmol.app.jmolpanel.console.AppConsole;

public class AppJmolBinding
extends JalviewJmolBinding {
    private AppJmol appJmolWindow;

    public AppJmolBinding(AppJmol appJmol, StructureSelectionManager sSm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(sSm, pdbentry, sequenceIs, protocol);
        this.appJmolWindow = appJmol;
    }

    @Override
    protected IProgressIndicator getIProgressIndicator() {
        return this.appJmolWindow.progressBar;
    }

    @Override
    public SequenceRenderer getSequenceRenderer(AlignmentViewPanel alignment) {
        return new SequenceRenderer(((AlignmentPanel)alignment).av);
    }

    @Override
    public void sendConsoleEcho(String strEcho) {
        if (this.console != null) {
            this.console.sendConsoleEcho(strEcho);
        }
    }

    @Override
    public void sendConsoleMessage(String strStatus) {
        if (this.console != null && strStatus != null) {
            this.console.sendConsoleMessage(strStatus);
        }
    }

    @Override
    public void showUrl(String url, String target) {
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception e) {
            Cache.log.error((Object)("Failed to launch Jmol-associated url " + url), (Throwable)e);
        }
    }

    @Override
    public void refreshGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppJmolBinding.this.appJmolWindow.updateTitleAndMenus();
                AppJmolBinding.this.appJmolWindow.revalidate();
            }
        });
    }

    @Override
    public void updateColours(Object source) {
        AlignmentPanel ap = (AlignmentPanel)source;
        if (!this.appJmolWindow.isUsedforcolourby(ap)) {
            return;
        }
        if (!this.isLoadingFromArchive()) {
            this.colourBySequence(ap);
        }
    }

    @Override
    public void notifyScriptTermination(String strStatus, int msWalltime) {
    }

    public void showUrl(String url) {
        this.showUrl(url, "jmol");
    }

    public void newJmolPopup(String menuName) {
    }

    public void selectionChanged(BS arg0) {
    }

    @Override
    public void refreshPdbEntries() {
    }

    @Override
    public void showConsole(boolean b) {
        this.appJmolWindow.showConsole(b);
    }

    @Override
    protected JmolAppConsoleInterface createJmolConsole(Container consolePanel, String buttonsToShow) {
        this.viewer.setJmolCallbackListener((JmolCallbackListener)this);
        return new AppConsole((JmolViewer)this.viewer, consolePanel, buttonsToShow);
    }

    @Override
    protected void releaseUIResources() {
        this.appJmolWindow = null;
        this.closeConsole();
    }

    @Override
    public void releaseReferences(Object svl) {
        if (svl instanceof SeqPanel) {
            this.appJmolWindow.removeAlignmentPanel(((SeqPanel)svl).ap);
        }
    }

    public Map<String, Object> getJSpecViewProperty(String arg0) {
        return null;
    }

    @Override
    public JalviewStructureDisplayI getViewer() {
        return this.appJmolWindow;
    }

    @Override
    public FeatureRenderer getFeatureRenderer(AlignmentViewPanel alignment) {
        AlignmentPanel ap;
        AlignmentPanel alignmentPanel = ap = alignment == null ? this.appJmolWindow.getAlignmentPanel() : (AlignmentPanel)alignment;
        if (ap.av.isShowSequenceFeatures()) {
            return ap.av.getAlignPanel().getSeqPanel().seqCanvas.fr;
        }
        return null;
    }
}

