/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.util.MessageManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AnnotationRowFilter
extends JPanel {
    protected AlignViewport av;
    protected AlignmentPanel ap;
    protected int[] annmap;
    protected boolean adjusting = false;
    protected JCheckBox seqAssociated = new JCheckBox();
    protected JCheckBox percentThreshold = new JCheckBox();
    protected JSlider slider = new JSlider();
    protected JTextField thresholdValue = new JTextField(20);
    protected JInternalFrame frame;
    protected JButton ok = new JButton();
    protected JButton cancel = new JButton();
    protected boolean sliderDragging = false;
    protected JComboBox<String> threshold = new JComboBox();
    protected JComboBox<String> annotations;
    private Map<AlignmentAnnotation, String> annotationLabels;
    private AlignmentAnnotation currentAnnotation;

    public AnnotationRowFilter(AlignViewport viewport, AlignmentPanel alignPanel) {
        this.av = viewport;
        this.ap = alignPanel;
        this.thresholdValue.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AnnotationRowFilter.this.thresholdValue_actionPerformed();
            }
        });
    }

    protected void addSliderChangeListener() {
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (!AnnotationRowFilter.this.adjusting) {
                    AnnotationRowFilter.this.setThresholdValueText();
                    AnnotationRowFilter.this.valueChanged(!AnnotationRowFilter.this.sliderDragging);
                }
            }
        });
    }

    protected void setThresholdValueText() {
        boolean oldadj = this.adjusting;
        this.adjusting = true;
        if (this.percentThreshold.isSelected()) {
            this.thresholdValue.setText("" + (float)(this.slider.getValue() - this.slider.getMinimum()) * 100.0f / (float)(this.slider.getMaximum() - this.slider.getMinimum()));
        } else {
            this.thresholdValue.setText((float)this.slider.getValue() / 1000.0f + "");
        }
        this.adjusting = oldadj;
    }

    protected void addSliderMouseListeners() {
        this.slider.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                AnnotationRowFilter.this.sliderDragging = true;
                super.mousePressed(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                AnnotationRowFilter.this.sliderDragging = true;
                super.mouseDragged(e);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AnnotationRowFilter.this.sliderDragReleased();
            }
        });
    }

    public Vector<String> getAnnotationItems(boolean isSeqAssociated) {
        this.annotationLabels = new HashMap<AlignmentAnnotation, String>();
        Vector<String> list = new Vector<String>();
        int index = 1;
        int[] anmap = new int[this.av.getAlignment().getAlignmentAnnotation().length];
        this.seqAssociated.setEnabled(false);
        for (int i = 0; i < this.av.getAlignment().getAlignmentAnnotation().length; ++i) {
            AlignmentAnnotation annotation = this.av.getAlignment().getAlignmentAnnotation()[i];
            if (annotation.sequenceRef == null) {
                if (isSeqAssociated) {
                    continue;
                }
            } else {
                this.seqAssociated.setEnabled(true);
            }
            String label = annotation.label;
            if (!isSeqAssociated && annotation.sequenceRef != null) {
                label = label + "_" + annotation.sequenceRef.getName();
            }
            if (!list.contains(label)) {
                anmap[list.size()] = i;
                list.add(label);
                this.annotationLabels.put(annotation, label);
                continue;
            }
            if (isSeqAssociated) continue;
            anmap[list.size()] = i;
            label = label + "_" + index++;
            list.add(label);
            this.annotationLabels.put(annotation, label);
        }
        this.annmap = new int[list.size()];
        System.arraycopy(anmap, 0, this.annmap, 0, this.annmap.length);
        return list;
    }

    protected int getSelectedThresholdItem(int indexValue) {
        int selectedThresholdItem = -1;
        if (indexValue == 1) {
            selectedThresholdItem = 1;
        } else if (indexValue == 2) {
            selectedThresholdItem = 0;
        }
        return selectedThresholdItem;
    }

    public void ok_actionPerformed() {
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cancel_actionPerformed() {
        this.reset();
        this.ap.paintAlignment(true, true);
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void thresholdCheck_actionPerformed() {
        this.updateView();
    }

    protected void selectedAnnotationChanged() {
        this.updateView();
    }

    protected void threshold_actionPerformed() {
        this.updateView();
    }

    protected void thresholdValue_actionPerformed() {
        try {
            float f = Float.parseFloat(this.thresholdValue.getText());
            if (this.percentThreshold.isSelected()) {
                this.slider.setValue(this.slider.getMinimum() + (int)(f / 100.0f * (float)(this.slider.getMaximum() - this.slider.getMinimum())));
            } else {
                this.slider.setValue((int)(f * 1000.0f));
            }
            this.updateView();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void percentageValue_actionPerformed() {
        this.setThresholdValueText();
    }

    protected void thresholdIsMin_actionPerformed() {
        this.updateView();
    }

    protected void populateThresholdComboBox(JComboBox<String> thresh) {
        thresh.addItem(MessageManager.getString("label.threshold_feature_no_threshold"));
        thresh.addItem(MessageManager.getString("label.threshold_feature_above_threshold"));
        thresh.addItem(MessageManager.getString("label.threshold_feature_below_threshold"));
    }

    protected void seqAssociated_actionPerformed(JComboBox<String> anns) {
        this.adjusting = true;
        String cursel = (String)anns.getSelectedItem();
        boolean isvalid = false;
        boolean isseqs = this.seqAssociated.isSelected();
        anns.removeAllItems();
        for (String anitem : this.getAnnotationItems(this.seqAssociated.isSelected())) {
            if (anitem.equals(cursel) || isseqs && cursel.startsWith(anitem)) {
                isvalid = true;
                cursel = anitem;
            }
            anns.addItem(anitem);
        }
        if (isvalid) {
            anns.setSelectedItem(cursel);
        } else if (anns.getItemCount() > 0) {
            anns.setSelectedIndex(0);
        }
        this.adjusting = false;
        this.updateView();
    }

    protected void propagateSeqAssociatedThreshold(boolean allAnnotation, AlignmentAnnotation annotation) {
        if (annotation.sequenceRef == null || annotation.threshold == null) {
            return;
        }
        float thr = annotation.threshold.value;
        for (int i = 0; i < this.av.getAlignment().getAlignmentAnnotation().length; ++i) {
            AlignmentAnnotation aa = this.av.getAlignment().getAlignmentAnnotation()[i];
            if (!aa.label.equals(annotation.label) || !(annotation.getCalcId() == null ? aa.getCalcId() == null : annotation.getCalcId().equals(aa.getCalcId()))) continue;
            if (aa.threshold == null) {
                aa.threshold = new GraphLine(annotation.threshold);
                continue;
            }
            aa.threshold.value = thr;
        }
    }

    public AlignmentAnnotation getCurrentAnnotation() {
        return this.currentAnnotation;
    }

    protected void setCurrentAnnotation(AlignmentAnnotation annotation) {
        this.currentAnnotation = annotation;
    }

    protected abstract void valueChanged(boolean var1);

    protected abstract void updateView();

    protected abstract void reset();

    protected String getAnnotationMenuLabel(AlignmentAnnotation ann) {
        return this.annotationLabels.get(ann);
    }

    protected void jbInit() {
        this.ok.setOpaque(false);
        this.ok.setText(MessageManager.getString("action.ok"));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationRowFilter.this.ok_actionPerformed();
            }
        });
        this.cancel.setOpaque(false);
        this.cancel.setText(MessageManager.getString("action.cancel"));
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationRowFilter.this.cancel_actionPerformed();
            }
        });
        this.annotations.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AnnotationRowFilter.this.selectedAnnotationChanged();
            }
        });
        this.annotations.setToolTipText(MessageManager.getString("info.select_annotation_row"));
        this.threshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationRowFilter.this.threshold_actionPerformed();
            }
        });
        this.thresholdValue.setEnabled(false);
        this.thresholdValue.setColumns(7);
        this.thresholdValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationRowFilter.this.thresholdValue_actionPerformed();
            }
        });
        this.percentThreshold.setText(MessageManager.getString("label.as_percentage"));
        this.percentThreshold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AnnotationRowFilter.this.adjusting) {
                    AnnotationRowFilter.this.percentageValue_actionPerformed();
                }
            }
        });
        this.slider.setPaintLabels(false);
        this.slider.setPaintTicks(true);
        this.slider.setBackground(Color.white);
        this.slider.setEnabled(false);
        this.slider.setOpaque(false);
        this.slider.setPreferredSize(new Dimension(100, 32));
    }

    public JComboBox<String> getThreshold() {
        return this.threshold;
    }

    public void setThreshold(JComboBox<String> thresh) {
        this.threshold = thresh;
    }

    public JComboBox<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(JComboBox<String> anns) {
        this.annotations = anns;
    }

    protected void sliderDragReleased() {
        if (this.sliderDragging) {
            this.sliderDragging = false;
            this.valueChanged(true);
        }
    }
}

