/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.GraphLine;
import jalview.datamodel.SequenceGroup;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationRowFilter;
import jalview.gui.Desktop;
import jalview.gui.JvSwingUtils;
import jalview.schemes.AnnotationColourGradient;
import jalview.schemes.ColourSchemeI;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class AnnotationColourChooser
extends AnnotationRowFilter {
    private static final int ONETHOUSAND = 1000;
    private ColourSchemeI oldcs;
    private JButton defColours;
    private Hashtable<SequenceGroup, ColourSchemeI> oldgroupColours;
    private JCheckBox useOriginalColours = new JCheckBox();
    private JPanel minColour = new JPanel();
    private JPanel maxColour = new JPanel();
    private JCheckBox thresholdIsMin = new JCheckBox();
    protected static final int MIN_WIDTH = 500;
    protected static final int MIN_HEIGHT = 240;

    public AnnotationColourChooser(AlignViewport av, AlignmentPanel ap) {
        super(av, ap);
        this.oldcs = av.getGlobalColourScheme();
        if (av.getAlignment().getGroups() != null) {
            this.oldgroupColours = new Hashtable();
            for (SequenceGroup sg : ap.av.getAlignment().getGroups()) {
                if (sg.getColourScheme() == null) continue;
                this.oldgroupColours.put(sg, sg.getColourScheme());
            }
        }
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.frame.setLayer(JLayeredPane.PALETTE_LAYER);
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.colour_by_annotation"), 520, 215);
        this.frame.setMinimumSize(new Dimension(500, 240));
        this.addSliderChangeListener();
        this.addSliderMouseListeners();
        if (av.getAlignment().getAlignmentAnnotation() == null) {
            return;
        }
        this.setDefaultMinMax();
        this.adjusting = true;
        if (this.oldcs instanceof AnnotationColourGradient) {
            AnnotationColourGradient acg = (AnnotationColourGradient)this.oldcs;
            this.useOriginalColours.setSelected(acg.isPredefinedColours() || acg.getBaseColour() != null);
            if (!acg.isPredefinedColours() && acg.getBaseColour() == null) {
                this.minColour.setBackground(acg.getMinColour());
                this.maxColour.setBackground(acg.getMaxColour());
            }
            this.seqAssociated.setSelected(acg.isSeqAssociated());
        }
        Vector<String> annotItems = this.getAnnotationItems(this.seqAssociated.isSelected());
        this.annotations = new JComboBox<String>(annotItems);
        this.populateThresholdComboBox(this.threshold);
        if (this.oldcs instanceof AnnotationColourGradient) {
            AnnotationColourGradient acg = (AnnotationColourGradient)this.oldcs;
            String label = this.getAnnotationMenuLabel(acg.getAnnotation());
            this.annotations.setSelectedItem(label);
            switch (acg.getAboveThreshold()) {
                case -1: {
                    this.getThreshold().setSelectedIndex(0);
                    break;
                }
                case 1: {
                    this.getThreshold().setSelectedIndex(1);
                    break;
                }
                case 0: {
                    this.getThreshold().setSelectedIndex(2);
                    break;
                }
                default: {
                    throw new Error(MessageManager.getString("error.implementation_error_dont_know_about_threshold_setting"));
                }
            }
            this.thresholdIsMin.setSelected(acg.isThresholdIsMinMax());
            this.thresholdValue.setText("" + acg.getAnnotationThreshold());
        }
        this.jbInit();
        this.adjusting = false;
        this.updateView();
        this.frame.invalidate();
        this.frame.pack();
    }

    @Override
    protected void jbInit() {
        super.jbInit();
        this.minColour.setFont(JvSwingUtils.getLabelFont());
        this.minColour.setBorder(BorderFactory.createEtchedBorder());
        this.minColour.setPreferredSize(new Dimension(40, 20));
        this.minColour.setToolTipText(MessageManager.getString("label.min_colour"));
        this.minColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AnnotationColourChooser.this.minColour.isEnabled()) {
                    AnnotationColourChooser.this.minColour_actionPerformed();
                }
            }
        });
        this.maxColour.setFont(JvSwingUtils.getLabelFont());
        this.maxColour.setBorder(BorderFactory.createEtchedBorder());
        this.maxColour.setPreferredSize(new Dimension(40, 20));
        this.maxColour.setToolTipText(MessageManager.getString("label.max_colour"));
        this.maxColour.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (AnnotationColourChooser.this.maxColour.isEnabled()) {
                    AnnotationColourChooser.this.maxColour_actionPerformed();
                }
            }
        });
        this.defColours = new JButton();
        this.defColours.setOpaque(false);
        this.defColours.setText(MessageManager.getString("action.set_defaults"));
        this.defColours.setToolTipText(MessageManager.getString("label.reset_min_max_colours_to_defaults"));
        this.defColours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AnnotationColourChooser.this.resetColours_actionPerformed();
            }
        });
        this.useOriginalColours.setFont(JvSwingUtils.getLabelFont());
        this.useOriginalColours.setOpaque(false);
        this.useOriginalColours.setText(MessageManager.getString("label.use_original_colours"));
        this.useOriginalColours.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnnotationColourChooser.this.originalColours_actionPerformed();
            }
        });
        this.thresholdIsMin.setBackground(Color.white);
        this.thresholdIsMin.setFont(JvSwingUtils.getLabelFont());
        this.thresholdIsMin.setText(MessageManager.getString("label.threshold_minmax"));
        this.thresholdIsMin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AnnotationColourChooser.this.thresholdIsMin_actionPerformed();
            }
        });
        this.seqAssociated.setBackground(Color.white);
        this.seqAssociated.setFont(JvSwingUtils.getLabelFont());
        this.seqAssociated.setText(MessageManager.getString("label.per_sequence_only"));
        this.seqAssociated.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AnnotationColourChooser.this.seqAssociated_actionPerformed(AnnotationColourChooser.this.annotations);
            }
        });
        this.setLayout(new BorderLayout());
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new MigLayout("", "[left][center][right]", "[][][]"));
        jPanel1.setBackground(Color.white);
        jPanel2.setBackground(Color.white);
        jPanel1.add(this.ok);
        jPanel1.add(this.cancel);
        jPanel2.add((Component)this.annotations, "grow, wrap");
        jPanel2.add(this.seqAssociated);
        jPanel2.add(this.useOriginalColours);
        JPanel colpanel = new JPanel(new FlowLayout());
        colpanel.setBackground(Color.white);
        colpanel.add(this.minColour);
        colpanel.add(this.maxColour);
        jPanel2.add((Component)colpanel, "wrap");
        jPanel2.add(this.getThreshold());
        jPanel2.add((Component)this.defColours, "skip 1, wrap");
        jPanel2.add(this.thresholdIsMin);
        jPanel2.add((Component)this.slider, "grow");
        jPanel2.add((Component)this.thresholdValue, "grow");
        this.add((Component)jPanel1, "South");
        this.add((Component)jPanel2, "Center");
        this.validate();
    }

    protected void resetColours_actionPerformed() {
        this.setDefaultMinMax();
        this.updateView();
    }

    private void setDefaultMinMax() {
        this.minColour.setBackground(Cache.getDefaultColour("ANNOTATIONCOLOUR_MIN", Color.orange));
        this.maxColour.setBackground(Cache.getDefaultColour("ANNOTATIONCOLOUR_MAX", Color.red));
    }

    public void minColour_actionPerformed() {
        Color col = JColorChooser.showDialog(this, MessageManager.getString("label.select_colour_minimum_value"), this.minColour.getBackground());
        if (col != null) {
            this.minColour.setBackground(col);
        }
        this.minColour.repaint();
        this.updateView();
    }

    public void maxColour_actionPerformed() {
        Color col = JColorChooser.showDialog(this, MessageManager.getString("label.select_colour_maximum_value"), this.maxColour.getBackground());
        if (col != null) {
            this.maxColour.setBackground(col);
        }
        this.maxColour.repaint();
        this.updateView();
    }

    @Override
    public void reset() {
        this.ap.alignFrame.changeColour(this.oldcs);
        if (this.av.getAlignment().getGroups() != null) {
            for (SequenceGroup sg : this.ap.av.getAlignment().getGroups()) {
                sg.setColourScheme(this.oldgroupColours.get(sg));
            }
        }
    }

    @Override
    public void valueChanged(boolean updateAllAnnotation) {
        if (this.slider.isEnabled()) {
            if (this.useOriginalColours.isSelected() && !(this.av.getGlobalColourScheme() instanceof AnnotationColourGradient)) {
                this.updateView();
            }
            this.getCurrentAnnotation().threshold.value = (float)this.slider.getValue() / 1000.0f;
            this.propagateSeqAssociatedThreshold(updateAllAnnotation, this.getCurrentAnnotation());
            this.ap.paintAlignment(false, false);
        }
    }

    public void originalColours_actionPerformed() {
        boolean selected = this.useOriginalColours.isSelected();
        if (selected) {
            this.reset();
        }
        this.maxColour.setEnabled(!selected);
        this.minColour.setEnabled(!selected);
        this.thresholdIsMin.setEnabled(!selected);
        this.updateView();
    }

    @Override
    public void updateView() {
        if (this.adjusting) {
            return;
        }
        this.setCurrentAnnotation(this.av.getAlignment().getAlignmentAnnotation()[this.annmap[this.annotations.getSelectedIndex()]]);
        int selectedThresholdItem = this.getSelectedThresholdItem(this.getThreshold().getSelectedIndex());
        this.slider.setEnabled(true);
        this.thresholdValue.setEnabled(true);
        this.thresholdIsMin.setEnabled(!this.useOriginalColours.isSelected());
        if (selectedThresholdItem == -1) {
            this.slider.setEnabled(false);
            this.thresholdValue.setEnabled(false);
            this.thresholdValue.setText("");
            this.thresholdIsMin.setEnabled(false);
        } else if (selectedThresholdItem != -1 && this.getCurrentAnnotation().threshold == null) {
            this.getCurrentAnnotation().setThreshold(new GraphLine((this.getCurrentAnnotation().graphMax - this.getCurrentAnnotation().graphMin) / 2.0f, "Threshold", Color.black));
        }
        if (selectedThresholdItem != -1) {
            this.adjusting = true;
            float range = this.getCurrentAnnotation().graphMax * 1000.0f - this.getCurrentAnnotation().graphMin * 1000.0f;
            this.slider.setMinimum((int)(this.getCurrentAnnotation().graphMin * 1000.0f));
            this.slider.setMaximum((int)(this.getCurrentAnnotation().graphMax * 1000.0f));
            this.slider.setValue((int)(this.getCurrentAnnotation().threshold.value * 1000.0f));
            this.thresholdValue.setText(this.getCurrentAnnotation().threshold.value + "");
            this.slider.setMajorTickSpacing((int)(range / 10.0f));
            this.slider.setEnabled(true);
            this.thresholdValue.setEnabled(true);
            this.adjusting = false;
        }
        this.colorAlignmentContaining(this.getCurrentAnnotation(), selectedThresholdItem);
        this.ap.alignmentChanged();
    }

    protected void colorAlignmentContaining(AlignmentAnnotation currentAnn, int selectedThresholdOption) {
        AnnotationColourGradient acg = null;
        acg = this.useOriginalColours.isSelected() ? new AnnotationColourGradient(currentAnn, this.av.getGlobalColourScheme(), selectedThresholdOption) : new AnnotationColourGradient(currentAnn, this.minColour.getBackground(), this.maxColour.getBackground(), selectedThresholdOption);
        acg.setSeqAssociated(this.seqAssociated.isSelected());
        if (currentAnn.graphMin == 0.0f && currentAnn.graphMax == 0.0f) {
            acg.setPredefinedColours(true);
        }
        acg.setThresholdIsMinMax(this.thresholdIsMin.isSelected());
        this.ap.alignFrame.changeColour(acg);
        if (this.av.getAlignment().getGroups() != null) {
            for (SequenceGroup sg : this.ap.av.getAlignment().getGroups()) {
                if (sg.cs == null) continue;
                sg.setColourScheme(acg.getInstance(this.av, sg));
            }
        }
    }

    @Override
    protected void sliderDragReleased() {
        super.sliderDragReleased();
        this.ap.paintAlignment(true, true);
    }
}

