/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.uniprot;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import jalview.bin.Cache;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.core.FTSRestClient;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.util.MessageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class UniProtFTSRestClient
extends FTSRestClient {
    private static final String DEFAULT_UNIPROT_DOMAIN = "https://www.uniprot.org";
    private static FTSRestClientI instance = null;
    public final String uniprotSearchEndpoint = Cache.getDefault("UNIPROT_DOMAIN", "https://www.uniprot.org") + "/uniprot/?";

    @Override
    public FTSRestResponse executeRequest(FTSRestRequest uniportRestRequest) throws Exception {
        try {
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            Client client = Client.create((ClientConfig)clientConfig);
            String wantedFields = this.getDataColumnsFieldsAsCommaDelimitedString(uniportRestRequest.getWantedFields());
            int responseSize = uniportRestRequest.getResponseSize() == 0 ? this.getDefaultResponsePageSize() : uniportRestRequest.getResponseSize();
            int offSet = uniportRestRequest.getOffSet();
            String query = this.isAdvancedQuery(uniportRestRequest.getSearchTerm()) ? uniportRestRequest.getSearchTerm() : (uniportRestRequest.getFieldToSearchBy().equalsIgnoreCase("Search All") ? uniportRestRequest.getSearchTerm() + " or mnemonic:" + uniportRestRequest.getSearchTerm() : uniportRestRequest.getFieldToSearchBy() + ":" + uniportRestRequest.getSearchTerm());
            WebResource webResource = null;
            webResource = client.resource(this.uniprotSearchEndpoint).queryParam("format", "tab").queryParam("columns", wantedFields).queryParam("limit", String.valueOf(responseSize)).queryParam("offset", String.valueOf(offSet)).queryParam("sort", "score").queryParam("query", query);
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"text/plain"}).get(ClientResponse.class);
            String uniProtTabDelimittedResponseString = (String)clientResponse.getEntity(String.class);
            if (clientResponse.getStatus() != 200) {
                String errorMessage = UniProtFTSRestClient.getMessageByHTTPStatusCode(clientResponse.getStatus(), "Uniprot");
                throw new Exception(errorMessage);
            }
            int xTotalResults = Integer.valueOf((String)((List)clientResponse.getHeaders().get((Object)"X-Total-Results")).get(0));
            clientResponse = null;
            client = null;
            return this.parseUniprotResponse(uniProtTabDelimittedResponseString, uniportRestRequest, xTotalResults);
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg.contains("SocketException")) {
                throw new Exception(MessageManager.getString("exception.unable_to_detect_internet_connection"));
            }
            if (exceptionMsg.contains("UnknownHostException")) {
                throw new Exception(MessageManager.formatMessage("exception.fts_server_unreachable", "Uniprot"));
            }
            throw e;
        }
    }

    public boolean isAdvancedQuery(String query) {
        return query.contains(" AND ") || query.contains(" OR ") || query.contains(" NOT ") || query.contains(" ! ") || query.contains(" || ") || query.contains(" && ") || query.contains(":") || query.contains("-");
    }

    public FTSRestResponse parseUniprotResponse(String uniProtTabDelimittedResponseString, FTSRestRequest uniprotRestRequest, int xTotalResults) {
        FTSRestResponse searchResult = new FTSRestResponse();
        ArrayList<FTSData> result = null;
        if (uniProtTabDelimittedResponseString == null || uniProtTabDelimittedResponseString.trim().isEmpty()) {
            searchResult.setNumberOfItemsFound(0);
            return searchResult;
        }
        String[] foundDataRow = uniProtTabDelimittedResponseString.split("\n");
        if (foundDataRow != null && foundDataRow.length > 0) {
            result = new ArrayList<FTSData>();
            boolean firstRow = true;
            for (String dataRow : foundDataRow) {
                if (firstRow) {
                    firstRow = false;
                    continue;
                }
                result.add(UniProtFTSRestClient.getFTSData(dataRow, uniprotRestRequest));
            }
            searchResult.setNumberOfItemsFound(xTotalResults);
            searchResult.setSearchSummary(result);
        }
        return searchResult;
    }

    private String getDataColumnsFieldsAsTabDelimitedString(Collection<FTSDataColumnI> dataColumnFields) {
        String result = "";
        if (dataColumnFields != null && !dataColumnFields.isEmpty()) {
            StringBuilder returnedFields = new StringBuilder();
            for (FTSDataColumnI field : dataColumnFields) {
                if (field.getName().equalsIgnoreCase("Uniprot Id")) {
                    returnedFields.append("\t").append("Entry");
                    continue;
                }
                returnedFields.append("\t").append(field.getName());
            }
            returnedFields.deleteCharAt(0);
            result = returnedFields.toString();
        }
        return result;
    }

    public static FTSData getFTSData(String tabDelimittedDataStr, FTSRestRequest request) {
        String primaryKey = null;
        Collection<FTSDataColumnI> diplayFields = request.getWantedFields();
        int colCounter = 0;
        Object[] summaryRowData = new Object[diplayFields.size()];
        String[] columns = tabDelimittedDataStr.split("\t");
        for (FTSDataColumnI field : diplayFields) {
            try {
                String fieldData = columns[colCounter];
                if (field.isPrimaryKeyColumn()) {
                    primaryKey = fieldData;
                    summaryRowData[colCounter++] = primaryKey;
                    continue;
                }
                if (fieldData == null || fieldData.isEmpty()) {
                    summaryRowData[colCounter++] = null;
                    continue;
                }
                try {
                    summaryRowData[colCounter++] = field.getDataType().getDataTypeClass() == Integer.class ? Integer.valueOf(fieldData.replace(",", "")) : (field.getDataType().getDataTypeClass() == Double.class ? Double.valueOf(fieldData) : fieldData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("offending value:" + fieldData);
                }
            }
            catch (Exception exception) {}
        }
        final String primaryKey1 = primaryKey;
        final Object[] summaryRowData1 = summaryRowData;
        return new FTSData(){

            @Override
            public Object[] getSummaryData() {
                return summaryRowData1;
            }

            @Override
            public Object getPrimaryKey() {
                return primaryKey1;
            }

            public String toString() {
                StringBuilder summaryFieldValues = new StringBuilder();
                for (Object summaryField : summaryRowData1) {
                    summaryFieldValues.append(summaryField == null ? " " : summaryField.toString()).append("\t");
                }
                return summaryFieldValues.toString();
            }

            public int hashCode() {
                return Objects.hash(primaryKey1, this.toString());
            }

            public boolean equals(Object that) {
                return this.toString().equals(that.toString());
            }
        };
    }

    public static FTSRestClientI getInstance() {
        if (instance == null) {
            instance = new UniProtFTSRestClient();
        }
        return instance;
    }

    @Override
    public String getColumnDataConfigFileName() {
        return "/fts/uniprot_data_columns.txt";
    }
}

