/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.rbvi.chimera;

import ext.edu.ucsf.rbvi.strucviz2.ChimeraManager;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import jalview.api.AlignmentViewPanel;
import jalview.api.SequenceRenderer;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.rbvi.chimera.ChimeraCommands;
import jalview.ext.rbvi.chimera.ChimeraListener;
import jalview.httpserver.AbstractRequestHandler;
import jalview.io.DataSourceType;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ResidueProperties;
import jalview.structure.AtomSpec;
import jalview.structure.StructureMappingcommandSet;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.MessageManager;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class JalviewChimeraBinding
extends AAStructureBindingModel {
    public static final String CHIMERA_FEATURE_GROUP = "Chimera";
    private static final String NO_ALTLOCS = "&~@.B-Z&~@.2-9";
    private static final String COLOURING_CHIMERA = MessageManager.getString("status.colouring_chimera");
    private static final boolean debug = false;
    private static final String PHOSPHORUS = "P";
    private static final String ALPHACARBON = "CA";
    private List<String> chainNames = new ArrayList<String>();
    private Hashtable<String, String> chainFile = new Hashtable();
    private ChimeraManager viewer;
    private AbstractRequestHandler chimeraListener;
    private boolean loadingFromArchive = false;
    private boolean loadingFinished = true;
    private Map<String, List<ChimeraModel>> chimeraMaps = new LinkedHashMap<String, List<ChimeraModel>>();
    String lastHighlightCommand;
    private long loadNotifiesHandled = 0L;
    private Thread chimeraMonitor;
    private int[] _modelFileNameMap;

    public boolean openFile(PDBEntry pe) {
        String file = pe.getFile();
        try {
            ArrayList<ChimeraModel> modelsToMap = new ArrayList<ChimeraModel>();
            List<ChimeraModel> oldList = this.viewer.getModelList();
            boolean alreadyOpen = false;
            for (ChimeraModel open : oldList) {
                if (!open.getModelName().equals(pe.getId())) continue;
                alreadyOpen = true;
                modelsToMap.add(open);
            }
            if (!alreadyOpen) {
                this.viewer.openModel(file, pe.getId(), StructureManager.ModelType.PDB_MODEL);
                List<ChimeraModel> newList = this.viewer.getModelList();
                for (ChimeraModel cm : newList) {
                    if (!cm.getModelName().equals(pe.getId())) continue;
                    modelsToMap.add(cm);
                }
            }
            this.chimeraMaps.put(file, modelsToMap);
            if (this.getSsm() != null) {
                this.getSsm().addStructureViewerListener(this);
            }
            return true;
        }
        catch (Exception q) {
            this.log("Exception when trying to open model " + file + "\n" + q.toString());
            q.printStackTrace();
            return false;
        }
    }

    public JalviewChimeraBinding(StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(ssm, pdbentry, sequenceIs, protocol);
        this.viewer = new ChimeraManager(new StructureManager(true));
    }

    protected void startChimeraProcessMonitor() {
        final Process p = this.viewer.getChimeraProcess();
        this.chimeraMonitor = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    p.waitFor();
                    JalviewStructureDisplayI display = JalviewChimeraBinding.this.getViewer();
                    if (display != null) {
                        display.closeViewer(false);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.chimeraMonitor.start();
    }

    public void startChimeraListener() {
        try {
            this.chimeraListener = new ChimeraListener(this);
            this.viewer.startListening(this.chimeraListener.getUri());
        }
        catch (BindException e) {
            System.err.println("Failed to start Chimera listener: " + e.getMessage());
        }
    }

    public void showChains(List<String> toshow) {
        StringBuilder cmd = new StringBuilder(64);
        boolean first = true;
        for (String chain : toshow) {
            String showChainCmd;
            int modelNumber = this.getModelNoForChain(chain);
            String string = showChainCmd = modelNumber == -1 ? "" : modelNumber + ":." + chain.split(":")[1];
            if (!first) {
                cmd.append(",");
            }
            cmd.append(showChainCmd);
            first = false;
        }
        String command = "~display #*; ~ribbon #*; ribbon :" + cmd.toString();
        this.sendChimeraCommand(command, false);
    }

    public void closeViewer(boolean closeChimera) {
        this.getSsm().removeStructureViewerListener(this, this.getStructureFiles());
        if (closeChimera) {
            this.viewer.exitChimera();
        }
        if (this.chimeraListener != null) {
            this.chimeraListener.shutdown();
            this.chimeraListener = null;
        }
        this.viewer = null;
        if (this.chimeraMonitor != null) {
            this.chimeraMonitor.interrupt();
        }
        this.releaseUIResources();
    }

    @Override
    public void colourByChain() {
        this.colourBySequence = false;
        this.sendAsynchronousCommand("rainbow chain", COLOURING_CHIMERA);
    }

    @Override
    public void colourByCharge() {
        this.colourBySequence = false;
        String command = "color white;color red ::ASP;color red ::GLU;color blue ::LYS;color blue ::ARG;color yellow ::CYS";
        this.sendAsynchronousCommand(command, COLOURING_CHIMERA);
    }

    @Override
    public String superposeStructures(AlignmentI[] _alignment, int[] _refStructure, HiddenColumns[] _hiddenCols) {
        StringBuilder allComs = new StringBuilder(128);
        String[] files = this.getStructureFiles();
        if (!this.waitForFileLoad(files)) {
            return null;
        }
        this.refreshPdbEntries();
        StringBuilder selectioncom = new StringBuilder(256);
        for (int a = 0; a < _alignment.length; ++a) {
            int nmatched;
            int refStructure = _refStructure[a];
            AlignmentI alignment = _alignment[a];
            HiddenColumns hiddenCols = _hiddenCols[a];
            if (refStructure >= files.length) {
                System.err.println("Ignoring invalid reference structure value " + refStructure);
                refStructure = -1;
            }
            BitSet matched = new BitSet();
            for (int m = 0; m < alignment.getWidth(); ++m) {
                if (hiddenCols != null && !hiddenCols.isVisible(m)) continue;
                matched.set(m);
            }
            AAStructureBindingModel.SuperposeData[] structures = new AAStructureBindingModel.SuperposeData[files.length];
            for (int f = 0; f < files.length; ++f) {
                structures[f] = new AAStructureBindingModel.SuperposeData(this, alignment.getWidth());
            }
            int candidateRefStructure = this.findSuperposableResidues(alignment, matched, structures);
            if (refStructure < 0) {
                refStructure = candidateRefStructure;
            }
            if ((nmatched = matched.cardinality()) < 4) {
                return MessageManager.formatMessage("label.insufficient_residues", nmatched);
            }
            String[] selcom = new String[files.length];
            for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
                String chainCd = "." + structures[pdbfnum].chain;
                int lpos = -1;
                boolean run = false;
                StringBuilder molsel = new StringBuilder();
                int nextColumnMatch = matched.nextSetBit(0);
                while (nextColumnMatch != -1) {
                    int pdbResNum = structures[pdbfnum].pdbResNo[nextColumnMatch];
                    if (lpos != pdbResNum - 1) {
                        if (lpos != -1) {
                            molsel.append(String.valueOf(lpos));
                            molsel.append(chainCd);
                            molsel.append(",");
                        }
                        run = false;
                    } else {
                        if (!run) {
                            molsel.append(String.valueOf(lpos));
                            molsel.append("-");
                        }
                        run = true;
                    }
                    lpos = pdbResNum;
                    nextColumnMatch = matched.nextSetBit(nextColumnMatch + 1);
                }
                if (lpos != -1) {
                    molsel.append(String.valueOf(lpos));
                    molsel.append(chainCd);
                }
                if (molsel.length() > 1) {
                    selcom[pdbfnum] = molsel.toString();
                    selectioncom.append("#").append(String.valueOf(pdbfnum)).append(":");
                    selectioncom.append(selcom[pdbfnum]);
                    selectioncom.append(" ");
                    if (pdbfnum >= files.length - 1) continue;
                    selectioncom.append("| ");
                    continue;
                }
                selcom[pdbfnum] = null;
            }
            StringBuilder command = new StringBuilder(256);
            for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
                if (pdbfnum == refStructure || selcom[pdbfnum] == null || selcom[refStructure] == null) continue;
                if (command.length() > 0) {
                    command.append(";");
                }
                command.append("match ").append(this.getModelSpec(pdbfnum)).append(":");
                command.append(selcom[pdbfnum]);
                command.append("@").append(structures[pdbfnum].isRna ? PHOSPHORUS : ALPHACARBON);
                command.append(NO_ALTLOCS);
                command.append(" ").append(this.getModelSpec(refStructure)).append(":");
                command.append(selcom[refStructure]);
                command.append("@").append(structures[refStructure].isRna ? PHOSPHORUS : ALPHACARBON);
                command.append(NO_ALTLOCS);
            }
            if (selectioncom.length() <= 0) continue;
            allComs.append("~display all; chain @CA|P; ribbon ").append(selectioncom.toString()).append(";" + command.toString());
        }
        String error = null;
        if (selectioncom.length() > 0) {
            if (selectioncom.substring(selectioncom.length() - 1).equals("|")) {
                selectioncom.setLength(selectioncom.length() - 1);
            }
            allComs.append("; ~display all; chain @CA|P; ribbon ").append(selectioncom.toString()).append("; focus");
            List<String> chimeraReplies = this.sendChimeraCommand(allComs.toString(), true);
            for (String reply : chimeraReplies) {
                if (!reply.toLowerCase().contains("unequal numbers of atoms")) continue;
                error = reply;
            }
        }
        return error;
    }

    protected String getModelSpec(int pdbfnum) {
        if (pdbfnum < 0 || pdbfnum >= this.getPdbCount()) {
            return "";
        }
        List<ChimeraModel> maps = this.chimeraMaps.get(this.getStructureFiles()[pdbfnum]);
        boolean hasSubModels = maps != null && maps.size() > 1;
        return "#" + String.valueOf(pdbfnum) + (hasSubModels ? ".1" : "");
    }

    public boolean launchChimera() {
        if (this.viewer.isChimeraLaunched()) {
            return true;
        }
        boolean launched = this.viewer.launchChimera(StructureManager.getChimeraPaths());
        if (launched) {
            this.startChimeraProcessMonitor();
        } else {
            this.log("Failed to launch Chimera!");
        }
        return launched;
    }

    public boolean isChimeraRunning() {
        return this.viewer.isChimeraLaunched();
    }

    public List<String> sendChimeraCommand(String command, boolean getResponse) {
        if (this.viewer == null) {
            return null;
        }
        List<String> reply = null;
        this.viewerCommandHistory(false);
        List<String> lastReply = this.viewer.sendChimeraCommand(command.trim(), getResponse);
        if (getResponse) {
            reply = lastReply;
        }
        this.viewerCommandHistory(true);
        return reply;
    }

    protected abstract void sendAsynchronousCommand(String var1, String var2);

    @Override
    protected void colourBySequence(StructureMappingcommandSet[] colourBySequenceCommands) {
        for (StructureMappingcommandSet cpdbbyseq : colourBySequenceCommands) {
            for (String command : cpdbbyseq.commands) {
                this.sendAsynchronousCommand(command, COLOURING_CHIMERA);
            }
        }
    }

    @Override
    protected StructureMappingcommandSet[] getColourBySequenceCommands(String[] files, SequenceRenderer sr, AlignmentViewPanel viewPanel) {
        return ChimeraCommands.getColourBySequenceCommand(this.getSsm(), files, this.getSequence(), sr, viewPanel);
    }

    protected void executeWhenReady(String command) {
        this.waitForChimera();
        this.sendChimeraCommand(command, false);
        this.waitForChimera();
    }

    private void waitForChimera() {
        while (this.viewer != null && this.viewer.isBusy()) {
            try {
                Thread.sleep(15L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public abstract void refreshPdbEntries();

    @Override
    public synchronized String[] getStructureFiles() {
        if (this.viewer == null) {
            return new String[0];
        }
        this.modelFileNames = new String[this.chimeraMaps.size()];
        return this.chimeraMaps.keySet().toArray(this.modelFileNames);
    }

    @Override
    public void highlightAtoms(List<AtomSpec> atoms) {
        if (atoms == null || atoms.size() == 0) {
            return;
        }
        StringBuilder cmd = new StringBuilder(128);
        boolean first = true;
        boolean found = false;
        for (AtomSpec atom : atoms) {
            int pdbResNum = atom.getPdbResNum();
            String chain = atom.getChain();
            String pdbfile = atom.getPdbFile();
            List<ChimeraModel> cms = this.chimeraMaps.get(pdbfile);
            if (cms == null || cms.isEmpty()) continue;
            if (first) {
                cmd.append("rlabel #").append(cms.get(0).getModelNumber()).append(":");
            } else {
                cmd.append(",");
            }
            first = false;
            cmd.append(pdbResNum);
            if (!chain.equals(" ")) {
                cmd.append(".").append(chain);
            }
            found = true;
        }
        String command = cmd.toString();
        if (command.equals(this.lastHighlightCommand)) {
            return;
        }
        if (this.lastHighlightCommand != null) {
            this.viewer.sendChimeraCommand("~" + this.lastHighlightCommand, false);
        }
        if (found) {
            this.viewer.sendChimeraCommand(command, false);
        }
        this.lastHighlightCommand = command;
    }

    public void highlightChimeraSelection() {
        List<String> selection = this.viewer.getSelectedResidueSpecs();
        List<AtomSpec> atomSpecs = this.convertStructureResiduesToAlignment(selection);
        this.getSsm().mouseOverStructure(atomSpecs);
    }

    protected List<AtomSpec> convertStructureResiduesToAlignment(List<String> structureSelection) {
        ArrayList<AtomSpec> atomSpecs = new ArrayList<AtomSpec>();
        for (String atomSpec : structureSelection) {
            try {
                AtomSpec spec = AtomSpec.fromChimeraAtomspec(atomSpec);
                String pdbfilename = this.getPdbFileForModel(spec.getModelNumber());
                spec.setPdbFile(pdbfilename);
                atomSpecs.add(spec);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Failed to parse atomspec: " + atomSpec);
            }
        }
        return atomSpecs;
    }

    protected String getPdbFileForModel(int modelId) {
        String pdbfilename = this.modelFileNames[0];
        block0: for (String pdbfile : this.chimeraMaps.keySet()) {
            for (ChimeraModel cm : this.chimeraMaps.get(pdbfile)) {
                if (cm.getModelNumber() != modelId) continue;
                pdbfilename = pdbfile;
                break block0;
            }
        }
        return pdbfilename;
    }

    private void log(String message) {
        System.err.println("## Chimera log: " + message);
    }

    private void viewerCommandHistory(boolean enable) {
    }

    public long getLoadNotifiesHandled() {
        return this.loadNotifiesHandled;
    }

    @Override
    public void setJalviewColourScheme(ColourSchemeI cs) {
        this.colourBySequence = false;
        if (cs == null) {
            return;
        }
        double normalise = 255.0;
        this.viewerCommandHistory(false);
        StringBuilder command = new StringBuilder(128);
        List<String> residueSet = ResidueProperties.getResidues(this.isNucleotide(), false);
        for (String resName : residueSet) {
            char res = resName.length() == 3 ? ResidueProperties.getSingleCharacterCode(resName) : resName.charAt(0);
            Color col = cs.findColour(res, 0, null, null, 0.0f);
            command.append("color " + (double)col.getRed() / 255.0 + "," + (double)col.getGreen() / 255.0 + "," + (double)col.getBlue() / 255.0 + " ::" + resName + ";");
        }
        this.sendAsynchronousCommand(command.toString(), COLOURING_CHIMERA);
        this.viewerCommandHistory(true);
    }

    public abstract void refreshGUI();

    @Override
    public void setLoadingFromArchive(boolean loadingFromArchive) {
        this.loadingFromArchive = loadingFromArchive;
    }

    @Override
    public boolean isLoadingFromArchive() {
        return this.loadingFromArchive && !this.loadingFinished;
    }

    @Override
    public void setFinishedLoadingFromArchive(boolean finishedLoading) {
        this.loadingFinished = finishedLoading;
    }

    @Override
    public void setBackgroundColour(Color col) {
        this.viewerCommandHistory(false);
        double normalise = 255.0;
        String command = "background solid " + (double)col.getRed() / normalise + "," + (double)col.getGreen() / normalise + "," + (double)col.getBlue() / normalise + ";";
        this.viewer.sendChimeraCommand(command, false);
        this.viewerCommandHistory(true);
    }

    public boolean saveSession(String filepath) {
        if (this.isChimeraRunning()) {
            List<String> reply = this.viewer.sendChimeraCommand("save " + filepath, true);
            if (reply.contains("Session written")) {
                return true;
            }
            Cache.log.error((Object)("Error saving Chimera session: " + reply.toString()));
        }
        return false;
    }

    public boolean openSession(String filepath) {
        this.sendChimeraCommand("open " + filepath, true);
        return true;
    }

    @Override
    public List<String> getChainNames() {
        return this.chainNames;
    }

    public void focusView() {
        this.sendChimeraCommand("focus", false);
    }

    public void highlightSelection(AlignmentViewPanel vp) {
        List<Integer> cols = vp.getAlignViewport().getColumnSelection().getSelected();
        AlignmentI alignment = vp.getAlignment();
        StructureSelectionManager sm = this.getSsm();
        for (SequenceI seq : alignment.getSequences()) {
            int[] positions = new int[cols.size()];
            int i = 0;
            for (Integer col : cols) {
                positions[i++] = seq.findPosition(col);
            }
            sm.highlightStructure(this, seq, positions);
        }
    }

    public int sendFeaturesToViewer(AlignmentViewPanel avp) {
        AlignmentI alignment = avp.getAlignment();
        String[] files = this.getStructureFiles();
        if (files == null) {
            return 0;
        }
        StructureMappingcommandSet commandSet = ChimeraCommands.getSetAttributeCommandsForFeatures(this.getSsm(), files, this.getSequence(), avp);
        String[] commands = commandSet.commands;
        if (commands.length > 10) {
            this.sendCommandsByFile(commands);
        } else {
            for (String command : commands) {
                this.sendAsynchronousCommand(command, null);
            }
        }
        return commands.length;
    }

    protected void sendCommandsByFile(String[] commands) {
        try {
            File tmp = File.createTempFile("chim", ".com");
            tmp.deleteOnExit();
            PrintWriter out = new PrintWriter(new FileOutputStream(tmp));
            for (String command : commands) {
                out.println(command);
            }
            out.flush();
            out.close();
            String path = tmp.getAbsolutePath();
            this.sendAsynchronousCommand("open cmd:" + path, null);
        }
        catch (IOException e) {
            System.err.println("Sending commands to Chimera via file failed with " + e.getMessage());
        }
    }

    public void copyStructureAttributesToFeatures(String attName, AlignmentViewPanel alignmentPanel) {
        String cmd = "list residues attr '" + attName + "'";
        List<String> residues = this.sendChimeraCommand(cmd, true);
        boolean featureAdded = this.createFeaturesForAttributes(attName, residues);
        if (featureAdded) {
            alignmentPanel.getFeatureRenderer().featuresAdded();
        }
    }

    protected boolean createFeaturesForAttributes(String attName, List<String> residues) {
        boolean featureAdded = false;
        String featureGroup = this.getViewerFeatureGroup();
        for (String residue : residues) {
            AtomSpec spec = null;
            String[] tokens = residue.split(" ");
            if (tokens.length < 5) continue;
            String atomSpec = tokens[2];
            String attValue = tokens[4];
            if ("None".equalsIgnoreCase(attValue) || "False".equalsIgnoreCase(attValue)) continue;
            try {
                spec = AtomSpec.fromChimeraAtomspec(atomSpec);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Problem parsing atomspec " + atomSpec);
                continue;
            }
            String chainId = spec.getChain();
            String description = attValue;
            float score = Float.NaN;
            try {
                score = Float.valueOf(attValue).floatValue();
                description = chainId;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String pdbFile = this.getPdbFileForModel(spec.getModelNumber());
            spec.setPdbFile(pdbFile);
            List<AtomSpec> atoms = Collections.singletonList(spec);
            SearchResultsI sr = this.getSsm().findAlignmentPositionsForStructurePositions(atoms);
            for (SearchResultMatchI m : sr.getResults()) {
                SequenceI seq = m.getSequence();
                int start = m.getStart();
                int end = m.getEnd();
                SequenceFeature sf = new SequenceFeature(attName, description, start, end, score, featureGroup);
                featureAdded |= seq.addSequenceFeature(sf);
            }
        }
        return featureAdded;
    }

    protected String getViewerFeatureGroup() {
        return CHIMERA_FEATURE_GROUP;
    }

    public Hashtable<String, String> getChainFile() {
        return this.chainFile;
    }

    public List<ChimeraModel> getChimeraModelByChain(String chain) {
        return this.chimeraMaps.get(this.chainFile.get(chain));
    }

    public int getModelNoForChain(String chain) {
        List<ChimeraModel> foundModels = this.getChimeraModelByChain(chain);
        if (foundModels != null && !foundModels.isEmpty()) {
            return foundModels.get(0).getModelNumber();
        }
        return -1;
    }
}

