/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.rbvi.chimera;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.rbvi.chimera.AtomSpecModel;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.structure.StructureMapping;
import jalview.structure.StructureMappingcommandSet;
import jalview.structure.StructureSelectionManager;
import jalview.util.ColorUtils;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ChimeraCommands {
    public static final String NAMESPACE_PREFIX = "jv_";

    public static StructureMappingcommandSet[] getColourBySequenceCommand(StructureSelectionManager ssm, String[] files, SequenceI[][] sequence, SequenceRenderer sr, AlignmentViewPanel viewPanel) {
        Map<Object, AtomSpecModel> colourMap = ChimeraCommands.buildColoursMap(ssm, files, sequence, sr, viewPanel);
        List<String> colourCommands = ChimeraCommands.buildColourCommands(colourMap);
        StructureMappingcommandSet cs = new StructureMappingcommandSet(ChimeraCommands.class, null, colourCommands.toArray(new String[colourCommands.size()]));
        return new StructureMappingcommandSet[]{cs};
    }

    protected static List<String> buildColourCommands(Map<Object, AtomSpecModel> colourMap) {
        ArrayList<String> commands = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(256);
        boolean firstColour = true;
        for (Object key : colourMap.keySet()) {
            Color colour = (Color)key;
            String colourCode = ColorUtils.toTkCode(colour);
            if (!firstColour) {
                sb.append("; ");
            }
            sb.append("color ").append(colourCode).append(" ");
            firstColour = false;
            AtomSpecModel colourData = colourMap.get(colour);
            sb.append(colourData.getAtomSpec());
        }
        commands.add(sb.toString());
        return commands;
    }

    protected static String getAtomSpec(Map<Integer, Map<String, List<int[]>>> modelAndChainRanges) {
        StringBuilder sb = new StringBuilder(128);
        boolean firstModelForColour = true;
        for (Integer model : modelAndChainRanges.keySet()) {
            boolean firstPositionForModel = true;
            if (!firstModelForColour) {
                sb.append("|");
            }
            firstModelForColour = false;
            sb.append("#").append(model).append(":");
            Map<String, List<int[]>> modelData = modelAndChainRanges.get(model);
            for (String chain : modelData.keySet()) {
                boolean hasChain = !"".equals(chain.trim());
                for (int[] range : modelData.get(chain)) {
                    if (!firstPositionForModel) {
                        sb.append(",");
                    }
                    if (range[0] == range[1]) {
                        sb.append(range[0]);
                    } else {
                        sb.append(range[0]).append("-").append(range[1]);
                    }
                    if (hasChain) {
                        sb.append(".").append(chain);
                    }
                    firstPositionForModel = false;
                }
            }
        }
        return sb.toString();
    }

    protected static Map<Object, AtomSpecModel> buildColoursMap(StructureSelectionManager ssm, String[] files, SequenceI[][] sequence, SequenceRenderer sr, AlignmentViewPanel viewPanel) {
        jalview.api.FeatureRenderer fr = viewPanel.getFeatureRenderer();
        FeatureColourFinder finder = new FeatureColourFinder(fr);
        AlignViewportI viewport = viewPanel.getAlignViewport();
        HiddenColumns cs = viewport.getAlignment().getHiddenColumns();
        AlignmentI al = viewport.getAlignment();
        LinkedHashMap<Object, AtomSpecModel> colourMap = new LinkedHashMap<Object, AtomSpecModel>();
        Color lastColour = null;
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            StructureMapping[] mapping = ssm.getMapping(files[pdbfnum]);
            if (mapping == null || mapping.length < 1) continue;
            int startPos = -1;
            int lastPos = -1;
            String lastChain = "";
            for (int s = 0; s < sequence[pdbfnum].length; ++s) {
                for (int m = 0; m < mapping.length; ++m) {
                    int sp;
                    SequenceI seq = sequence[pdbfnum][s];
                    if (mapping[m].getSequence() != seq || (sp = al.findIndex(seq)) <= -1) continue;
                    SequenceI asp = al.getSequenceAt(sp);
                    for (int r = 0; r < asp.getLength(); ++r) {
                        boolean newChain;
                        int pos;
                        if (Comparison.isGap(asp.getCharAt(r)) || (pos = mapping[m].getPDBResNum(asp.findPosition(r))) < 1 || pos == lastPos) continue;
                        Color colour = sr.getResidueColour(seq, r, finder);
                        if (!cs.isVisible(r)) {
                            colour = Color.GRAY;
                        }
                        String chain = mapping[m].getChain();
                        boolean newColour = !colour.equals(lastColour);
                        boolean nonContig = lastPos + 1 != pos;
                        boolean bl = newChain = !chain.equals(lastChain);
                        if (newColour || nonContig || newChain) {
                            if (startPos != -1) {
                                ChimeraCommands.addAtomSpecRange(colourMap, lastColour, pdbfnum, startPos, lastPos, lastChain);
                            }
                            startPos = pos;
                        }
                        lastColour = colour;
                        lastPos = pos;
                        lastChain = chain;
                    }
                    if (lastColour == null) continue;
                    ChimeraCommands.addAtomSpecRange(colourMap, lastColour, pdbfnum, startPos, lastPos, lastChain);
                }
            }
        }
        return colourMap;
    }

    protected static void addAtomSpecRange(Map<Object, AtomSpecModel> map, Object value, int model, int startPos, int endPos, String chain) {
        AtomSpecModel atomSpec = map.get(value);
        if (atomSpec == null) {
            atomSpec = new AtomSpecModel();
            map.put(value, atomSpec);
        }
        atomSpec.addRange(model, startPos, endPos, chain);
    }

    public static StructureMappingcommandSet getSetAttributeCommandsForFeatures(StructureSelectionManager ssm, String[] files, SequenceI[][] seqs, AlignmentViewPanel viewPanel) {
        Map<String, Map<Object, AtomSpecModel>> featureMap = ChimeraCommands.buildFeaturesMap(ssm, files, seqs, viewPanel);
        List<String> commands = ChimeraCommands.buildSetAttributeCommands(featureMap);
        StructureMappingcommandSet cs = new StructureMappingcommandSet(ChimeraCommands.class, null, commands.toArray(new String[commands.size()]));
        return cs;
    }

    protected static Map<String, Map<Object, AtomSpecModel>> buildFeaturesMap(StructureSelectionManager ssm, String[] files, SequenceI[][] seqs, AlignmentViewPanel viewPanel) {
        AlignViewportI comp;
        LinkedHashMap<String, Map<Object, AtomSpecModel>> theMap = new LinkedHashMap<String, Map<Object, AtomSpecModel>>();
        jalview.api.FeatureRenderer fr = viewPanel.getFeatureRenderer();
        if (fr == null) {
            return theMap;
        }
        AlignViewportI viewport = viewPanel.getAlignViewport();
        List<String> visibleFeatures = fr.getDisplayedFeatureTypes();
        boolean showLinkedFeatures = viewport.isShowComplementFeatures();
        List<Object> complementFeatures = new ArrayList();
        FeatureRenderer complementRenderer = null;
        if (showLinkedFeatures && (comp = fr.getViewport().getCodingComplement()) != null) {
            complementRenderer = Desktop.getAlignFrameFor(comp).getFeatureRenderer();
            complementFeatures = complementRenderer.getDisplayedFeatureTypes();
        }
        if (visibleFeatures.isEmpty() && complementFeatures.isEmpty()) {
            return theMap;
        }
        AlignmentI alignment = viewPanel.getAlignment();
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            StructureMapping[] mapping = ssm.getMapping(files[pdbfnum]);
            if (mapping == null || mapping.length < 1) continue;
            for (int seqNo = 0; seqNo < seqs[pdbfnum].length; ++seqNo) {
                for (int m = 0; m < mapping.length; ++m) {
                    SequenceI seq = seqs[pdbfnum][seqNo];
                    int sp = alignment.findIndex(seq);
                    StructureMapping structureMapping = mapping[m];
                    if (structureMapping.getSequence() != seq || sp <= -1) continue;
                    if (!visibleFeatures.isEmpty()) {
                        ChimeraCommands.scanSequenceFeatures(visibleFeatures, structureMapping, seq, theMap, pdbfnum);
                    }
                    if (!showLinkedFeatures) continue;
                    ChimeraCommands.scanComplementFeatures(complementRenderer, structureMapping, seq, theMap, pdbfnum);
                }
            }
        }
        return theMap;
    }

    protected static void scanComplementFeatures(jalview.api.FeatureRenderer complementRenderer, StructureMapping structureMapping, SequenceI seq, Map<String, Map<Object, AtomSpecModel>> theMap, int modelNumber) {
        for (int seqPos : structureMapping.getMapping().keySet()) {
            MappedFeatures mf = complementRenderer.findComplementFeaturesAtResidue(seq, seqPos);
            if (mf == null) continue;
            for (SequenceFeature sf : mf.features) {
                Map<Object, AtomSpecModel> featureValues;
                float score;
                List<int[]> mappedRanges;
                String type = sf.getType();
                if ("Chimera".equals(sf.getFeatureGroup()) || (mappedRanges = structureMapping.getPDBResNumRanges(seqPos, seqPos)).isEmpty()) continue;
                String value = sf.getDescription();
                if (value == null || value.length() == 0) {
                    value = type;
                }
                if ((score = sf.getScore()) != 0.0f && !Float.isNaN(score)) {
                    value = Float.toString(score);
                }
                if ((featureValues = theMap.get(type)) == null) {
                    featureValues = new HashMap<Object, AtomSpecModel>();
                    theMap.put(type, featureValues);
                }
                for (int[] range : mappedRanges) {
                    ChimeraCommands.addAtomSpecRange(featureValues, value, modelNumber, range[0], range[1], structureMapping.getChain());
                }
            }
        }
    }

    protected static void scanSequenceFeatures(List<String> visibleFeatures, StructureMapping mapping, SequenceI seq, Map<String, Map<Object, AtomSpecModel>> theMap, int modelNumber) {
        List<SequenceFeature> sfs = seq.getFeatures().getPositionalFeatures(visibleFeatures.toArray(new String[visibleFeatures.size()]));
        for (SequenceFeature sf : sfs) {
            Map<Object, AtomSpecModel> featureValues;
            float score;
            List<int[]> mappedRanges;
            String type = sf.getType();
            if ("Chimera".equals(sf.getFeatureGroup()) || (mappedRanges = mapping.getPDBResNumRanges(sf.getBegin(), sf.getEnd())).isEmpty()) continue;
            String value = sf.getDescription();
            if (value == null || value.length() == 0) {
                value = type;
            }
            if ((score = sf.getScore()) != 0.0f && !Float.isNaN(score)) {
                value = Float.toString(score);
            }
            if ((featureValues = theMap.get(type)) == null) {
                featureValues = new HashMap<Object, AtomSpecModel>();
                theMap.put(type, featureValues);
            }
            for (int[] range : mappedRanges) {
                ChimeraCommands.addAtomSpecRange(featureValues, value, modelNumber, range[0], range[1], mapping.getChain());
            }
        }
    }

    protected static List<String> buildSetAttributeCommands(Map<String, Map<Object, AtomSpecModel>> featureMap) {
        ArrayList<String> commands = new ArrayList<String>();
        for (String featureType : featureMap.keySet()) {
            String attributeName = ChimeraCommands.makeAttributeName(featureType);
            Map<Object, AtomSpecModel> values = featureMap.get(featureType);
            for (Object value : values.keySet()) {
                StringBuilder sb = new StringBuilder(128);
                String featureValue = value.toString();
                featureValue = featureValue.replaceAll("\\'", "&#39;");
                sb.append("setattr r ").append(attributeName).append(" '").append(featureValue).append("' ");
                sb.append(values.get(value).getAtomSpec());
                commands.add(sb.toString());
            }
        }
        return commands;
    }

    protected static String makeAttributeName(String featureType) {
        String attName;
        StringBuilder sb = new StringBuilder();
        if (featureType != null) {
            for (char c : featureType.toCharArray()) {
                sb.append(Character.isLetterOrDigit(c) ? c : (char)'_');
            }
        }
        if ((attName = NAMESPACE_PREFIX + sb.toString()).toUpperCase().endsWith("COLOR")) {
            attName = attName + "_";
        }
        return attName;
    }
}

