/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.rbvi.chimera;

import jalview.util.IntRangeComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AtomSpecModel {
    private Map<Integer, Map<String, List<int[]>>> atomSpec = new TreeMap<Integer, Map<String, List<int[]>>>();

    public void addRange(int model, int startPos, int endPos, String chain) {
        List<int[]> chainData;
        Map<String, List<int[]>> modelData = this.atomSpec.get(model);
        if (modelData == null) {
            modelData = new TreeMap<String, List<int[]>>();
            this.atomSpec.put(model, modelData);
        }
        if ((chainData = modelData.get(chain)) == null) {
            chainData = new ArrayList<int[]>();
            modelData.put(chain, chainData);
        }
        chainData.add(new int[]{startPos, endPos});
    }

    public String getAtomSpec() {
        StringBuilder sb = new StringBuilder(128);
        boolean firstModel = true;
        for (Integer model : this.atomSpec.keySet()) {
            if (!firstModel) {
                sb.append("|");
            }
            firstModel = false;
            sb.append("#").append(model).append(":");
            boolean firstPositionForModel = true;
            Map<String, List<int[]>> modelData = this.atomSpec.get(model);
            for (String chain : modelData.keySet()) {
                chain = " ".equals(chain) ? chain : chain.trim();
                List<int[]> rangeList = modelData.get(chain);
                Collections.sort(rangeList, IntRangeComparator.ASCENDING);
                int start = rangeList.isEmpty() ? 0 : rangeList.get(0)[0];
                int end = rangeList.isEmpty() ? 0 : rangeList.get(0)[1];
                for (int[] range : rangeList) {
                    if (range[0] <= end + 1) {
                        end = Math.max(end, range[1]);
                        continue;
                    }
                    this.appendRange(sb, start, end, chain, firstPositionForModel);
                    firstPositionForModel = false;
                    start = range[0];
                    end = range[1];
                }
                if (rangeList.isEmpty()) continue;
                this.appendRange(sb, start, end, chain, firstPositionForModel);
                firstPositionForModel = false;
            }
        }
        return sb.toString();
    }

    protected void appendRange(StringBuilder sb, int start, int end, String chain, boolean firstPositionForModel) {
        if (!firstPositionForModel) {
            sb.append(",");
        }
        if (end == start) {
            sb.append(start);
        } else {
            sb.append(start).append("-").append(end);
        }
        sb.append(".");
        if (!" ".equals(chain)) {
            sb.append(chain);
        }
    }
}

