/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.jmol;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeatureRenderer;
import jalview.api.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.structure.StructureMapping;
import jalview.structure.StructureMappingcommandSet;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import java.awt.Color;
import java.util.ArrayList;

public class JmolCommands {
    public static StructureMappingcommandSet[] getColourBySequenceCommand(StructureSelectionManager ssm, String[] files, SequenceI[][] sequence, SequenceRenderer sr, AlignmentViewPanel viewPanel) {
        FeatureRenderer fr = viewPanel.getFeatureRenderer();
        FeatureColourFinder finder = new FeatureColourFinder(fr);
        AlignViewportI viewport = viewPanel.getAlignViewport();
        HiddenColumns cs = viewport.getAlignment().getHiddenColumns();
        AlignmentI al = viewport.getAlignment();
        ArrayList<StructureMappingcommandSet> cset = new ArrayList<StructureMappingcommandSet>();
        for (int pdbfnum = 0; pdbfnum < files.length; ++pdbfnum) {
            StructureMapping[] mapping = ssm.getMapping(files[pdbfnum]);
            StringBuffer command = new StringBuffer();
            ArrayList<String> str = new ArrayList<String>();
            if (mapping == null || mapping.length < 1) continue;
            for (int s = 0; s < sequence[pdbfnum].length; ++s) {
                for (int m = 0; m < mapping.length; ++m) {
                    int sp;
                    if (mapping[m].getSequence() != sequence[pdbfnum][s] || (sp = al.findIndex(sequence[pdbfnum][s])) <= -1) continue;
                    int lastPos = Integer.MIN_VALUE;
                    SequenceI asp = al.getSequenceAt(sp);
                    for (int r = 0; r < asp.getLength(); ++r) {
                        int pos;
                        if (Comparison.isGap(asp.getCharAt(r)) || (pos = mapping[m].getPDBResNum(asp.findPosition(r))) == lastPos) continue;
                        if (pos == Integer.MIN_VALUE) {
                            if (command.length() > 0 && command.charAt(command.length() - 1) != ';') {
                                command.append(";");
                            }
                            lastPos = Integer.MIN_VALUE;
                            continue;
                        }
                        lastPos = pos;
                        Color col = sr.getResidueColour(sequence[pdbfnum][s], r, finder);
                        if (!cs.isVisible(r)) {
                            col = Color.GRAY;
                        }
                        String newSelcom = (mapping[m].getChain() != " " ? ":" + mapping[m].getChain() : "") + "/" + (pdbfnum + 1) + ".1;color[" + col.getRed() + "," + col.getGreen() + "," + col.getBlue() + "]";
                        if (command.length() > newSelcom.length() && command.substring(command.length() - newSelcom.length()).equals(newSelcom)) {
                            command = JmolCommands.condenseCommand(command, pos);
                            continue;
                        }
                        if (command.length() > 0 && command.charAt(command.length() - 1) != ';') {
                            command.append(";");
                        }
                        if (command.length() > 51200) {
                            str.add(command.toString());
                            command.setLength(0);
                        }
                        command.append("select " + pos);
                        command.append(newSelcom);
                    }
                }
            }
            str.add(command.toString());
            command.setLength(0);
            cset.add(new StructureMappingcommandSet(JmolCommands.class, files[pdbfnum], str.toArray(new String[str.size()])));
        }
        return cset.toArray(new StructureMappingcommandSet[cset.size()]);
    }

    public static StringBuffer condenseCommand(StringBuffer command, int pos) {
        int p;
        int q = p = command.length();
        do {
            if ((p -= 6) >= 1) continue;
            p = 0;
        } while ((q = command.indexOf("select", p)) == -1 && p > 0);
        StringBuffer sb = new StringBuffer(command.substring(0, q + 7));
        String start = (command = command.delete(0, q + 7)).indexOf("-") > -1 ? command.substring(0, command.indexOf("-")) : command.substring(0, command.indexOf(":"));
        sb.append(start + "-" + pos + command.substring(command.indexOf(":")));
        return sb;
    }
}

