/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.htsjdk;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.reference.FastaSequenceIndexCreator;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.StringUtil;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;

public class HtsContigDb {
    private String name;
    private File dbLocation;
    private ReferenceSequenceFile refFile = null;
    SAMSequenceDictionary rrefDict = null;
    private MessageDigest md5;

    public static void createFastaSequenceIndex(Path path, boolean overwrite) throws IOException {
        try {
            FastaSequenceIndexCreator.create((Path)path, (boolean)overwrite);
        }
        catch (SAMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public HtsContigDb(String name, File descriptor) {
        if (descriptor.isFile()) {
            this.name = name;
            this.dbLocation = descriptor;
        }
        this.initSource();
    }

    public void close() {
        if (this.refFile != null) {
            try {
                this.refFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void initSource() {
        if (this.refFile != null) {
            return;
        }
        this.refFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)this.dbLocation, (boolean)true);
        if (this.refFile == null || this.refFile.getSequenceDictionary() == null) {
            // empty if block
        }
    }

    private ReferenceSequenceFile initSequenceDictionaryFor(File dbLocation2) throws Exception {
        this.rrefDict = this.getDictionary(dbLocation2, true);
        if (this.rrefDict != null) {
            ReferenceSequenceFile rrefFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)dbLocation2, (boolean)true);
            return rrefFile;
        }
        return null;
    }

    SAMSequenceDictionary getDictionary(File f, boolean truncate) throws Exception {
        ReferenceSequence refSeq;
        if (this.md5 == null) {
            this.initCreateSequenceDictionary();
        }
        ReferenceSequenceFile refSeqFile = ReferenceSequenceFileFactory.getReferenceSequenceFile((File)f, (boolean)truncate);
        ArrayList<SAMSequenceRecord> ret = new ArrayList<SAMSequenceRecord>();
        HashSet<String> sequenceNames = new HashSet<String>();
        int numSequences = 0;
        while ((refSeq = refSeqFile.nextSequence()) != null) {
            if (sequenceNames.contains(refSeq.getName())) {
                throw new Exception("Sequence name appears more than once in reference: " + refSeq.getName());
            }
            sequenceNames.add(refSeq.getName());
            ret.add(this.makeSequenceRecord(refSeq));
            ++numSequences;
        }
        return new SAMSequenceDictionary(ret);
    }

    public boolean isValid() {
        return this.dbLocation != null && this.refFile != null;
    }

    private SAMSequenceRecord makeSequenceRecord(ReferenceSequence refSeq) {
        SAMSequenceRecord ret = new SAMSequenceRecord(refSeq.getName(), refSeq.length());
        byte[] bases = refSeq.getBases();
        for (int i = 0; i < bases.length; ++i) {
            bases[i] = StringUtil.toUpperCase((byte)bases[i]);
        }
        ret.setAttribute("M5", this.md5Hash(bases));
        return ret;
    }

    public void initCreateSequenceDictionary() throws Exception {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Exception("MD5 algorithm not found", e);
        }
    }

    private String md5Hash(byte[] bytes) {
        this.md5.reset();
        this.md5.update(bytes);
        String s = new BigInteger(1, this.md5.digest()).toString(16);
        if (s.length() != 32) {
            String zeros = "00000000000000000000000000000000";
            s = "00000000000000000000000000000000".substring(0, 32 - s.length()) + s;
        }
        return s;
    }

    public SequenceI getSequenceProxy(String id) {
        if (!this.isValid() || !this.refFile.isIndexed()) {
            System.err.println("Cannot read contig as file is invalid or not indexed");
            return null;
        }
        ReferenceSequence sseq = this.refFile.getSequence(id);
        return new Sequence(sseq.getName(), new String(sseq.getBases()));
    }

    public boolean isIndexed() {
        return this.refFile != null && this.refFile.isIndexed();
    }
}

