/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.analysis.AlignmentUtils;
import jalview.analysis.Dna;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.SequenceFeatures;
import jalview.exceptions.JalviewException;
import jalview.ext.ensembl.EnsemblFeatures;
import jalview.ext.ensembl.EnsemblProtein;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.ext.ensembl.EnsemblXref;
import jalview.io.gff.SequenceOntologyFactory;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.util.IntRangeComparator;
import jalview.util.MapList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public abstract class EnsemblSeqProxy
extends EnsemblRestClient {
    protected static final String DESCRIPTION = "description";

    public EnsemblSeqProxy() {
    }

    public EnsemblSeqProxy(String d) {
        super(d);
    }

    @Override
    public AlignmentI getSequenceRecords(String query) throws Exception {
        List<String> allIds = Arrays.asList(query.split(this.getAccessionSeparator()));
        AlignmentI alignment = null;
        this.inProgress = true;
        int maxQueryCount = this.getMaximumQueryCount();
        int vSize = allIds.size();
        for (int v = 0; v < vSize; v += maxQueryCount) {
            int p = Math.min(vSize, v + maxQueryCount);
            List<String> ids = allIds.subList(v, p);
            try {
                alignment = this.fetchSequences(ids, alignment);
                continue;
            }
            catch (Throwable r) {
                this.inProgress = false;
                String msg = "Aborting ID retrieval after " + v + " chunks. Unexpected problem (" + r.getLocalizedMessage() + ")";
                System.err.println(msg);
                r.printStackTrace();
                break;
            }
        }
        if (alignment == null) {
            return null;
        }
        for (String accId : allIds) {
            this.addFeaturesAndProduct(accId, alignment);
        }
        for (SequenceI seq : alignment.getSequences()) {
            this.getCrossReferences(seq);
        }
        return alignment;
    }

    protected void addFeaturesAndProduct(String accId, AlignmentI alignment) {
        if (alignment == null) {
            return;
        }
        try {
            SequenceI querySeq;
            SequenceI genomicSequence = null;
            EnsemblFeatures gffFetcher = new EnsemblFeatures(this.getDomain());
            EnsemblSequenceFetcher.EnsemblFeatureType[] features = this.getFeaturesToFetch();
            AlignmentI geneFeatures = gffFetcher.getSequenceRecords(accId, features);
            if (geneFeatures != null && geneFeatures.getHeight() > 0) {
                genomicSequence = geneFeatures.getSequenceAt(0);
            }
            if (genomicSequence != null && this.transferFeatures(accId, genomicSequence, querySeq = alignment.findName(accId, true))) {
                this.addProteinProduct(querySeq);
            }
        }
        catch (IOException e) {
            System.err.println("Error transferring Ensembl features: " + e.getMessage());
        }
    }

    protected abstract EnsemblSequenceFetcher.EnsemblFeatureType[] getFeaturesToFetch();

    protected void addProteinProduct(SequenceI querySeq) {
        String accId = querySeq.getName();
        try {
            AlignmentI protein = new EnsemblProtein(this.getDomain()).getSequenceRecords(accId);
            if (protein == null || protein.getHeight() == 0) {
                System.out.println("No protein product found for " + accId);
                return;
            }
            SequenceI proteinSeq = protein.getSequenceAt(0);
            proteinSeq.createDatasetSequence();
            querySeq.createDatasetSequence();
            MapList mapList = AlignmentUtils.mapCdsToProtein(querySeq, proteinSeq);
            if (mapList != null) {
                SequenceI ds = proteinSeq.getDatasetSequence();
                Mapping map = new Mapping(ds, mapList);
                DBRefEntry dbr = new DBRefEntry(this.getDbSource(), this.getEnsemblDataVersion(), proteinSeq.getName(), map);
                querySeq.getDatasetSequence().addDBRef(dbr);
                DBRefEntry[] uprots = DBRefUtils.selectRefs(ds.getDBRefs(), new String[]{"UNIPROT"});
                DBRefEntry[] upxrefs = DBRefUtils.selectRefs(querySeq.getDBRefs(), new String[]{"UNIPROT"});
                if (uprots != null) {
                    for (DBRefEntry up : uprots) {
                        DBRefEntry upxref;
                        List<DBRefEntry> upx = DBRefUtils.searchRefs(upxrefs, up.getAccessionId());
                        if (upx.size() != 0) {
                            upxref = upx.get(0);
                            if (upx.size() > 1) {
                                Cache.log.warn((Object)"Implementation issue - multiple uniprot acc on product sequence.");
                            }
                        } else {
                            upxref = new DBRefEntry("UNIPROT", this.getEnsemblDataVersion(), up.getAccessionId());
                        }
                        Mapping newMap = new Mapping(ds, mapList);
                        upxref.setVersion(this.getEnsemblDataVersion());
                        upxref.setMap(newMap);
                        if (upx.size() != 0) continue;
                        querySeq.getDatasetSequence().addDBRef(upxref);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.format("Error retrieving protein for %s: %s", accId, e.getMessage()));
        }
    }

    protected void getCrossReferences(SequenceI seq) {
        while (seq.getDatasetSequence() != null) {
            seq = seq.getDatasetSequence();
        }
        EnsemblXref xrefFetcher = new EnsemblXref(this.getDomain(), this.getDbSource(), this.getEnsemblDataVersion());
        List<DBRefEntry> xrefs = xrefFetcher.getCrossReferences(seq.getName());
        for (DBRefEntry xref : xrefs) {
            seq.addDBRef(xref);
        }
        DBRefEntry self = new DBRefEntry(this.getDbSource(), this.getEnsemblDataVersion(), seq.getName());
        seq.addDBRef(self);
    }

    protected AlignmentI fetchSequences(List<String> ids, AlignmentI alignment) throws JalviewException, IOException {
        if (!this.isEnsemblAvailable()) {
            this.inProgress = false;
            throw new JalviewException("ENSEMBL Rest API not available.");
        }
        BufferedReader br = this.getSequenceReader(ids);
        if (br == null) {
            return alignment;
        }
        List<SequenceI> seqs = this.parseSequenceJson(br);
        if (seqs.isEmpty()) {
            throw new IOException("No data returned for " + ids);
        }
        if (seqs.size() != ids.size()) {
            System.out.println(String.format("Only retrieved %d sequences for %d query strings", seqs.size(), ids.size()));
        }
        if (!seqs.isEmpty()) {
            Alignment seqal = new Alignment(seqs.toArray(new SequenceI[seqs.size()]));
            for (SequenceI seq : seqs) {
                String name;
                if (seq.getDescription() == null) {
                    seq.setDescription(this.getDbName());
                }
                if (!ids.contains(name = seq.getName()) && !ids.contains(name.replace("ENSP", "ENST"))) continue;
                DBRefEntry dbref = DBRefUtils.parseToDbRef(seq, this.getDbSource(), this.getEnsemblDataVersion(), name);
                seq.addDBRef(dbref);
            }
            if (alignment == null) {
                alignment = seqal;
            } else {
                alignment.append(seqal);
            }
        }
        return alignment;
    }

    protected List<SequenceI> parseSequenceJson(BufferedReader br) {
        JSONParser jp = new JSONParser();
        ArrayList<SequenceI> result = new ArrayList<SequenceI>();
        try {
            JSONObject val = (JSONObject)jp.parse((Reader)br);
            Object s = val.get((Object)"desc");
            String desc = s == null ? null : s.toString();
            s = val.get((Object)"id");
            String id = s == null ? null : s.toString();
            s = val.get((Object)"seq");
            String seq = s == null ? null : s.toString();
            Sequence sequence = new Sequence(id, seq);
            if (desc != null) {
                sequence.setDescription(desc);
            }
            result.add(sequence);
        }
        catch (IOException | ParseException e) {
            System.err.println("Error processing JSON response: " + e.toString());
        }
        return result;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        StringBuffer urlstring = new StringBuffer(128);
        urlstring.append(this.getDomain() + "/sequence/id");
        if (ids.size() == 1) {
            urlstring.append("/").append(ids.get(0));
        }
        urlstring.append("?type=").append(this.getSourceEnsemblType().getType());
        urlstring.append("&Accept=application/json");
        urlstring.append("&Content-Type=application/json");
        String objectType = this.getObjectType();
        if (objectType != null) {
            urlstring.append("&").append("object_type").append("=").append(objectType);
        }
        URL url = new URL(urlstring.toString());
        return url;
    }

    protected String getObjectType() {
        return null;
    }

    @Override
    public int getMaximumQueryCount() {
        return 50;
    }

    @Override
    protected boolean useGetRequest() {
        return false;
    }

    protected abstract EnsemblSeqType getSourceEnsemblType();

    protected MapList getGenomicRangesFromFeatures(SequenceI sourceSequence, String accId, int start) {
        List<SequenceFeature> sfs = this.getIdentifyingFeatures(sourceSequence, accId);
        if (sfs.isEmpty()) {
            return null;
        }
        ArrayList<int[]> regions = new ArrayList<int[]>(100);
        int mappedLength = 0;
        int direction = 1;
        boolean directionSet = false;
        for (SequenceFeature sf : sfs) {
            int strand = sf.getStrand();
            int n = strand = strand == 0 ? 1 : strand;
            if (directionSet && strand != direction) {
                System.err.println("Error: forward and backward strand for " + accId);
                return null;
            }
            direction = strand;
            directionSet = true;
            if (strand < 0) {
                regions.add(0, new int[]{sf.getEnd(), sf.getBegin()});
            } else {
                regions.add(new int[]{sf.getBegin(), sf.getEnd()});
            }
            mappedLength += Math.abs(sf.getEnd() - sf.getBegin() + 1);
        }
        if (regions.isEmpty()) {
            System.out.println("Failed to identify target sequence for " + accId + " from genomic features");
            return null;
        }
        Collections.sort(regions, direction == 1 ? IntRangeComparator.ASCENDING : IntRangeComparator.DESCENDING);
        List<int[]> to = Arrays.asList(new int[][]{{start, start + mappedLength - 1}});
        return new MapList(regions, to, 1, 1);
    }

    protected abstract List<SequenceFeature> getIdentifyingFeatures(SequenceI var1, String var2);

    protected void transferFeature(SequenceFeature sf, SequenceI targetSequence, MapList mapping, boolean forwardStrand) {
        int end;
        int start = sf.getBegin();
        int[] mappedRange = mapping.locateInTo(start, end = sf.getEnd());
        if (mappedRange != null) {
            String group = sf.getFeatureGroup();
            if (".".equals(group)) {
                group = this.getDbSource();
            }
            int newBegin = Math.min(mappedRange[0], mappedRange[1]);
            int newEnd = Math.max(mappedRange[0], mappedRange[1]);
            SequenceFeature copy = new SequenceFeature(sf, newBegin, newEnd, group, sf.getScore());
            targetSequence.addSequenceFeature(copy);
            if (!forwardStrand && SequenceOntologyFactory.getInstance().isA(sf.getType(), "sequence_variant")) {
                EnsemblSeqProxy.reverseComplementAlleles(copy);
            }
        }
    }

    static void reverseComplementAlleles(SequenceFeature sf) {
        String alleles = (String)sf.getValue("alleles");
        if (alleles == null) {
            return;
        }
        StringBuilder complement = new StringBuilder(alleles.length());
        for (String allele : alleles.split(",")) {
            EnsemblSeqProxy.reverseComplementAllele(complement, allele);
        }
        String comp = complement.toString();
        sf.setValue("alleles", comp);
        sf.setDescription(comp);
        String atts = sf.getAttributes();
        if (atts != null) {
            atts = atts.replace("alleles=" + alleles, "alleles=" + comp);
            sf.setAttributes(atts);
        }
    }

    static void reverseComplementAllele(StringBuilder complement, String allele) {
        if (complement.length() > 0) {
            complement.append(",");
        }
        if (!Comparison.isNucleotideSequence(allele, true)) {
            complement.append(allele);
        } else {
            for (int i = allele.length() - 1; i >= 0; --i) {
                complement.append(Dna.getComplement(allele.charAt(i)));
            }
        }
    }

    protected boolean transferFeatures(String accessionId, SequenceI sourceSequence, SequenceI targetSequence) {
        if (sourceSequence == null || targetSequence == null) {
            return false;
        }
        List<SequenceFeature> sfs = sourceSequence.getFeatures().getPositionalFeatures(new String[0]);
        MapList mapping = this.getGenomicRangesFromFeatures(sourceSequence, accessionId, targetSequence.getStart());
        if (mapping == null) {
            return false;
        }
        boolean result = this.transferFeatures(sfs, targetSequence, mapping, accessionId);
        return result;
    }

    protected boolean transferFeatures(List<SequenceFeature> sfs, SequenceI targetSequence, MapList mapping, String parentId) {
        boolean forwardStrand = mapping.isFromForwardStrand();
        SequenceFeatures.sortFeatures(sfs, forwardStrand);
        boolean transferred = false;
        for (SequenceFeature sf : sfs) {
            if (!this.retainFeature(sf, parentId)) continue;
            this.transferFeature(sf, targetSequence, mapping, forwardStrand);
            transferred = true;
        }
        return transferred;
    }

    protected boolean retainFeature(SequenceFeature sf, String accessionId) {
        return true;
    }

    protected boolean featureMayBelong(SequenceFeature sf, String identifier) {
        String parent = (String)sf.getValue("Parent");
        return parent == null || parent.equalsIgnoreCase(identifier);
    }

    @Override
    public String getDescription() {
        return "Ensembl " + this.getSourceEnsemblType().getType() + " sequence with variant features";
    }

    protected List<SequenceFeature> findFeatures(SequenceI sequence, String term, String parentId) {
        ArrayList<SequenceFeature> result = new ArrayList<SequenceFeature>();
        List<SequenceFeature> sfs = sequence.getFeatures().getFeaturesByOntology(term);
        for (SequenceFeature sf : sfs) {
            String parent = (String)sf.getValue("Parent");
            if (parent == null || !parent.equalsIgnoreCase(parentId)) continue;
            result.add(sf);
        }
        return result;
    }

    public static boolean isTranscript(String featureType) {
        return "NMD_transcript_variant".equals(featureType) || SequenceOntologyFactory.getInstance().isA(featureType, "transcript");
    }

    public static enum EnsemblSeqType {
        GENOMIC("genomic"),
        CDNA("cdna"),
        CDS("cds"),
        PROTEIN("protein");

        private String type;

        private EnsemblSeqType(String t) {
            this.type = t;
        }

        public String getType() {
            return this.type;
        }
    }
}

