/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.GeneLocus;
import jalview.datamodel.Mapping;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.util.MapList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class EnsemblLookup
extends EnsemblRestClient {
    private static final String SPECIES = "species";

    public EnsemblLookup() {
    }

    public EnsemblLookup(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return null;
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        String identifier = ids.get(0);
        return this.getUrl(identifier, null);
    }

    protected URL getUrl(String identifier, String objectType) {
        String url = this.getDomain() + "/lookup/id/" + identifier + "?content-type=application/json";
        if (objectType != null) {
            url = url + "&object_type=" + objectType;
        }
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    public String getGeneId(String identifier) {
        return this.getGeneId(identifier, null);
    }

    public String getGeneId(String identifier, String objectType) {
        return this.parseGeneId(this.getResult(identifier, objectType));
    }

    protected String parseGeneId(JSONObject val) {
        if (val == null) {
            return null;
        }
        String geneId = null;
        String type = val.get((Object)"object_type").toString();
        if ("Gene".equalsIgnoreCase(type)) {
            geneId = val.get((Object)"id").toString();
        } else if ("Transcript".equalsIgnoreCase(type)) {
            geneId = val.get((Object)"Parent").toString();
        } else if ("Translation".equalsIgnoreCase(type)) {
            String transcriptId = val.get((Object)"Parent").toString();
            geneId = this.getGeneId(transcriptId, "Transcript");
        }
        return geneId;
    }

    public String getSpecies(String identifier) {
        Object o;
        String species = null;
        JSONObject json = this.getResult(identifier, null);
        if (json != null && (o = json.get((Object)SPECIES)) != null) {
            species = o.toString();
        }
        return species;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject getResult(String identifier, String objectType) {
        List<String> ids = Arrays.asList(identifier);
        BufferedReader br = null;
        try {
            URL url = this.getUrl(identifier, objectType);
            if (url != null) {
                br = this.getHttpResponse(url, ids);
            }
            JSONObject jSONObject = br == null ? null : (JSONObject)new JSONParser().parse((Reader)br);
            return jSONObject;
        }
        catch (IOException | ParseException e) {
            System.err.println("Error parsing " + identifier + " lookup response " + e.getMessage());
            JSONObject jSONObject = null;
            return jSONObject;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public GeneLociI getGeneLoci(String geneId) {
        return this.parseGeneLoci(this.getResult(geneId, "Gene"));
    }

    GeneLociI parseGeneLoci(JSONObject json) {
        if (json == null) {
            return null;
        }
        try {
            String species = json.get((Object)SPECIES).toString();
            String assembly = json.get((Object)"assembly_name").toString();
            String chromosome = json.get((Object)"seq_region_name").toString();
            String strand = json.get((Object)"strand").toString();
            int start = Integer.parseInt(json.get((Object)"start").toString());
            int end = Integer.parseInt(json.get((Object)"end").toString());
            int fromEnd = end - start + 1;
            boolean reverseStrand = "-1".equals(strand);
            int toStart = reverseStrand ? end : start;
            int toEnd = reverseStrand ? start : end;
            List<int[]> fromRange = Collections.singletonList(new int[]{1, fromEnd});
            List<int[]> toRange = Collections.singletonList(new int[]{toStart, toEnd});
            Mapping map = new Mapping(new MapList(fromRange, toRange, 1, 1));
            return new GeneLocus(species == null ? "" : species, assembly, chromosome, map);
        }
        catch (NullPointerException | NumberFormatException e) {
            Cache.log.error((Object)("Error looking up gene loci: " + e.getMessage()));
            e.printStackTrace();
            return null;
        }
    }
}

