/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.ensembl;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.ensembl.EnsemblRestClient;
import jalview.ext.ensembl.EnsemblSequenceFetcher;
import jalview.util.JSONUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

class EnsemblFeatures
extends EnsemblRestClient {
    private EnsemblSequenceFetcher.EnsemblFeatureType[] featuresWanted = new EnsemblSequenceFetcher.EnsemblFeatureType[]{EnsemblSequenceFetcher.EnsemblFeatureType.cds, EnsemblSequenceFetcher.EnsemblFeatureType.exon, EnsemblSequenceFetcher.EnsemblFeatureType.variation};

    public EnsemblFeatures() {
    }

    public EnsemblFeatures(String d) {
        super(d);
    }

    @Override
    public String getDbName() {
        return "ENSEMBL (features)";
    }

    @Override
    public AlignmentI getSequenceRecords(String query) throws IOException {
        ArrayList<String> queries = new ArrayList<String>();
        queries.add(query);
        BufferedReader fp = this.getSequenceReader(queries);
        if (fp == null) {
            return null;
        }
        SequenceI seq = this.parseFeaturesJson(fp);
        return new Alignment(new SequenceI[]{seq});
    }

    private SequenceI parseFeaturesJson(BufferedReader br) {
        Sequence seq = new Sequence("Dummy", "");
        JSONParser jp = new JSONParser();
        try {
            JSONArray responses = (JSONArray)jp.parse((Reader)br);
            Iterator rvals = responses.iterator();
            while (rvals.hasNext()) {
                try {
                    JSONObject obj = (JSONObject)rvals.next();
                    String type = obj.get((Object)"feature_type").toString();
                    int start = Integer.parseInt(obj.get((Object)"start").toString());
                    int end = Integer.parseInt(obj.get((Object)"end").toString());
                    String source = obj.get((Object)"source").toString();
                    String strand = obj.get((Object)"strand").toString();
                    Object phase = obj.get((Object)"phase");
                    String alleles = JSONUtils.arrayToList((JSONArray)obj.get((Object)"alleles"));
                    String clinSig = JSONUtils.arrayToList((JSONArray)obj.get((Object)"clinical_significance"));
                    if ("variation".equals(type)) {
                        type = "sequence_variant";
                    } else if ("CDS".equalsIgnoreCase(type)) {
                        type = "CDS";
                    }
                    String desc = this.getFirstNotNull(obj, "alleles", "external_name", "id");
                    SequenceFeature sf = new SequenceFeature(type, desc, start, end, source);
                    sf.setStrand("1".equals(strand) ? "+" : "-");
                    if (phase != null) {
                        sf.setPhase(phase.toString());
                    }
                    this.setFeatureAttribute(sf, obj, "id");
                    this.setFeatureAttribute(sf, obj, "Parent");
                    this.setFeatureAttribute(sf, obj, "consequence_type");
                    sf.setValue("alleles", alleles);
                    sf.setValue("clinical_significance", clinSig);
                    seq.addSequenceFeature(sf);
                }
                catch (Throwable throwable) {}
            }
        }
        catch (IOException | ParseException throwable) {
            // empty catch block
        }
        return seq;
    }

    protected String getFirstNotNull(JSONObject obj, String ... keys) {
        String desc = null;
        for (String key : keys) {
            String s;
            Object val = obj.get((Object)key);
            if (val == null) continue;
            String string = s = val instanceof JSONArray ? JSONUtils.arrayToList((JSONArray)val) : val.toString();
            if (s.isEmpty()) continue;
            return s;
        }
        return desc;
    }

    protected void setFeatureAttribute(SequenceFeature sf, JSONObject obj, String key) {
        Object object = obj.get((Object)key);
        if (object != null) {
            sf.setValue(key, object.toString());
        }
    }

    @Override
    protected URL getUrl(List<String> ids) throws MalformedURLException {
        StringBuffer urlstring = new StringBuffer(128);
        urlstring.append(this.getDomain()).append("/overlap/id/").append(ids.get(0));
        urlstring.append("?content-type=" + this.getResponseMimeType());
        urlstring.append("&").append("object_type").append("=").append("Gene");
        for (EnsemblSequenceFetcher.EnsemblFeatureType feature : this.featuresWanted) {
            urlstring.append("&feature=").append(feature.name());
        }
        return new URL(urlstring.toString());
    }

    @Override
    protected boolean useGetRequest() {
        return true;
    }

    @Override
    protected String getRequestMimeType() {
        return "application/json";
    }

    @Override
    protected String getResponseMimeType() {
        return "application/json";
    }

    protected AlignmentI getSequenceRecords(String accId, EnsemblSequenceFetcher.EnsemblFeatureType[] features) throws IOException {
        this.featuresWanted = features;
        return this.getSequenceRecords(accId);
    }
}

