/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import fr.orsay.lri.varna.models.rna.RNA;
import jalview.analysis.AlignSeq;
import jalview.api.DBRefEntryI;
import jalview.datamodel.ASequence;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.ContiguousI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.GeneLocus;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.Mapping;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.Range;
import jalview.datamodel.SequenceCursor;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.features.SequenceFeatures;
import jalview.datamodel.features.SequenceFeaturesI;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.util.MapList;
import jalview.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class Sequence
extends ASequence
implements SequenceI {
    SequenceI datasetSequence;
    String name;
    private char[] sequence;
    String description;
    int start;
    int end;
    HiddenMarkovModel hmm;
    boolean isHMMConsensusSequence = false;
    Vector<PDBEntry> pdbIds;
    String vamsasId;
    DBRefEntry[] dbrefs;
    RNA rna;
    Vector<AlignmentAnnotation> annotation;
    private SequenceFeaturesI sequenceFeatureStore = new SequenceFeatures();
    private SequenceCursor cursor;
    private int changeCount;
    private boolean _isNa;
    private int _seqhash = 0;

    public Sequence(String name, String sequence, int start, int end) {
        this();
        this.initSeqAndName(name, sequence.toCharArray(), start, end);
    }

    public Sequence(String name, char[] sequence, int start, int end) {
        this();
        this.initSeqAndName(name, sequence, start, end);
    }

    protected void initSeqAndName(String name2, char[] sequence2, int start2, int end2) {
        this.name = name2;
        this.sequence = sequence2;
        this.start = start2;
        this.end = end2;
        this.parseId();
        this.checkValidRange();
    }

    void parseId() {
        String suffix;
        String[] range;
        int slashPos;
        if (this.name == null) {
            System.err.println("POSSIBLE IMPLEMENTATION ERROR: null sequence name passed to constructor.");
            this.name = "";
        }
        if ((slashPos = this.name.lastIndexOf(47)) > -1 && slashPos < this.name.length() - 1 && (range = (suffix = this.name.substring(slashPos + 1)).split("-")).length == 2) {
            try {
                int from = Integer.valueOf(range[0]);
                int to = Integer.valueOf(range[1]);
                if (from > 0 && to >= from) {
                    this.name = this.name.substring(0, slashPos);
                    this.setStart(from);
                    this.setEnd(to);
                    this.checkValidRange();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    void checkValidRange() {
        int endRes = 0;
        for (int j = 0; j < this.sequence.length; ++j) {
            if (Comparison.isGap(this.sequence[j])) continue;
            ++endRes;
        }
        if (endRes > 0) {
            endRes += this.start - 1;
        }
        if (this.end < endRes) {
            this.end = endRes;
        }
    }

    private Sequence() {
    }

    public Sequence(String name, String sequence) {
        this(name, sequence, 1, -1);
    }

    public Sequence(SequenceI seq) {
        this(seq, seq.getAnnotation());
    }

    public Sequence(SequenceI seq, AlignmentAnnotation[] alAnnotation) {
        this();
        this.initSeqFrom(seq, alAnnotation);
    }

    protected void initSeqFrom(SequenceI seq, AlignmentAnnotation[] alAnnotation) {
        int i;
        char[] oseq = seq.getSequence();
        this.initSeqAndName(seq.getName(), oseq, seq.getStart(), seq.getEnd());
        this.description = seq.getDescription();
        if (seq != this.datasetSequence) {
            this.setDatasetSequence(seq.getDatasetSequence());
        }
        if (this.datasetSequence == null) {
            if (seq.getDBRefs() != null) {
                DBRefEntry[] dbr = seq.getDBRefs();
                for (i = 0; i < dbr.length; ++i) {
                    this.addDBRef(new DBRefEntry((DBRefEntryI)dbr[i]));
                }
            }
            for (SequenceFeature sf : seq.getSequenceFeatures()) {
                this.addSequenceFeature(new SequenceFeature(sf));
            }
        }
        if (seq.getAnnotation() != null) {
            AlignmentAnnotation[] sqann = seq.getAnnotation();
            for (i = 0; i < sqann.length; ++i) {
                boolean found;
                if (sqann[i] == null) continue;
                boolean bl = found = alAnnotation == null;
                if (!found) {
                    for (int apos = 0; !found && apos < alAnnotation.length; ++apos) {
                        found = alAnnotation[apos] == sqann[i];
                    }
                }
                if (!found) continue;
                AlignmentAnnotation newann = new AlignmentAnnotation(sqann[i]);
                this.addAlignmentAnnotation(newann);
            }
        }
        if (seq.getAllPDBEntries() != null) {
            Vector<PDBEntry> ids = seq.getAllPDBEntries();
            for (PDBEntry pdb : ids) {
                this.addPDBId(new PDBEntry(pdb));
            }
        }
        if (seq.getHMM() != null) {
            this.hmm = new HiddenMarkovModel(seq.getHMM(), this);
        }
    }

    @Override
    public void setSequenceFeatures(List<SequenceFeature> features) {
        if (this.datasetSequence != null) {
            this.datasetSequence.setSequenceFeatures(features);
            return;
        }
        this.sequenceFeatureStore = new SequenceFeatures(features);
    }

    @Override
    public synchronized boolean addSequenceFeature(SequenceFeature sf) {
        if (sf.getType() == null) {
            System.err.println("SequenceFeature type may not be null: " + sf.toString());
            return false;
        }
        if (this.datasetSequence != null) {
            return this.datasetSequence.addSequenceFeature(sf);
        }
        return this.sequenceFeatureStore.add(sf);
    }

    @Override
    public void deleteFeature(SequenceFeature sf) {
        if (this.datasetSequence != null) {
            this.datasetSequence.deleteFeature(sf);
        } else {
            this.sequenceFeatureStore.delete(sf);
        }
    }

    @Override
    public List<SequenceFeature> getSequenceFeatures() {
        if (this.datasetSequence != null) {
            return this.datasetSequence.getSequenceFeatures();
        }
        return this.sequenceFeatureStore.getAllFeatures(new String[0]);
    }

    @Override
    public SequenceFeaturesI getFeatures() {
        return this.datasetSequence != null ? this.datasetSequence.getFeatures() : this.sequenceFeatureStore;
    }

    @Override
    public boolean addPDBId(PDBEntry entry) {
        if (this.pdbIds == null) {
            this.pdbIds = new Vector();
            this.pdbIds.add(entry);
            return true;
        }
        for (PDBEntry pdbe : this.pdbIds) {
            if (!pdbe.updateFrom(entry)) continue;
            return false;
        }
        this.pdbIds.addElement(entry);
        return true;
    }

    @Override
    public void setPDBId(Vector<PDBEntry> id) {
        this.pdbIds = id;
    }

    @Override
    public Vector<PDBEntry> getAllPDBEntries() {
        return this.pdbIds == null ? new Vector<PDBEntry>() : this.pdbIds;
    }

    @Override
    public String getDisplayId(boolean jvsuffix) {
        if (!jvsuffix) {
            return this.name;
        }
        StringBuilder result = new StringBuilder(this.name);
        result.append("/").append(this.start).append("-").append(this.end);
        return result.toString();
    }

    @Override
    public void setName(String theName) {
        this.name = theName;
        this.parseId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setStart(int start) {
        this.start = start;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public int getEnd() {
        return this.end;
    }

    @Override
    public int getLength() {
        return this.sequence.length;
    }

    @Override
    public void setSequence(String seq) {
        this.sequence = seq.toCharArray();
        this.checkValidRange();
        this.sequenceChanged();
    }

    @Override
    public String getSequenceAsString() {
        return new String(this.sequence);
    }

    @Override
    public String getSequenceAsString(int start, int end) {
        return new String(this.getSequence(start, end));
    }

    @Override
    public char[] getSequence() {
        return this.sequence == null ? null : Arrays.copyOf(this.sequence, this.sequence.length);
    }

    @Override
    public char[] getSequence(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (start >= this.sequence.length) {
            return new char[0];
        }
        if (end >= this.sequence.length) {
            end = this.sequence.length;
        }
        char[] reply = new char[end - start];
        System.arraycopy(this.sequence, start, reply, 0, end - start);
        return reply;
    }

    @Override
    public SequenceI getSubSequence(int start, int end) {
        char[] seq;
        if (start < 0) {
            start = 0;
        }
        if ((seq = this.getSequence(start, end)).length == 0) {
            return null;
        }
        int nstart = this.findPosition(start);
        int nend = this.findPosition(end) - 1;
        Sequence nseq = new Sequence(this.getName(), seq, nstart, nend);
        nseq.setDescription(this.description);
        if (this.datasetSequence != null) {
            nseq.setDatasetSequence(this.datasetSequence);
        } else {
            nseq.setDatasetSequence(this);
        }
        return nseq;
    }

    @Override
    public char getCharAt(int i) {
        if (i >= 0 && i < this.sequence.length) {
            return this.sequence[i];
        }
        return ' ';
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public void setGeneLoci(String speciesId, String assemblyId, String chromosomeId, MapList map) {
        this.addDBRef(new GeneLocus(speciesId, assemblyId, chromosomeId, new Mapping(map)));
    }

    @Override
    public GeneLociI getGeneLoci() {
        DBRefEntry[] refs = this.getDBRefs();
        if (refs != null) {
            for (DBRefEntry ref : refs) {
                if (!(ref instanceof GeneLociI)) continue;
                return (GeneLociI)((Object)ref);
            }
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public int findIndex(int pos) {
        int i;
        if (this.isValidCursor(this.cursor)) {
            return this.findIndex(pos, this.cursor);
        }
        int j = this.start;
        int startColumn = 0;
        for (i = 0; i < this.sequence.length && j <= this.end && j <= pos; ++i) {
            if (Comparison.isGap(this.sequence[i])) continue;
            if (j == this.start) {
                startColumn = i;
            }
            ++j;
        }
        if (j == this.end && j < pos) {
            return this.end + 1;
        }
        this.updateCursor(pos, i, startColumn);
        return i;
    }

    protected void updateCursor(int residuePos, int column, int startColumn) {
        int endColumn;
        int n = endColumn = this.isValidCursor(this.cursor) ? this.cursor.lastColumnPosition : 0;
        if (residuePos == this.end) {
            endColumn = column;
        }
        this.cursor = new SequenceCursor(this, residuePos, column, startColumn, endColumn, this.changeCount);
    }

    protected int findIndex(int pos, SequenceCursor curs) {
        int delta;
        if (!this.isValidCursor(curs)) {
            return this.findIndex(pos);
        }
        if (curs.residuePosition == pos) {
            return curs.columnPosition;
        }
        int col = curs.columnPosition - 1;
        int newPos = curs.residuePosition;
        int n = delta = newPos > pos ? -1 : 1;
        while (newPos != pos && (col += delta) >= 0) {
            if (col == this.sequence.length) {
                --col;
                break;
            }
            if (Comparison.isGap(this.sequence[col])) continue;
            newPos += delta;
        }
        ++col;
        if (newPos == pos) {
            this.updateCursor(pos, col, curs.firstColumnPosition);
        }
        return col;
    }

    @Override
    public int findPosition(int column) {
        int j;
        if (this.isValidCursor(this.cursor)) {
            return this.findPosition(column + 1, this.cursor);
        }
        int firstResidueColumn = 0;
        int lastPosFound = 0;
        int lastPosFoundColumn = 0;
        int seqlen = this.sequence.length;
        if (seqlen > 0 && !Comparison.isGap(this.sequence[0])) {
            lastPosFound = this.start;
            lastPosFoundColumn = 0;
        }
        int pos = this.start;
        for (j = 0; j < column && j < seqlen; ++j) {
            if (Comparison.isGap(this.sequence[j])) continue;
            lastPosFound = pos;
            lastPosFoundColumn = j;
            if (pos == this.start) {
                firstResidueColumn = j;
            }
            ++pos;
        }
        if (j < seqlen && !Comparison.isGap(this.sequence[j])) {
            lastPosFound = pos;
            lastPosFoundColumn = j;
            if (pos == this.start) {
                firstResidueColumn = j;
            }
        }
        if (lastPosFound != 0) {
            this.updateCursor(lastPosFound, lastPosFoundColumn + 1, firstResidueColumn + 1);
        }
        return pos;
    }

    protected boolean isValidCursor(SequenceCursor curs) {
        if (curs == null || curs.sequence != this || curs.token != this.changeCount) {
            return false;
        }
        if (curs.columnPosition < 0 || curs.columnPosition > this.sequence.length) {
            return false;
        }
        return curs.residuePosition >= this.start && curs.residuePosition <= this.end;
    }

    protected int findPosition(int col, SequenceCursor curs) {
        if (!this.isValidCursor(curs)) {
            return this.findPosition(col - 1);
        }
        if (curs.columnPosition == col) {
            this.cursor = curs;
            return curs.residuePosition;
        }
        if (curs.lastColumnPosition > 0 && curs.lastColumnPosition < col) {
            return this.end + 1;
        }
        if (curs.firstColumnPosition > 0 && curs.firstColumnPosition > col) {
            return this.start;
        }
        int firstResidueColumn = curs.firstColumnPosition;
        int column = curs.columnPosition - 1;
        int newPos = curs.residuePosition;
        int delta = curs.columnPosition > col ? -1 : 1;
        boolean gapped = false;
        int lastFoundPosition = curs.residuePosition;
        int lastFoundPositionColumn = curs.columnPosition;
        while (column != col - 1 && (column += delta) >= 0 && column != this.sequence.length) {
            gapped = Comparison.isGap(this.sequence[column]);
            if (gapped) continue;
            lastFoundPosition = newPos += delta;
            lastFoundPositionColumn = column + 1;
            if (lastFoundPosition != this.start) continue;
            firstResidueColumn = column + 1;
        }
        if (this.cursor == null || lastFoundPosition != this.cursor.residuePosition) {
            this.updateCursor(lastFoundPosition, lastFoundPositionColumn, firstResidueColumn);
        }
        if (delta > 0 && (gapped || column >= this.sequence.length)) {
            ++newPos;
        }
        return newPos;
    }

    @Override
    public ContiguousI findPositions(int fromColumn, int toColumn) {
        int col;
        if (toColumn < fromColumn || fromColumn < 1) {
            return null;
        }
        int firstPosition = 0;
        int length = this.sequence.length;
        for (col = fromColumn - 1; col < length && col < toColumn; ++col) {
            if (Comparison.isGap(this.sequence[col])) continue;
            firstPosition = this.findPosition(col++);
            break;
        }
        if (firstPosition == 0) {
            return null;
        }
        int lastPosition = firstPosition;
        while (col < length && col < toColumn) {
            if (Comparison.isGap(this.sequence[col++])) continue;
            ++lastPosition;
        }
        return new Range(firstPosition, lastPosition);
    }

    @Override
    public int[] gapMap() {
        String seq = AlignSeq.extractGaps(Comparison.GapChars, new String(this.sequence));
        int[] map = new int[seq.length()];
        int p = 0;
        for (int j = 0; j < this.sequence.length; ++j) {
            if (Comparison.isGap(this.sequence[j])) continue;
            map[p++] = j;
        }
        return map;
    }

    @Override
    public BitSet gapBitset() {
        BitSet gaps = new BitSet(this.sequence.length);
        for (int j = 0; j < this.sequence.length; ++j) {
            if (!Comparison.isGap(this.sequence[j])) continue;
            gaps.set(j);
        }
        return gaps;
    }

    @Override
    public int[] findPositionMap() {
        int[] map = new int[this.sequence.length];
        int pos = this.start;
        int seqlen = this.sequence.length;
        for (int j = 0; j < seqlen; ++j) {
            map[j] = pos++;
            if (Comparison.isGap(this.sequence[j])) continue;
        }
        return map;
    }

    @Override
    public List<int[]> getInsertions() {
        int j;
        ArrayList<int[]> map = new ArrayList<int[]>();
        int lastj = -1;
        int pos = this.start;
        int seqlen = this.sequence.length;
        for (j = 0; j < seqlen; ++j) {
            if (Comparison.isGap(this.sequence[j])) {
                if (lastj != -1) continue;
                lastj = j;
                continue;
            }
            if (lastj == -1) continue;
            map.add(new int[]{lastj, j - 1});
            lastj = -1;
        }
        if (lastj != -1) {
            map.add(new int[]{lastj, j - 1});
            lastj = -1;
        }
        return map;
    }

    @Override
    public BitSet getInsertionsAsBits() {
        int j;
        BitSet map = new BitSet();
        int lastj = -1;
        int pos = this.start;
        int seqlen = this.sequence.length;
        for (j = 0; j < seqlen; ++j) {
            if (Comparison.isGap(this.sequence[j])) {
                if (lastj != -1) continue;
                lastj = j;
                continue;
            }
            if (lastj == -1) continue;
            map.set(lastj, j);
            lastj = -1;
        }
        if (lastj != -1) {
            map.set(lastj, j);
            lastj = -1;
        }
        return map;
    }

    @Override
    public void deleteChars(int i, int j) {
        int newstart = this.start;
        int newend = this.end;
        if (i >= this.sequence.length || i < 0) {
            return;
        }
        char[] tmp = StringUtils.deleteChars(this.sequence, i, j);
        boolean createNewDs = false;
        int startIndex = this.findIndex(this.start) - 1;
        int endIndex = this.findIndex(this.end) - 1;
        int startDeleteColumn = -1;
        int deleteCount = 0;
        for (int s = i; s < j && s < this.sequence.length; ++s) {
            if (Comparison.isGap(this.sequence[s])) continue;
            ++deleteCount;
            if (startDeleteColumn == -1) {
                startDeleteColumn = this.findPosition(s) - this.start;
            }
            if (createNewDs) {
                --newend;
                continue;
            }
            if (startIndex == s) {
                newstart = this.findPosition(j);
                break;
            }
            if (endIndex < j) {
                newend = this.findPosition(i - 1);
                if (!Comparison.isGap(this.sequence[i - 1])) break;
                --newend;
                break;
            }
            createNewDs = true;
            --newend;
        }
        if (createNewDs && this.datasetSequence != null) {
            Sequence ds = new Sequence(this.datasetSequence);
            ds.deleteChars(startDeleteColumn, startDeleteColumn + deleteCount);
            this.datasetSequence = ds;
        }
        this.start = newstart;
        this.end = newend;
        this.sequence = tmp;
        this.sequenceChanged();
    }

    @Override
    public void insertCharAt(int i, int length, char c) {
        char[] tmp = new char[this.sequence.length + length];
        if (i >= this.sequence.length) {
            System.arraycopy(this.sequence, 0, tmp, 0, this.sequence.length);
            i = this.sequence.length;
        } else {
            System.arraycopy(this.sequence, 0, tmp, 0, i);
        }
        int index = i;
        while (length > 0) {
            tmp[index++] = c;
            --length;
        }
        if (i < this.sequence.length) {
            System.arraycopy(this.sequence, i, tmp, index, this.sequence.length - i);
        }
        this.sequence = tmp;
        this.sequenceChanged();
    }

    @Override
    public void insertCharAt(int i, char c) {
        this.insertCharAt(i, 1, c);
    }

    @Override
    public String getVamsasId() {
        return this.vamsasId;
    }

    @Override
    public void setVamsasId(String id) {
        this.vamsasId = id;
    }

    @Override
    public void setDBRefs(DBRefEntry[] dbref) {
        if (this.dbrefs == null && this.datasetSequence != null && this != this.datasetSequence) {
            this.datasetSequence.setDBRefs(dbref);
            return;
        }
        this.dbrefs = dbref;
        if (this.dbrefs != null) {
            DBRefUtils.ensurePrimaries(this);
        }
    }

    @Override
    public DBRefEntry[] getDBRefs() {
        if (this.dbrefs == null && this.datasetSequence != null && this != this.datasetSequence) {
            return this.datasetSequence.getDBRefs();
        }
        return this.dbrefs;
    }

    @Override
    public void addDBRef(DBRefEntry entry) {
        if (this.datasetSequence != null) {
            this.datasetSequence.addDBRef(entry);
            return;
        }
        if (this.dbrefs == null) {
            this.dbrefs = new DBRefEntry[0];
        }
        for (DBRefEntry dbr : this.dbrefs) {
            if (!dbr.updateFrom(entry)) continue;
            return;
        }
        int j = this.dbrefs.length;
        DBRefEntry[] temp = new DBRefEntry[j + 1];
        System.arraycopy(this.dbrefs, 0, temp, 0, j);
        temp[temp.length - 1] = entry;
        this.dbrefs = temp;
        DBRefUtils.ensurePrimaries(this);
    }

    @Override
    public void setDatasetSequence(SequenceI seq) {
        if (seq == this) {
            throw new IllegalArgumentException("Implementation Error: self reference passed to SequenceI.setDatasetSequence");
        }
        if (seq != null && seq.getDatasetSequence() != null) {
            throw new IllegalArgumentException("Implementation error: cascading dataset sequences are not allowed.");
        }
        this.datasetSequence = seq;
    }

    @Override
    public SequenceI getDatasetSequence() {
        return this.datasetSequence;
    }

    @Override
    public AlignmentAnnotation[] getAnnotation() {
        return this.annotation == null ? null : this.annotation.toArray(new AlignmentAnnotation[this.annotation.size()]);
    }

    @Override
    public boolean hasAnnotation(AlignmentAnnotation ann) {
        return this.annotation == null ? false : this.annotation.contains(ann);
    }

    @Override
    public void addAlignmentAnnotation(AlignmentAnnotation annotation) {
        if (this.annotation == null) {
            this.annotation = new Vector();
        }
        if (!this.annotation.contains(annotation)) {
            this.annotation.addElement(annotation);
        }
        annotation.setSequenceRef(this);
    }

    @Override
    public void removeAlignmentAnnotation(AlignmentAnnotation annotation) {
        if (this.annotation != null) {
            this.annotation.removeElement(annotation);
            if (this.annotation.size() == 0) {
                this.annotation = null;
            }
        }
    }

    private boolean isValidDatasetSequence() {
        if (this.datasetSequence != null) {
            return false;
        }
        for (int i = 0; i < this.sequence.length; ++i) {
            if (!Comparison.isGap(this.sequence[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public SequenceI deriveSequence() {
        Sequence seq = null;
        if (this.datasetSequence == null) {
            if (this.isValidDatasetSequence()) {
                seq = new Sequence(this.getName(), "", 1, -1);
                seq.setDatasetSequence(this);
                seq.initSeqFrom(this, this.getAnnotation());
                return seq;
            }
            this.createDatasetSequence();
        }
        return new Sequence(this);
    }

    @Override
    public boolean isProtein() {
        if (this.datasetSequence != null) {
            return this.datasetSequence.isProtein();
        }
        if (this._seqhash != this.sequence.hashCode()) {
            this._seqhash = this.sequence.hashCode();
            this._isNa = Comparison.isNucleotide(this);
        }
        return !this._isNa;
    }

    @Override
    public SequenceI createDatasetSequence() {
        if (this.datasetSequence == null) {
            Sequence dsseq = new Sequence(this.getName(), AlignSeq.extractGaps(Comparison.GapChars, this.getSequenceAsString()), this.getStart(), this.getEnd());
            this.datasetSequence = dsseq;
            dsseq.setDescription(this.description);
            dsseq.sequenceFeatureStore = this.sequenceFeatureStore;
            this.sequenceFeatureStore = null;
            dsseq.dbrefs = this.dbrefs;
            this.dbrefs = null;
            dsseq.pdbIds = this.pdbIds;
            this.pdbIds = null;
            this.datasetSequence.updatePDBIds();
            if (this.annotation != null) {
                for (AlignmentAnnotation aa : this.annotation) {
                    AlignmentAnnotation _aa = new AlignmentAnnotation(aa);
                    _aa.sequenceRef = this.datasetSequence;
                    _aa.adjustForAlignment();
                    this.datasetSequence.addAlignmentAnnotation(_aa);
                }
            }
        }
        return this.datasetSequence;
    }

    @Override
    public void setAlignmentAnnotation(AlignmentAnnotation[] annotations) {
        if (this.annotation != null) {
            this.annotation.removeAllElements();
        }
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] == null) continue;
                this.addAlignmentAnnotation(annotations[i]);
            }
        }
    }

    @Override
    public AlignmentAnnotation[] getAnnotation(String label) {
        if (this.annotation == null || this.annotation.size() == 0) {
            return null;
        }
        Vector<AlignmentAnnotation> subset = new Vector<AlignmentAnnotation>();
        Enumeration<AlignmentAnnotation> e = this.annotation.elements();
        while (e.hasMoreElements()) {
            AlignmentAnnotation ann = e.nextElement();
            if (ann.label == null || !ann.label.equals(label)) continue;
            subset.addElement(ann);
        }
        if (subset.size() == 0) {
            return null;
        }
        AlignmentAnnotation[] anns = new AlignmentAnnotation[subset.size()];
        int i = 0;
        e = subset.elements();
        while (e.hasMoreElements()) {
            anns[i++] = e.nextElement();
        }
        subset.removeAllElements();
        return anns;
    }

    @Override
    public boolean updatePDBIds() {
        if (this.datasetSequence != null) {
            return this.datasetSequence.updatePDBIds();
        }
        if (this.dbrefs == null || this.dbrefs.length == 0) {
            return false;
        }
        boolean added = false;
        for (DBRefEntry dbr : this.dbrefs) {
            if (!"PDB".equals(dbr.getSource())) continue;
            PDBEntry pdbe = new PDBEntry(dbr);
            added |= this.addPDBId(pdbe);
        }
        return added;
    }

    @Override
    public void transferAnnotation(SequenceI entry, Mapping mp) {
        DBRefEntry[] entryRefs;
        if (this.datasetSequence != null) {
            this.datasetSequence.transferAnnotation(entry, mp);
            return;
        }
        if (entry.getDatasetSequence() != null) {
            this.transferAnnotation(entry.getDatasetSequence(), mp);
            return;
        }
        if (entry.getSequenceFeatures() != null) {
            List<SequenceFeature> sfs = entry.getSequenceFeatures();
            for (SequenceFeature feature : sfs) {
                SequenceFeature[] sf;
                SequenceFeature[] sequenceFeatureArray;
                if (mp != null) {
                    sequenceFeatureArray = mp.locateFeature(feature);
                } else {
                    SequenceFeature[] sequenceFeatureArray2 = new SequenceFeature[1];
                    sequenceFeatureArray = sequenceFeatureArray2;
                    sequenceFeatureArray2[0] = new SequenceFeature(feature);
                }
                if ((sf = sequenceFeatureArray) == null) continue;
                for (int sfi = 0; sfi < sf.length; ++sfi) {
                    this.addSequenceFeature(sf[sfi]);
                }
            }
        }
        if (entry.getAllPDBEntries() != null) {
            Enumeration<PDBEntry> e = entry.getAllPDBEntries().elements();
            while (e.hasMoreElements()) {
                PDBEntry pdb = e.nextElement();
                this.addPDBId(pdb);
            }
        }
        if ((entryRefs = entry.getDBRefs()) != null) {
            for (int r = 0; r < entryRefs.length; ++r) {
                DBRefEntry newref = new DBRefEntry(entryRefs[r]);
                if (newref.getMap() == null || mp != null) {
                    // empty if block
                }
                this.addDBRef(newref);
            }
        }
    }

    @Override
    public void setRNA(RNA r) {
        this.rna = r;
    }

    @Override
    public RNA getRNA() {
        return this.rna;
    }

    @Override
    public List<AlignmentAnnotation> getAlignmentAnnotations(String calcId, String label) {
        ArrayList<AlignmentAnnotation> result = new ArrayList<AlignmentAnnotation>();
        if (this.annotation != null) {
            for (AlignmentAnnotation ann : this.annotation) {
                String id = ann.getCalcId();
                if (id == null || !id.equals(calcId) || ann.label == null || !ann.label.equals(label)) continue;
                result.add(ann);
            }
        }
        return result;
    }

    public String toString() {
        return this.getDisplayId(false);
    }

    @Override
    public PDBEntry getPDBEntry(String pdbIdStr) {
        if (this.getDatasetSequence() != null) {
            return this.getDatasetSequence().getPDBEntry(pdbIdStr);
        }
        if (this.pdbIds == null) {
            return null;
        }
        Vector<PDBEntry> entries = this.getAllPDBEntries();
        for (PDBEntry entry : entries) {
            if (!entry.getId().equalsIgnoreCase(pdbIdStr)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DBRefEntry> getPrimaryDBRefs() {
        if (this.datasetSequence != null) {
            return this.datasetSequence.getPrimaryDBRefs();
        }
        if (this.dbrefs == null || this.dbrefs.length == 0) {
            return Collections.emptyList();
        }
        DBRefEntry[] dBRefEntryArray = this.dbrefs;
        synchronized (this.dbrefs) {
            ArrayList<DBRefEntry> primaries = new ArrayList<DBRefEntry>();
            DBRefEntry[] tmp = new DBRefEntry[1];
            for (DBRefEntry ref : this.dbrefs) {
                MapList mp;
                if (!ref.isPrimaryCandidate() || ref.hasMap() && ((mp = ref.getMap().getMap()).getFromLowest() > this.start || mp.getFromHighest() < this.end)) continue;
                if (DBRefUtils.getCanonicalName("PDB").equals(DBRefUtils.getCanonicalName(ref.getSource()))) {
                    PDBEntry pdbentry = this.getPDBEntry(ref.getAccessionId());
                    if (pdbentry == null || pdbentry.getFile() == null) continue;
                    primaries.add(ref);
                    continue;
                }
                tmp[0] = ref;
                DBRefEntry[] res = DBRefUtils.selectDbRefs(!this.isProtein(), tmp);
                if (res == null || res[0] != tmp[0]) continue;
                primaries.add(ref);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return primaries;
        }
    }

    @Override
    public HiddenMarkovModel getHMM() {
        return this.hmm;
    }

    @Override
    public void setHMM(HiddenMarkovModel hmm) {
        this.hmm = hmm;
    }

    @Override
    public boolean hasHMMAnnotation() {
        if (this.annotation == null) {
            return false;
        }
        for (AlignmentAnnotation ann : this.annotation) {
            if (!"HMM".equals(ann.getCalcId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<SequenceFeature> findFeatures(int fromColumn, int toColumn, String ... types) {
        boolean endColumnIsGapped;
        int startPos = this.findPosition(fromColumn - 1);
        int endPos = fromColumn == toColumn ? startPos : this.findPosition(toColumn - 1);
        List<SequenceFeature> result = this.getFeatures().findFeatures(startPos, endPos, types);
        result = this.datasetSequence != null ? this.datasetSequence.getFeatures().findFeatures(startPos, endPos, types) : this.sequenceFeatureStore.findFeatures(startPos, endPos, types);
        boolean bl = endColumnIsGapped = toColumn > 0 && toColumn <= this.sequence.length && Comparison.isGap(this.sequence[toColumn - 1]);
        if (endPos > this.end || endColumnIsGapped) {
            ListIterator<SequenceFeature> it = result.listIterator();
            while (it.hasNext()) {
                int featureEndColumn;
                SequenceFeature sf = it.next();
                int sfBegin = sf.getBegin();
                int sfEnd = sf.getEnd();
                int featureStartColumn = this.findIndex(sfBegin);
                if (featureStartColumn > toColumn) {
                    it.remove();
                    continue;
                }
                if (featureStartColumn >= fromColumn) continue;
                int n = featureEndColumn = sfEnd == sfBegin ? featureStartColumn : this.findIndex(sfEnd);
                if (featureEndColumn < fromColumn) {
                    it.remove();
                    continue;
                }
                if (featureEndColumn <= toColumn || !sf.isContactFeature()) continue;
                it.remove();
            }
        }
        return result;
    }

    @Override
    public void sequenceChanged() {
        ++this.changeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int replace(char c1, char c2) {
        if (c1 == c2) {
            return 0;
        }
        int count = 0;
        char[] cArray = this.sequence;
        synchronized (this.sequence) {
            for (int c = 0; c < this.sequence.length; ++c) {
                if (this.sequence[c] != c1) continue;
                this.sequence[c] = c2;
                ++count;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (count > 0) {
                this.sequenceChanged();
            }
            return count;
        }
    }

    @Override
    public String getSequenceStringFromIterator(Iterator<int[]> it) {
        StringBuilder newSequence = new StringBuilder();
        while (it.hasNext()) {
            int[] block = it.next();
            if (it.hasNext()) {
                newSequence.append(this.getSequence(block[0], block[1] + 1));
                continue;
            }
            newSequence.append(this.getSequence(block[0], block[1]));
        }
        return newSequence.toString();
    }

    @Override
    public int firstResidueOutsideIterator(Iterator<int[]> regions) {
        int start = 0;
        if (!regions.hasNext()) {
            return this.findIndex(this.getStart()) - 1;
        }
        int hideStart = this.getLength();
        int hideEnd = -1;
        boolean foundStart = false;
        for (int i = this.getStart(); i <= this.getEnd() && !foundStart; ++i) {
            int p = this.findIndex(i) - 1;
            while (hideEnd < p && regions.hasNext()) {
                int[] region = regions.next();
                hideStart = region[0];
                hideEnd = region[1];
            }
            if (hideEnd < p) {
                hideStart = this.getLength();
            }
            if (p >= hideStart) continue;
            start = p;
            foundStart = true;
        }
        if (foundStart) {
            return start;
        }
        return 0;
    }

    @Override
    public boolean hasHMMProfile() {
        return this.hmm != null;
    }
}

