/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.datamodel.Sequence;
import jalview.schemes.ResidueProperties;

public class BinarySequence
extends Sequence {
    int[] binary;
    double[] dbinary;
    boolean isNa = false;

    public BinarySequence(String s, boolean isNa) {
        super("", s, 0, s.length());
        this.isNa = isNa;
    }

    private int initMatrixGetNoRes() {
        int nores = this.isNa ? 10 : 23;
        this.dbinary = new double[this.getLength() * nores];
        return nores;
    }

    private int[] getSymbolmatrix() {
        return this.isNa ? ResidueProperties.nucleotideIndex : ResidueProperties.aaIndex;
    }

    public void encode() {
        int nores = this.initMatrixGetNoRes();
        int[] sindex = this.getSymbolmatrix();
        for (int i = 0; i < this.getLength(); ++i) {
            int aanum = nores - 1;
            try {
                aanum = sindex[this.getCharAt(i)];
            }
            catch (NullPointerException e) {
                aanum = nores - 1;
            }
            if (aanum >= nores) {
                aanum = nores - 1;
            }
            this.dbinary[i * nores + aanum] = 1.0;
        }
    }

    public void matrixEncode(ScoreMatrix smtrx) throws InvalidSequenceTypeException {
        if (this.isNa != smtrx.isDNA()) {
            throw new InvalidSequenceTypeException("matrix " + smtrx.getClass().getCanonicalName() + " is not a valid matrix for " + (this.isNa ? "nucleotide" : "protein") + "sequences");
        }
        this.matrixEncode(smtrx.isDNA() ? ResidueProperties.nucleotideIndex : ResidueProperties.aaIndex, smtrx.getMatrix());
    }

    private void matrixEncode(int[] aaIndex, float[][] matrix) {
        int nores = this.initMatrixGetNoRes();
        int iSize = this.getLength();
        for (int i = 0; i < iSize; ++i) {
            int aanum = nores - 1;
            try {
                aanum = aaIndex[this.getCharAt(i)];
            }
            catch (NullPointerException e) {
                aanum = nores - 1;
            }
            if (aanum >= nores) {
                aanum = nores - 1;
            }
            for (int j = 0; j < nores; ++j) {
                this.dbinary[i * nores + j] = matrix[aanum][j];
            }
        }
    }

    public String toBinaryString() {
        String out = "";
        for (int i = 0; i < this.binary.length; ++i) {
            out = out + Integer.valueOf(this.binary[i]).toString();
            if (i >= this.binary.length - 1) continue;
            out = out + " ";
        }
        return out;
    }

    public double[] getDBinary() {
        return this.dbinary;
    }

    public class InvalidSequenceTypeException
    extends Exception {
        public InvalidSequenceTypeException(String string) {
            super(string);
        }
    }
}

