/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.Mapping;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceDummy;
import jalview.datamodel.SequenceI;
import jalview.util.MapList;
import jalview.util.MappingUtils;
import java.util.ArrayList;
import java.util.List;

public class AlignedCodonFrame {
    private List<SequenceToSequenceMapping> mappings = new ArrayList<SequenceToSequenceMapping>();

    public void addMap(SequenceI dnaseq, SequenceI aaseq, MapList map) {
        this.addMap(dnaseq, aaseq, map, null);
    }

    public void addMap(SequenceI dnaseq, SequenceI aaseq, MapList map, String mapFromId) {
        SequenceI fromSeq = dnaseq.getDatasetSequence() == null ? dnaseq : dnaseq.getDatasetSequence();
        SequenceI toSeq = aaseq.getDatasetSequence() == null ? aaseq : aaseq.getDatasetSequence();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (ssm.fromSeq != fromSeq || ((SequenceToSequenceMapping)ssm).mapping.to != toSeq) continue;
            ((SequenceToSequenceMapping)ssm).mapping.map.addMapList(map);
            return;
        }
        Mapping mp = new Mapping(toSeq, map);
        mp.setMappedFromId(mapFromId);
        this.mappings.add(new SequenceToSequenceMapping(fromSeq, mp));
    }

    public SequenceI[] getdnaSeqs() {
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            seqs.add(ssm.fromSeq);
        }
        return seqs.toArray(new SequenceI[seqs.size()]);
    }

    public SequenceI[] getAaSeqs() {
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            seqs.add(((SequenceToSequenceMapping)ssm).mapping.to);
        }
        return seqs.toArray(new SequenceI[seqs.size()]);
    }

    public MapList[] getdnaToProt() {
        ArrayList<MapList> maps = new ArrayList<MapList>();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            maps.add(((SequenceToSequenceMapping)ssm).mapping.map);
        }
        return maps.toArray(new MapList[maps.size()]);
    }

    public Mapping[] getProtMappings() {
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            maps.add(ssm.mapping);
        }
        return maps.toArray(new Mapping[maps.size()]);
    }

    public Mapping getMappingForSequence(SequenceI seq) {
        SequenceI seqDs = seq.getDatasetSequence();
        seqDs = seqDs != null ? seqDs : seq;
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (ssm.fromSeq != seqDs && ((SequenceToSequenceMapping)ssm).mapping.to != seqDs) continue;
            return ssm.mapping;
        }
        return null;
    }

    public SequenceI getAaForDnaSeq(SequenceI dnaSeqRef) {
        SequenceI dnads = dnaSeqRef.getDatasetSequence();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (ssm.fromSeq != dnaSeqRef && ssm.fromSeq != dnads) continue;
            return ((SequenceToSequenceMapping)ssm).mapping.to;
        }
        return null;
    }

    public SequenceI getDnaForAaSeq(SequenceI aaSeqRef) {
        SequenceI aads = aaSeqRef.getDatasetSequence();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (((SequenceToSequenceMapping)ssm).mapping.to != aaSeqRef && ((SequenceToSequenceMapping)ssm).mapping.to != aads) continue;
            return ssm.fromSeq;
        }
        return null;
    }

    public boolean involvesSequence(SequenceI seq) {
        return this.getAaForDnaSeq(seq) != null || this.getDnaForAaSeq(seq) != null;
    }

    public void markMappedRegion(SequenceI seq, int index, SearchResultsI results) {
        SequenceI ds = seq.getDatasetSequence();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            int i;
            int[] codon;
            if (ssm.fromSeq == seq || ssm.fromSeq == ds) {
                codon = ((SequenceToSequenceMapping)ssm).mapping.map.locateInTo(index, index);
                if (codon == null) continue;
                for (i = 0; i < codon.length; i += 2) {
                    results.addResult(((SequenceToSequenceMapping)ssm).mapping.to, codon[i], codon[i + 1]);
                }
                continue;
            }
            if (((SequenceToSequenceMapping)ssm).mapping.to != seq && ((SequenceToSequenceMapping)ssm).mapping.to != ds || (codon = ((SequenceToSequenceMapping)ssm).mapping.map.locateInFrom(index, index)) == null) continue;
            for (i = 0; i < codon.length; i += 2) {
                results.addResult(ssm.fromSeq, codon[i], codon[i + 1]);
            }
        }
    }

    public int[] getDnaPosition(SequenceI seq, int aaPos) {
        MapList ml = null;
        int i = 0;
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (ssm.fromSeq == seq) {
                ml = this.getdnaToProt()[i];
                break;
            }
            ++i;
        }
        return ml == null ? null : ml.locateInFrom(aaPos, aaPos);
    }

    public SequenceI findAlignedSequence(SequenceI seq, AlignmentI al) {
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (ssm.fromSeq != seq && ssm.fromSeq != seq.getDatasetSequence()) continue;
            for (SequenceI sourceAligned : al.getSequences()) {
                if (((SequenceToSequenceMapping)ssm).mapping.to != sourceAligned.getDatasetSequence() && ((SequenceToSequenceMapping)ssm).mapping.to != sourceAligned) continue;
                return sourceAligned;
            }
        }
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (((SequenceToSequenceMapping)ssm).mapping.to != seq && ((SequenceToSequenceMapping)ssm).mapping.to != seq.getDatasetSequence()) continue;
            for (SequenceI sourceAligned : al.getSequences()) {
                if (ssm.fromSeq != sourceAligned.getDatasetSequence()) continue;
                return sourceAligned;
            }
        }
        return null;
    }

    public int[] getMappedRegion(SequenceI target, SequenceI query, int queryPos) {
        SequenceI queryDs;
        SequenceI targetDs = target.getDatasetSequence() == null ? target : target.getDatasetSequence();
        SequenceI sequenceI = queryDs = query.getDatasetSequence() == null ? query : query.getDatasetSequence();
        if (targetDs == null || queryDs == null) {
            return null;
        }
        for (SequenceToSequenceMapping ssm : this.mappings) {
            int[] codon;
            if (!(ssm.fromSeq == targetDs && ((SequenceToSequenceMapping)ssm).mapping.to == queryDs ? (codon = ((SequenceToSequenceMapping)ssm).mapping.map.locateInFrom(queryPos, queryPos)) != null : ssm.fromSeq == queryDs && ((SequenceToSequenceMapping)ssm).mapping.to == targetDs && (codon = ((SequenceToSequenceMapping)ssm).mapping.map.locateInTo(queryPos, queryPos)) != null)) continue;
            return codon;
        }
        return null;
    }

    public List<char[]> getMappedCodons(SequenceI protein, int aaPos) {
        MapList ml = null;
        SequenceI dnaSeq = null;
        ArrayList<char[]> result = new ArrayList<char[]>();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (((SequenceToSequenceMapping)ssm).mapping.to != protein || ssm.mapping.getMap().getFromRatio() != 3) continue;
            ml = ((SequenceToSequenceMapping)ssm).mapping.map;
            dnaSeq = ssm.fromSeq;
            int[] codonPos = ml.locateInFrom(aaPos, aaPos);
            if (codonPos == null) {
                return null;
            }
            codonPos = MappingUtils.flattenRanges(codonPos);
            int start = dnaSeq.getStart();
            char c1 = dnaSeq.getCharAt(codonPos[0] - start);
            char c2 = dnaSeq.getCharAt(codonPos[1] - start);
            char c3 = dnaSeq.getCharAt(codonPos[2] - start);
            result.add(new char[]{c1, c2, c3});
        }
        return result.isEmpty() ? null : result;
    }

    public List<Mapping> getMappingsFromSequence(SequenceI seq) {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        ArrayList<SequenceI> related = new ArrayList<SequenceI>();
        SequenceI seqDs = seq.getDatasetSequence();
        seqDs = seqDs != null ? seqDs : seq;
        for (SequenceToSequenceMapping ssm : this.mappings) {
            Mapping mapping = ssm.mapping;
            if (ssm.fromSeq != seqDs || related.contains(mapping.to)) continue;
            result.add(mapping);
            related.add(mapping.to);
        }
        return result;
    }

    public boolean isRealisableWith(SequenceI seq) {
        return this.realiseWith(seq, false) > 0;
    }

    public int realiseWith(SequenceI seq) {
        return this.realiseWith(seq, true);
    }

    protected int realiseWith(SequenceI seq, boolean doUpdate) {
        SequenceI ds = seq.getDatasetSequence() != null ? seq.getDatasetSequence() : seq;
        int count = 0;
        for (SequenceToSequenceMapping ssm : this.mappings) {
            int mapEnd;
            int mapStart;
            SequenceI prot;
            boolean mappable;
            int mapEnd2;
            Mapping mapping;
            int mapStart2;
            boolean mappable2;
            SequenceI dna = ssm.fromSeq;
            if (dna instanceof SequenceDummy && dna.getName().equals(ds.getName()) && (mappable2 = AlignedCodonFrame.couldRealiseSequence(dna, ds, mapStart2 = (mapping = ssm.mapping).getMap().getFromLowest(), mapEnd2 = mapping.getMap().getFromHighest()))) {
                ++count;
                if (doUpdate) {
                    ds.setSequenceFeatures(dna.getSequenceFeatures());
                    ssm.fromSeq = ds;
                    System.out.println("Realised mapped sequence " + ds.getName());
                }
            }
            if (!(mappable = AlignedCodonFrame.couldRealiseSequence(prot = (mapping = ssm.mapping).getTo(), ds, mapStart = mapping.getMap().getToLowest(), mapEnd = mapping.getMap().getToHighest()))) continue;
            ++count;
            if (!doUpdate) continue;
            ds.setSequenceFeatures(dna.getSequenceFeatures());
            ssm.mapping.setTo(ds);
        }
        return count;
    }

    protected static boolean couldRealiseSequence(SequenceI existing, SequenceI replacement, int mapStart, int mapEnd) {
        if (existing instanceof SequenceDummy && !(replacement instanceof SequenceDummy) && existing.getName().equals(replacement.getName())) {
            boolean mappingOverlapsSequence;
            int start = replacement.getStart();
            int end = replacement.getEnd();
            boolean bl = mappingOverlapsSequence = mapStart >= start && mapStart <= end || mapEnd >= start && mapEnd <= end;
            if (mappingOverlapsSequence) {
                return true;
            }
        }
        return false;
    }

    public void updateToDataset(SequenceI seq) {
        if (seq == null || seq.getDatasetSequence() == null) {
            return;
        }
        SequenceI ds = seq.getDatasetSequence();
        for (SequenceToSequenceMapping ssm : this.mappings) {
            if (ssm.fromSeq == seq) {
                ssm.fromSeq = ds;
            }
            if (((SequenceToSequenceMapping)ssm).mapping.to != seq) continue;
            ((SequenceToSequenceMapping)ssm).mapping.to = ds;
        }
    }

    public boolean isEmpty() {
        return this.mappings.isEmpty();
    }

    public String toString() {
        return this.mappings == null ? "null" : this.mappings.toString();
    }

    public Mapping getMappingBetween(SequenceI fromSeq, SequenceI toSeq) {
        SequenceI dssFrom = fromSeq.getDatasetSequence() == null ? fromSeq : fromSeq.getDatasetSequence();
        SequenceI dssTo = toSeq.getDatasetSequence() == null ? toSeq : toSeq.getDatasetSequence();
        for (SequenceToSequenceMapping mapping : this.mappings) {
            SequenceI from = mapping.fromSeq;
            SequenceI to = ((SequenceToSequenceMapping)mapping).mapping.to;
            if ((from != dssFrom || to != dssTo) && (from != dssTo || to != dssFrom)) continue;
            return mapping.mapping;
        }
        return null;
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlignedCodonFrame)) {
            return false;
        }
        return this.mappings.equals(((AlignedCodonFrame)obj).mappings);
    }

    public List<SequenceToSequenceMapping> getMappings() {
        return this.mappings;
    }

    public class SequenceToSequenceMapping {
        private SequenceI fromSeq;
        private Mapping mapping;

        SequenceToSequenceMapping(SequenceI from, Mapping map) {
            this.fromSeq = from;
            this.mapping = map;
        }

        public String toString() {
            return String.format("From %s %s", this.fromSeq.getName(), this.mapping.toString());
        }

        public int hashCode() {
            return (this.fromSeq == null ? 0 : this.fromSeq.hashCode() * 31) + this.mapping.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SequenceToSequenceMapping)) {
                return false;
            }
            SequenceToSequenceMapping that = (SequenceToSequenceMapping)obj;
            if (this.mapping == null) {
                return that.mapping == null;
            }
            return (this.fromSeq == that.fromSeq || this.fromSeq != null && that.fromSeq != null && this.fromSeq.getDatasetSequence() != null && this.fromSeq.getDatasetSequence() == that.fromSeq.getDatasetSequence()) && this.mapping.equals(that.mapping);
        }

        public SequenceI getFromSeq() {
            return this.fromSeq;
        }

        public Mapping getMapping() {
            return this.mapping;
        }
    }
}

