/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;

public class RemoveGapsCommand
extends EditCommand {
    public RemoveGapsCommand(String description, SequenceI[] seqs, AlignmentI al) {
        this.description = description;
        int width = 0;
        for (int i = 0; i < seqs.length; ++i) {
            if (seqs[i].getLength() <= width) continue;
            width = seqs[i].getLength();
        }
        this.findGaps(seqs, 0, width, al);
    }

    public RemoveGapsCommand(String description, SequenceI[] seqs, int start, int end, AlignmentI al) {
        this.description = description;
        this.findGaps(seqs, start, end, al);
    }

    void findGaps(SequenceI[] seqs, int start, int end, AlignmentI al) {
        int startCol = -1;
        int endCol = -1;
        int deletedCols = 0;
        this.clearEdits();
        boolean delete = true;
        for (int s = 0; s < seqs.length; ++s) {
            deletedCols = 0;
            startCol = -1;
            endCol = -1;
            char[] sequence = seqs[s].getSequence(start, end + 1);
            int jSize = sequence.length;
            for (int j = 0; j < jSize; ++j) {
                delete = true;
                if (!Comparison.isGap(sequence[j])) {
                    if (delete) {
                        endCol = j;
                    }
                    delete = false;
                }
                if (delete && startCol == -1) {
                    startCol = j;
                }
                if (delete || startCol <= -1) continue;
                this.appendEdit(EditCommand.Action.DELETE_GAP, new SequenceI[]{seqs[s]}, start + startCol - deletedCols, endCol - startCol, al, false, null);
                deletedCols += endCol - startCol;
                startCol = -1;
                endCol = -1;
            }
            if (!delete || startCol <= -1) continue;
            this.appendEdit(EditCommand.Action.DELETE_GAP, new SequenceI[]{seqs[s]}, start + startCol - deletedCols, jSize - startCol, al, false, null);
        }
        this.performEdit(0, null);
    }
}

