/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.analysis.scoremodels.SimilarityParams;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.RotatableCanvas;
import jalview.bin.JalviewLite;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SeqCigar;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.viewmodel.PCAModel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class PCAPanel
extends EmbmenuFrame
implements Runnable,
ActionListener,
ItemListener {
    RotatableCanvas rc;
    AlignViewport av;
    PCAModel pcaModel;
    int top = 0;
    Panel jPanel2 = new Panel();
    Label jLabel1 = new Label();
    Label jLabel2 = new Label();
    Label jLabel3 = new Label();
    protected Choice xCombobox = new Choice();
    protected Choice yCombobox = new Choice();
    protected Choice zCombobox = new Choice();
    protected Button resetButton = new Button();
    FlowLayout flowLayout1 = new FlowLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    MenuBar menuBar1 = new MenuBar();
    Menu menu1 = new Menu();
    Menu menu2 = new Menu();
    Menu calcSettings = new Menu();
    protected CheckboxMenuItem labels = new CheckboxMenuItem();
    protected CheckboxMenuItem protSetting = new CheckboxMenuItem();
    protected CheckboxMenuItem nuclSetting = new CheckboxMenuItem();
    MenuItem values = new MenuItem();
    MenuItem inputData = new MenuItem();

    public PCAPanel(AlignViewport viewport) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int i = 1; i < 8; ++i) {
            this.xCombobox.addItem("dim " + i);
            this.yCombobox.addItem("dim " + i);
            this.zCombobox.addItem("dim " + i);
        }
        this.av = viewport;
        boolean selected = viewport.getSelectionGroup() != null && viewport.getSelectionGroup().getSize() > 0;
        AlignmentView seqstrings = viewport.getAlignmentView(selected);
        boolean nucleotide = viewport.getAlignment().isNucleotide();
        SequenceI[] seqs = !selected ? viewport.getAlignment().getSequencesArray() : viewport.getSelectionGroup().getSequencesInOrder(viewport.getAlignment());
        SeqCigar[] sq = seqstrings.getSequences();
        int length = sq[0].getWidth();
        for (int i = 0; i < seqs.length; ++i) {
            if (sq[i].getWidth() == length) continue;
            System.out.println("Sequences must be equal length for PCA analysis");
            return;
        }
        ScoreMatrix scoreModel = ScoreModels.getInstance().getDefaultModel(!nucleotide);
        this.pcaModel = new PCAModel(seqstrings, seqs, nucleotide, scoreModel, SimilarityParams.SeqSpace);
        this.rc = new RotatableCanvas(viewport);
        this.embedMenuIfNeeded(this.rc);
        this.add((Component)this.rc, "Center");
        JalviewLite.addFrame(this, MessageManager.getString("label.principal_component_analysis"), 475, 400);
        Thread worker = new Thread(this);
        worker.start();
    }

    @Override
    public void run() {
        this.calcSettings.setEnabled(false);
        this.rc.setEnabled(false);
        try {
            this.nuclSetting.setState(this.pcaModel.isNucleotide());
            this.protSetting.setState(!this.pcaModel.isNucleotide());
            this.pcaModel.calculate();
            this.xCombobox.select(0);
            this.yCombobox.select(1);
            this.zCombobox.select(2);
            this.pcaModel.updateRc(this.rc);
            this.top = this.pcaModel.getTop();
        }
        catch (OutOfMemoryError x) {
            System.err.println("Out of memory when calculating PCA.");
            return;
        }
        this.calcSettings.setEnabled(true);
        this.rc.setEnabled(true);
        this.rc.repaint();
        this.repaint();
    }

    void doDimensionChange() {
        if (this.top == 0) {
            return;
        }
        int dim1 = this.top - this.xCombobox.getSelectedIndex();
        int dim2 = this.top - this.yCombobox.getSelectedIndex();
        int dim3 = this.top - this.zCombobox.getSelectedIndex();
        this.pcaModel.updateRcView(dim1, dim2, dim3);
        this.rc.resetView();
        this.rc.paint(this.rc.getGraphics());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.inputData) {
            this.showOriginalData();
        }
        if (evt.getSource() == this.resetButton) {
            this.xCombobox.select(0);
            this.yCombobox.select(1);
            this.zCombobox.select(2);
            this.doDimensionChange();
        }
        if (evt.getSource() == this.values) {
            this.values_actionPerformed();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.xCombobox) {
            this.xCombobox_actionPerformed();
        } else if (evt.getSource() == this.yCombobox) {
            this.yCombobox_actionPerformed();
        } else if (evt.getSource() == this.zCombobox) {
            this.zCombobox_actionPerformed();
        } else if (evt.getSource() == this.labels) {
            this.labels_itemStateChanged(evt);
        } else if (evt.getSource() == this.nuclSetting) {
            if (!this.pcaModel.isNucleotide()) {
                this.pcaModel.setNucleotide(true);
                ScoreMatrix scoreModel = ScoreModels.getInstance().getDefaultModel(false);
                this.pcaModel.setScoreModel(scoreModel);
                new Thread(this).start();
            }
        } else if (evt.getSource() == this.protSetting && this.pcaModel.isNucleotide()) {
            this.pcaModel.setNucleotide(false);
            ScoreMatrix scoreModel = ScoreModels.getInstance().getDefaultModel(true);
            this.pcaModel.setScoreModel(scoreModel);
            new Thread(this).start();
        }
    }

    protected void xCombobox_actionPerformed() {
        this.doDimensionChange();
    }

    protected void yCombobox_actionPerformed() {
        this.doDimensionChange();
    }

    protected void zCombobox_actionPerformed() {
        this.doDimensionChange();
    }

    public void values_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(false, null);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, MessageManager.getString("label.pca_details"), 500, 500);
        cap.setText(this.pcaModel.getDetails());
    }

    void showOriginalData() {
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] alAndColsel = this.pcaModel.getInputData().getAlignmentAndHiddenColumns(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            AlignFrame af = new AlignFrame(al, this.av.applet, "Original Data for PCA", false);
            af.viewport.getAlignment().setHiddenColumns((HiddenColumns)alAndColsel[1]);
        }
    }

    public void labels_itemStateChanged(ItemEvent itemEvent) {
        this.rc.showLabels(this.labels.getState());
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.flowLayout1);
        this.jLabel1.setFont(new Font("Verdana", 0, 12));
        this.jLabel1.setText("x=");
        this.jLabel2.setFont(new Font("Verdana", 0, 12));
        this.jLabel2.setText("y=");
        this.jLabel3.setFont(new Font("Verdana", 0, 12));
        this.jLabel3.setText("z=");
        this.jPanel2.setBackground(Color.white);
        this.zCombobox.setFont(new Font("Verdana", 0, 12));
        this.zCombobox.addItemListener(this);
        this.yCombobox.setFont(new Font("Verdana", 0, 12));
        this.yCombobox.addItemListener(this);
        this.xCombobox.setFont(new Font("Verdana", 0, 12));
        this.xCombobox.addItemListener(this);
        this.resetButton.setFont(new Font("Verdana", 0, 12));
        this.resetButton.setLabel(MessageManager.getString("action.reset"));
        this.resetButton.addActionListener(this);
        this.setMenuBar(this.menuBar1);
        this.menu1.setLabel(MessageManager.getString("action.file"));
        this.menu2.setLabel(MessageManager.getString("action.view"));
        this.calcSettings.setLabel(MessageManager.getString("action.change_params"));
        this.labels.setLabel(MessageManager.getString("label.labels"));
        this.labels.addItemListener(this);
        this.values.setLabel(MessageManager.getString("label.output_values"));
        this.values.addActionListener(this);
        this.inputData.setLabel(MessageManager.getString("label.input_data"));
        this.nuclSetting.setLabel(MessageManager.getString("label.nucleotide_matrix"));
        this.nuclSetting.addItemListener(this);
        this.protSetting.setLabel(MessageManager.getString("label.protein_matrix"));
        this.protSetting.addItemListener(this);
        this.add((Component)this.jPanel2, "South");
        this.jPanel2.add((Component)this.jLabel1, null);
        this.jPanel2.add((Component)this.xCombobox, null);
        this.jPanel2.add((Component)this.jLabel2, null);
        this.jPanel2.add((Component)this.yCombobox, null);
        this.jPanel2.add((Component)this.jLabel3, null);
        this.jPanel2.add((Component)this.zCombobox, null);
        this.jPanel2.add((Component)this.resetButton, null);
        this.menuBar1.add(this.menu1);
        this.menuBar1.add(this.menu2);
        this.menuBar1.add(this.calcSettings);
        this.menu2.add(this.labels);
        this.menu1.add(this.values);
        this.menu1.add(this.inputData);
        this.calcSettings.add(this.nuclSetting);
        this.calcSettings.add(this.protSetting);
        this.inputData.addActionListener(this);
    }
}

