/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AppletJmolBinding;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.StructureFile;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.PurinePyrimidineColourScheme;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.UserColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class AppletJmol
extends EmbmenuFrame
implements KeyListener,
ActionListener,
ItemListener {
    Menu fileMenu = new Menu(MessageManager.getString("action.file"));
    Menu viewMenu = new Menu(MessageManager.getString("action.view"));
    Menu coloursMenu = new Menu(MessageManager.getString("action.colour"));
    Menu chainMenu = new Menu(MessageManager.getString("action.show_chain"));
    Menu helpMenu = new Menu(MessageManager.getString("action.help"));
    MenuItem mappingMenuItem = new MenuItem(MessageManager.getString("label.view_mapping"));
    CheckboxMenuItem seqColour = new CheckboxMenuItem(MessageManager.getString("action.by_sequence"), true);
    CheckboxMenuItem jmolColour = new CheckboxMenuItem(MessageManager.getString("action.using_jmol"), false);
    MenuItem chain = new MenuItem(MessageManager.getString("action.by_chain"));
    MenuItem charge = new MenuItem(MessageManager.getString("label.charge_cysteine"));
    MenuItem zappo = new MenuItem(MessageManager.getString("label.colourScheme_zappo"));
    MenuItem taylor = new MenuItem(MessageManager.getString("label.colourScheme_taylor"));
    MenuItem hydro = new MenuItem(MessageManager.getString("label.colourScheme_hydrophobic"));
    MenuItem helix = new MenuItem(MessageManager.getString("label.colourScheme_helix_propensity"));
    MenuItem strand = new MenuItem(MessageManager.getString("label.colourScheme_strand_propensity"));
    MenuItem turn = new MenuItem(MessageManager.getString("label.colourScheme_turn_propensity"));
    MenuItem buried = new MenuItem(MessageManager.getString("label.colourScheme_buried_index"));
    MenuItem purinepyrimidine = new MenuItem(MessageManager.getString("label.colourScheme_purine/pyrimidine"));
    MenuItem user = new MenuItem(MessageManager.getString("label.user_defined_colours"));
    MenuItem jmolHelp = new MenuItem(MessageManager.getString("label.jmol_help"));
    Panel scriptWindow;
    TextField inputLine;
    TextArea history;
    RenderPanel renderPanel;
    AlignmentPanel ap;
    List<AlignmentPanel> _aps = new ArrayList<AlignmentPanel>();
    String fileLoadingError;
    boolean loadedInline;
    FeatureRenderer fr = null;
    AppletJmolBinding jmb;
    String protocol = null;
    boolean allChainsSelected = false;
    Panel splitPane = null;

    public AppletJmol(PDBEntry[] pdbentries, SequenceI[][] boundseqs, String[][] boundchains, boolean align, AlignmentPanel ap, String protocol) {
        throw new Error(MessageManager.getString("error.not_yet_implemented"));
    }

    public AppletJmol(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentPanel ap, DataSourceType protocol) {
        this.ap = ap;
        this.jmb = new AppletJmolBinding(this, ap.getStructureSelectionManager(), new PDBEntry[]{pdbentry}, new SequenceI[][]{seq}, protocol);
        this.jmb.setColourBySequence(true);
        if (pdbentry.getId() == null || pdbentry.getId().length() < 1) {
            if (protocol == DataSourceType.PASTE) {
                pdbentry.setId("PASTED PDB" + (chains == null ? "_" : chains.toString()));
            } else {
                pdbentry.setId(pdbentry.getFile());
            }
        }
        if (JalviewLite.debug) {
            System.err.println("AppletJmol: PDB ID is '" + pdbentry.getId() + "'");
        }
        String alreadyMapped = StructureSelectionManager.getStructureSelectionManager(ap.av.applet).alreadyMappedToFile(pdbentry.getId());
        StructureFile reader = null;
        if (alreadyMapped != null) {
            reader = StructureSelectionManager.getStructureSelectionManager(ap.av.applet).setMapping(seq, chains, pdbentry.getFile(), protocol, null);
        }
        MenuBar menuBar = new MenuBar();
        menuBar.add(this.fileMenu);
        this.fileMenu.add(this.mappingMenuItem);
        menuBar.add(this.viewMenu);
        this.mappingMenuItem.addActionListener(this);
        this.viewMenu.add(this.chainMenu);
        menuBar.add(this.coloursMenu);
        menuBar.add(this.helpMenu);
        this.charge.addActionListener(this);
        this.hydro.addActionListener(this);
        this.chain.addActionListener(this);
        this.seqColour.addItemListener(this);
        this.jmolColour.addItemListener(this);
        this.zappo.addActionListener(this);
        this.taylor.addActionListener(this);
        this.helix.addActionListener(this);
        this.strand.addActionListener(this);
        this.turn.addActionListener(this);
        this.buried.addActionListener(this);
        this.purinepyrimidine.addActionListener(this);
        this.user.addActionListener(this);
        this.jmolHelp.addActionListener(this);
        this.coloursMenu.add(this.seqColour);
        this.coloursMenu.add(this.chain);
        this.coloursMenu.add(this.charge);
        this.coloursMenu.add(this.zappo);
        this.coloursMenu.add(this.taylor);
        this.coloursMenu.add(this.hydro);
        this.coloursMenu.add(this.helix);
        this.coloursMenu.add(this.strand);
        this.coloursMenu.add(this.turn);
        this.coloursMenu.add(this.buried);
        this.coloursMenu.add(this.purinepyrimidine);
        this.coloursMenu.add(this.user);
        this.coloursMenu.add(this.jmolColour);
        this.helpMenu.add(this.jmolHelp);
        this.setLayout(new BorderLayout());
        this.setMenuBar(menuBar);
        this.renderPanel = new RenderPanel();
        this.embedMenuIfNeeded(this.renderPanel);
        this.add((Component)this.renderPanel, "Center");
        this.scriptWindow = new Panel();
        this.scriptWindow.setVisible(false);
        try {
            this.jmb.allocateViewer(this.renderPanel, true, ap.av.applet.getName() + "_jmol_", ap.av.applet.getDocumentBase(), ap.av.applet.getCodeBase(), "-applet", this.scriptWindow, null);
        }
        catch (Exception e) {
            System.err.println("Couldn't create a jmol viewer. Args to allocate viewer were:\nDocumentBase=" + ap.av.applet.getDocumentBase() + "\nCodebase=" + ap.av.applet.getCodeBase());
            e.printStackTrace();
            this.dispose();
            return;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AppletJmol.this.closeViewer();
            }
        });
        pdbentry.setProperty("protocol", (Object)protocol);
        if (pdbentry.getFile() != null) {
            if (protocol == DataSourceType.PASTE) {
                this.loadInline(pdbentry.getFile());
            } else if (protocol == DataSourceType.FILE || protocol == DataSourceType.URL) {
                this.jmb.viewer.openFile(pdbentry.getFile());
            } else {
                try {
                    Reader freader = null;
                    if (reader != null) {
                        if (JalviewLite.debug) {
                            System.err.println("AppletJmol:Trying to reuse existing PDBfile IO parser.");
                        }
                        freader = reader.getReader();
                    }
                    if (freader == null) {
                        if (JalviewLite.debug) {
                            System.err.println("AppletJmol:Creating new PDBfile IO parser.");
                        }
                        FileParse fp = new FileParse(pdbentry.getFile(), protocol);
                        fp.mark();
                        freader = fp.getReader();
                    }
                    if (freader == null) {
                        throw new Exception(MessageManager.getString("exception.invalid_datasource_couldnt_obtain_reader"));
                    }
                    this.jmb.viewer.openReader(pdbentry.getFile(), pdbentry.getId(), (Object)freader);
                }
                catch (Exception e) {
                    System.err.println("Couldn't access pdbentry id=" + pdbentry.getId() + " and file=" + pdbentry.getFile() + " using protocol=" + (Object)((Object)protocol));
                    e.printStackTrace();
                }
            }
        }
        JalviewLite.addFrame(this, this.jmb.getViewerTitle(), 400, 400);
    }

    public void loadInline(String string) {
        this.loadedInline = true;
        this.jmb.loadInline(string);
    }

    void setChainMenuItems(List<String> chains) {
        this.chainMenu.removeAll();
        MenuItem menuItem = new MenuItem(MessageManager.getString("label.all"));
        menuItem.addActionListener(this);
        this.chainMenu.add(menuItem);
        for (String ch : chains) {
            CheckboxMenuItem menuItemCB = new CheckboxMenuItem(ch, true);
            menuItemCB.addItemListener(this);
            this.chainMenu.add(menuItemCB);
        }
    }

    void centerViewer() {
        Vector<String> toshow = new Vector<String>();
        for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
            CheckboxMenuItem item;
            if (!(this.chainMenu.getItem(i) instanceof CheckboxMenuItem) || !(item = (CheckboxMenuItem)this.chainMenu.getItem(i)).getState()) continue;
            toshow.addElement(item.getLabel());
        }
        this.jmb.centerViewer(toshow);
    }

    void closeViewer() {
        this.jmb.closeViewer();
        this.jmb = null;
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.mappingMenuItem) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, null);
            Frame frame = new Frame();
            frame.add(cap);
            StringBuffer sb = new StringBuffer();
            try {
                cap.setText(this.jmb.printMappings());
            }
            catch (OutOfMemoryError ex) {
                frame.dispose();
                System.err.println("Out of memory when trying to create dialog box with sequence-structure mapping.");
                return;
            }
            JalviewLite.addFrame(frame, MessageManager.getString("label.pdb_sequence_mapping"), 550, 600);
        } else if (evt.getSource() == this.charge) {
            this.setEnabled(this.charge);
            this.jmb.colourByCharge();
        } else if (evt.getSource() == this.chain) {
            this.setEnabled(this.chain);
            this.jmb.colourByChain();
        } else if (evt.getSource() == this.zappo) {
            this.setEnabled(this.zappo);
            this.jmb.setJalviewColourScheme(new ZappoColourScheme());
        } else if (evt.getSource() == this.taylor) {
            this.setEnabled(this.taylor);
            this.jmb.setJalviewColourScheme(new TaylorColourScheme());
        } else if (evt.getSource() == this.hydro) {
            this.setEnabled(this.hydro);
            this.jmb.setJalviewColourScheme(new HydrophobicColourScheme());
        } else if (evt.getSource() == this.helix) {
            this.setEnabled(this.helix);
            this.jmb.setJalviewColourScheme(new HelixColourScheme());
        } else if (evt.getSource() == this.strand) {
            this.setEnabled(this.strand);
            this.jmb.setJalviewColourScheme(new StrandColourScheme());
        } else if (evt.getSource() == this.turn) {
            this.setEnabled(this.turn);
            this.jmb.setJalviewColourScheme(new TurnColourScheme());
        } else if (evt.getSource() == this.buried) {
            this.setEnabled(this.buried);
            this.jmb.setJalviewColourScheme(new BuriedColourScheme());
        } else if (evt.getSource() == this.purinepyrimidine) {
            this.jmb.setJalviewColourScheme(new PurinePyrimidineColourScheme());
        } else if (evt.getSource() == this.user) {
            this.setEnabled(this.user);
            new UserDefinedColours(this);
        } else if (evt.getSource() == this.jmolHelp) {
            try {
                this.ap.av.applet.getAppletContext().showDocument(new URL("http://jmol.sourceforge.net/docs/JmolUserGuide/"), "jmolHelp");
            }
            catch (MalformedURLException cap) {}
        } else {
            this.allChainsSelected = true;
            for (int i = 0; i < this.chainMenu.getItemCount(); ++i) {
                if (!(this.chainMenu.getItem(i) instanceof CheckboxMenuItem)) continue;
                ((CheckboxMenuItem)this.chainMenu.getItem(i)).setState(true);
            }
            this.centerViewer();
            this.allChainsSelected = false;
        }
    }

    private void setEnabled(MenuItem itm) {
        this.jmolColour.setState(itm == this.jmolColour);
        this.seqColour.setState(itm == this.seqColour);
        this.jmb.setColourBySequence(itm == this.seqColour);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.jmolColour) {
            this.setEnabled(this.jmolColour);
            this.jmb.setColourBySequence(false);
        } else if (evt.getSource() == this.seqColour) {
            this.setEnabled(this.seqColour);
            this.jmb.colourBySequence(this.ap);
        } else if (!this.allChainsSelected) {
            this.centerViewer();
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 && this.scriptWindow.isVisible()) {
            this.jmb.eval(this.inputLine.getText());
            this.addToHistory("$ " + this.inputLine.getText());
            this.inputLine.setText("");
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    public void updateColours(Object source) {
        AlignmentPanel panel = (AlignmentPanel)source;
        this.jmb.colourBySequence(panel);
    }

    public void updateTitleAndMenus() {
        if (this.jmb.hasFileLoadingError()) {
            this.repaint();
            return;
        }
        this.setChainMenuItems(this.jmb.getChainNames());
        this.jmb.colourBySequence(this.ap);
        this.setTitle(this.jmb.getViewerTitle());
    }

    public void showUrl(String url) {
        try {
            this.ap.av.applet.getAppletContext().showDocument(new URL(url), "jmolOutput");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void showConsole(boolean showConsole) {
        if (showConsole) {
            this.remove(this.renderPanel);
            this.splitPane = new Panel();
            this.splitPane.setLayout(new GridLayout(2, 1));
            this.splitPane.add(this.renderPanel);
            this.splitPane.add(this.scriptWindow);
            this.scriptWindow.setVisible(true);
            this.add((Component)this.splitPane, "Center");
            this.splitPane.setVisible(true);
            this.splitPane.validate();
        } else {
            this.scriptWindow.setVisible(false);
            this.remove(this.splitPane);
            this.add((Component)this.renderPanel, "Center");
            this.splitPane = null;
        }
        this.validate();
    }

    public float[][] functionXY(String functionName, int x, int y) {
        return null;
    }

    public void setJalviewColourScheme(UserColourScheme ucs) {
        this.jmb.setJalviewColourScheme(ucs);
    }

    public AlignmentPanel getAlignmentPanelFor(AlignmentI alignment) {
        for (int i = 0; i < this._aps.size(); ++i) {
            if (this._aps.get((int)i).av.getAlignment() != alignment) continue;
            return this._aps.get(i);
        }
        return this.ap;
    }

    public void addToHistory(String text) {
        if (this.history != null) {
            this.history.append("\n" + text);
        }
    }

    class RenderPanel
    extends Panel {
        Dimension currentSize = new Dimension();

        RenderPanel() {
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            this.currentSize = this.getSize();
            if (AppletJmol.this.jmb.viewer == null) {
                g.setColor(Color.black);
                g.fillRect(0, 0, this.currentSize.width, this.currentSize.height);
                g.setColor(Color.white);
                g.setFont(new Font("Verdana", 1, 14));
                g.drawString(MessageManager.getString("label.retrieving_pdb_data"), 20, this.currentSize.height / 2);
            } else {
                AppletJmol.this.jmb.viewer.renderScreenImage((Object)g, this.currentSize.width, this.currentSize.height);
            }
        }
    }
}

