/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.util.MessageManager;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;

public abstract class AnnotationRowFilter
extends Panel {
    protected AlignViewport av;
    protected AlignmentPanel ap;
    protected int[] annmap;
    protected boolean enableSeqAss = false;
    private AlignmentAnnotation currentAnnotation;
    protected boolean adjusting = false;
    protected Checkbox currentColours = new Checkbox();
    protected Panel minColour = new Panel();
    protected Panel maxColour = new Panel();
    protected Checkbox seqAssociated = new Checkbox();
    protected Checkbox thresholdIsMin = new Checkbox();
    protected Scrollbar slider = new Scrollbar(0);
    protected Checkbox percentThreshold = new Checkbox();
    protected TextField thresholdValue = new TextField(20);
    protected Frame frame;
    protected Button ok = new Button();
    protected Button cancel = new Button();
    protected boolean sliderDragging = false;

    public AnnotationRowFilter(AlignViewport av, AlignmentPanel ap) {
        this.av = av;
        this.ap = ap;
    }

    public AnnotationRowFilter() {
    }

    protected int getSelectedThresholdItem(int indexValue) {
        int selectedThresholdItem = -1;
        if (indexValue == 1) {
            selectedThresholdItem = 1;
        } else if (indexValue == 2) {
            selectedThresholdItem = 0;
        }
        return selectedThresholdItem;
    }

    public void modelChanged() {
        this.seqAssociated.setEnabled(this.enableSeqAss);
    }

    public void ok_actionPerformed(ActionEvent e) {
        this.updateView();
        this.frame.setVisible(false);
    }

    public void cancel_actionPerformed(ActionEvent e) {
        this.reset();
        this.ap.paintAlignment(true, true);
        this.frame.setVisible(false);
    }

    public void thresholdCheck_actionPerformed(ActionEvent e) {
        this.updateView();
    }

    public void annotations_actionPerformed(ActionEvent e) {
        this.updateView();
    }

    public void threshold_actionPerformed(ActionEvent e) {
        this.updateView();
    }

    protected void setThresholdValueText() {
        boolean oldadj = this.adjusting;
        this.adjusting = true;
        if (this.percentThreshold.getState()) {
            double scl = this.slider.getMaximum() - this.slider.getMinimum();
            scl = (double)(this.slider.getValue() - this.slider.getMinimum()) / scl;
            this.thresholdValue.setText(100.0 * scl + "");
        } else {
            this.thresholdValue.setText((float)this.slider.getValue() / 1000.0f + "");
        }
        this.thresholdValue.setCaretPosition(0);
        this.adjusting = oldadj;
    }

    public void thresholdValue_actionPerformed(ActionEvent e) {
        try {
            float f = Float.parseFloat(this.thresholdValue.getText());
            if (this.percentThreshold.getState()) {
                int pos = this.slider.getMinimum() + (int)((float)(this.slider.getMaximum() - this.slider.getMinimum()) * f / 100.0f);
                this.slider.setValue(pos);
            } else {
                this.slider.setValue((int)(f * 1000.0f));
            }
            this.valueChanged(false);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void percentageValue_actionPerformed() {
        this.setThresholdValueText();
    }

    protected void populateThresholdComboBox(Choice threshold) {
        threshold.addItem(MessageManager.getString("label.threshold_feature_no_threshold"));
        threshold.addItem(MessageManager.getString("label.threshold_feature_above_threshold"));
        threshold.addItem(MessageManager.getString("label.threshold_feature_below_threshold"));
    }

    public AlignmentAnnotation getCurrentAnnotation() {
        return this.currentAnnotation;
    }

    public void setCurrentAnnotation(AlignmentAnnotation currentAnnotation) {
        this.currentAnnotation = currentAnnotation;
    }

    public abstract void valueChanged(boolean var1);

    public abstract void updateView();

    public abstract void reset();
}

