/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis.scoremodels;

import jalview.analysis.scoremodels.FeatureDistanceModel;
import jalview.analysis.scoremodels.PIDModel;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.api.AlignmentViewPanel;
import jalview.api.analysis.ScoreModelI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.ScoreMatrixFile;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ScoreModels {
    private final ScoreMatrix BLOSUM62;
    private final ScoreMatrix PAM250;
    private final ScoreMatrix DNA;
    private static ScoreModels instance;
    private Map<String, ScoreModelI> models = new LinkedHashMap<String, ScoreModelI>();

    public static ScoreModels getInstance() {
        if (instance == null) {
            instance = new ScoreModels();
        }
        return instance;
    }

    private ScoreModels() {
        this.BLOSUM62 = this.loadScoreMatrix("scoreModel/blosum62.scm");
        this.PAM250 = this.loadScoreMatrix("scoreModel/pam250.scm");
        this.DNA = this.loadScoreMatrix("scoreModel/dna.scm");
        this.registerScoreModel(new PIDModel());
        this.registerScoreModel(new FeatureDistanceModel());
    }

    ScoreMatrix loadScoreMatrix(String resourcePath) {
        try {
            FileParse fp = new FileParse(resourcePath, DataSourceType.CLASSLOADER);
            ScoreMatrix sm = new ScoreMatrixFile(fp).parseMatrix();
            this.registerScoreModel(sm);
            return sm;
        }
        catch (IOException e) {
            System.err.println("Error reading " + resourcePath + ": " + e.getMessage());
            return null;
        }
    }

    public Iterable<ScoreModelI> getModels() {
        return this.models.values();
    }

    public ScoreModelI getScoreModel(String name, AlignmentViewPanel avp) {
        ScoreModelI model = this.models.get(name);
        return model == null ? null : model.getInstance(avp);
    }

    public void registerScoreModel(ScoreModelI sm) {
        ScoreModelI sm2 = this.models.get(sm.getName());
        if (sm2 != null) {
            System.err.println("Warning: replacing score model " + sm2.getName());
        }
        this.models.put(sm.getName(), sm);
    }

    public void reset() {
        instance = new ScoreModels();
    }

    public ScoreMatrix getDefaultModel(boolean forPeptide) {
        return forPeptide ? this.BLOSUM62 : this.DNA;
    }

    public ScoreMatrix getBlosum62() {
        return this.BLOSUM62;
    }

    public ScoreMatrix getPam250() {
        return this.PAM250;
    }
}

