/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import com.stevesoft.pat.Regex;
import jalview.analysis.AlignSeq;
import jalview.api.AlignViewportI;
import jalview.api.FinderI;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Range;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.VisibleContigsIterator;
import jalview.util.Comparison;
import java.util.List;
import java.util.Vector;

public class Finder
implements FinderI {
    private SearchResultsI searchResults;
    private Vector<SequenceI> idMatches;
    private AlignViewportI viewport;
    private int sequenceIndex;
    private int columnIndex;

    public Finder(AlignViewportI av) {
        this.viewport = av;
        this.sequenceIndex = 0;
        this.columnIndex = -1;
    }

    @Override
    public void findAll(String theSearchString, boolean matchCase, boolean searchDescription) {
        this.sequenceIndex = 0;
        this.columnIndex = -1;
        this.doFind(theSearchString, matchCase, searchDescription, true);
        this.sequenceIndex = 0;
        this.columnIndex = -1;
    }

    @Override
    public void findNext(String theSearchString, boolean matchCase, boolean searchDescription) {
        this.doFind(theSearchString, matchCase, searchDescription, false);
        if (this.searchResults.isEmpty() && this.idMatches.isEmpty()) {
            this.sequenceIndex = 0;
            this.columnIndex = -1;
        }
    }

    protected void doFind(String theSearchString, boolean matchCase, boolean searchDescription, boolean findAll) {
        String searchString = matchCase ? theSearchString : theSearchString.toUpperCase();
        Regex searchPattern = new Regex(searchString);
        searchPattern.setIgnoreCase(!matchCase);
        this.searchResults = new SearchResults();
        this.idMatches = new Vector();
        SequenceGroup selection = this.viewport.getSelectionGroup();
        if (selection != null && selection.getSize() < 1) {
            selection = null;
        }
        AlignmentI alignment = this.viewport.getAlignment();
        int end = alignment.getHeight();
        while (this.sequenceIndex < end) {
            SequenceI seq = alignment.getSequenceAt(this.sequenceIndex);
            boolean found = this.findNextMatch(seq, searchString, searchPattern, searchDescription);
            if (found && !findAll) {
                return;
            }
            if (found) continue;
            ++this.sequenceIndex;
            this.columnIndex = -1;
        }
    }

    protected Range getNextVisibleSequenceRegion(SequenceI sequence, int column) {
        int[] visible;
        int seqColStart = column;
        int seqColEnd = sequence.getLength() - 1;
        AlignmentI alignment = this.viewport.getAlignment();
        VisibleContigsIterator visibleRegions = alignment.getHiddenColumns().getVisContigsIterator(column, alignment.getWidth(), false);
        int[] nArray = visible = visibleRegions.hasNext() ? visibleRegions.next() : null;
        if (visible == null) {
            this.columnIndex = seqColEnd + 1;
            return null;
        }
        seqColStart = Math.max(seqColStart, visible[0]);
        seqColEnd = Math.min(seqColEnd, visible[1]);
        SequenceGroup selection = this.viewport.getSelectionGroup();
        if (selection != null) {
            int selectionStart = selection.getStartRes();
            int selectionEnd = selection.getEndRes();
            if (selectionStart > seqColEnd || selectionEnd < seqColStart) {
                this.columnIndex = seqColEnd + 1;
                return null;
            }
            seqColStart = Math.max(seqColStart, selectionStart);
            seqColEnd = Math.min(seqColEnd, selectionEnd);
        }
        return new Range(seqColStart, seqColEnd);
    }

    protected boolean findNextMatch(SequenceI seq, String searchString, Regex searchPattern, boolean matchDescription) {
        SequenceGroup selection = this.viewport.getSelectionGroup();
        if (selection != null && !selection.contains(seq)) {
            return false;
        }
        if (this.columnIndex < 0 && this.doNonMotifSearches(seq, searchString, searchPattern, matchDescription)) {
            return true;
        }
        int end = seq.getLength();
        while (this.columnIndex < end) {
            if (!this.searchNextVisibleRegion(seq, searchPattern)) continue;
            return true;
        }
        return false;
    }

    protected boolean searchNextVisibleRegion(SequenceI seq, Regex searchPattern) {
        Range visible = this.getNextVisibleSequenceRegion(seq, this.columnIndex);
        if (visible == null) {
            return false;
        }
        String seqString = seq.getSequenceAsString(visible.start, visible.end + 1);
        String noGaps = AlignSeq.extractGaps(Comparison.GapChars, seqString);
        if (searchPattern.search(noGaps)) {
            int sequenceStartPosition = seq.findPosition(visible.start);
            this.recordMatch(seq, searchPattern, sequenceStartPosition);
            return true;
        }
        this.columnIndex = visible.end + 1;
        return false;
    }

    protected boolean recordMatch(SequenceI seq, Regex searchPattern, int firstResiduePosition) {
        SearchResultMatchI lastMatch;
        int offset = searchPattern.matchedFrom();
        int matchStartPosition = firstResiduePosition + offset;
        int matchEndPosition = matchStartPosition + searchPattern.charsMatched() - 1;
        this.columnIndex = seq.findIndex(matchStartPosition);
        List<SearchResultMatchI> matches = this.searchResults.getResults();
        SearchResultMatchI searchResultMatchI = lastMatch = matches.isEmpty() ? null : matches.get(matches.size() - 1);
        if (lastMatch == null || !lastMatch.contains(seq, matchStartPosition, matchEndPosition)) {
            this.searchResults.addResult(seq, matchStartPosition, matchEndPosition);
            return true;
        }
        return false;
    }

    protected boolean doNonMotifSearches(SequenceI seq, String searchString, Regex searchPattern, boolean includeDescription) {
        this.columnIndex = 0;
        if (this.searchForResidueNumber(seq, searchString)) {
            return true;
        }
        if (this.searchSequenceName(seq, searchPattern)) {
            return true;
        }
        return includeDescription && this.searchSequenceDescription(seq, searchPattern);
    }

    protected boolean searchSequenceDescription(SequenceI seq, Regex searchPattern) {
        String desc = seq.getDescription();
        if (desc != null && searchPattern.search(desc) && !this.idMatches.contains(seq)) {
            this.idMatches.addElement(seq);
            return true;
        }
        return false;
    }

    protected boolean searchSequenceName(SequenceI seq, Regex searchPattern) {
        if (searchPattern.search(seq.getName()) && !this.idMatches.contains(seq)) {
            this.idMatches.addElement(seq);
            return true;
        }
        return false;
    }

    protected boolean searchForResidueNumber(SequenceI seq, String searchString) {
        try {
            int res = Integer.parseInt(searchString);
            if (seq.getStart() <= res && seq.getEnd() >= res) {
                this.searchResults.addResult(seq, res, res);
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public Vector<SequenceI> getIdMatches() {
        return this.idMatches;
    }

    @Override
    public SearchResultsI getSearchResults() {
        return this.searchResults;
    }
}

