/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import java.util.StringTokenizer;

public class StringUtil {
    protected static final String XLATE = "0123456789abcdef";

    public static boolean couldBeValidUrl(String url) {
        return url.matches("[A-Za-z0-9\\-\\._~:/\\?#\\[\\]@!$&'\\(\\)\\*\\+,;=%]+");
    }

    public static boolean isBlank(String value) {
        int ll;
        int n = ll = value == null ? 0 : value.length();
        for (int ii = 0; ii < ll; ++ii) {
            if (Character.isWhitespace(value.charAt(ii))) continue;
            return false;
        }
        return true;
    }

    public static int[] parseIntArray(String source) {
        StringTokenizer tok = new StringTokenizer(source, ",");
        int[] vals = new int[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            try {
                vals[i] = Integer.parseInt(tok.nextToken().trim());
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            ++i;
        }
        return vals;
    }

    public static String[] parseStringArray(String source) {
        return StringUtil.parseStringArray(source, false);
    }

    public static String[] parseStringArray(String source, boolean intern) {
        int tcount = 0;
        int tpos = -1;
        int tstart = 0;
        if (source.length() == 0) {
            return new String[0];
        }
        source = source.replace(",,", "%COMMA%");
        while ((tpos = source.indexOf(",", tpos + 1)) != -1) {
            ++tcount;
        }
        String[] tokens = new String[tcount + 1];
        tpos = -1;
        tcount = 0;
        while ((tpos = source.indexOf(",", tpos + 1)) != -1) {
            tokens[tcount] = source.substring(tstart, tpos);
            tokens[tcount] = tokens[tcount].trim().replace("%COMMA%", ",");
            if (intern) {
                tokens[tcount] = tokens[tcount].intern();
            }
            tstart = tpos + 1;
            ++tcount;
        }
        tokens[tcount] = source.substring(tstart);
        tokens[tcount] = tokens[tcount].trim().replace("%COMMA%", ",");
        return tokens;
    }

    public static String deNull(String value) {
        return value == null ? "" : value;
    }

    public static String hexlate(byte[] bytes, int count) {
        if (bytes == null) {
            return "";
        }
        count = Math.min(count, bytes.length);
        char[] chars = new char[count * 2];
        for (int i = 0; i < count; ++i) {
            int val = bytes[i];
            if (val < 0) {
                val += 256;
            }
            chars[2 * i] = XLATE.charAt(val / 16);
            chars[2 * i + 1] = XLATE.charAt(val % 16);
        }
        return new String(chars);
    }

    public static String hexlate(byte[] bytes) {
        return bytes == null ? "" : StringUtil.hexlate(bytes, bytes.length);
    }

    public static String join(Object[] values) {
        return StringUtil.join(values, false);
    }

    public static String join(Object[] values, boolean escape) {
        return StringUtil.join(values, ", ", escape);
    }

    public static String join(Object[] values, String separator) {
        return StringUtil.join(values, separator, false);
    }

    protected static String join(Object[] values, String separator, boolean escape) {
        StringBuilder buf = new StringBuilder();
        int vlength = values.length;
        for (int i = 0; i < vlength; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            String value = values[i] == null ? "" : values[i].toString();
            buf.append(escape ? value.replace(",", ",,") : value);
        }
        return buf.toString();
    }
}

