/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.test;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.Vector;
import uk.ac.vamsas.client.AppDataInputStream;
import uk.ac.vamsas.client.AppDataOutputStream;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.IClient;
import uk.ac.vamsas.client.IClientAppdata;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.IClientFactory;
import uk.ac.vamsas.client.InvalidSessionDocumentException;
import uk.ac.vamsas.client.NoDefaultSessionException;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.picking.CustomMessage;
import uk.ac.vamsas.client.picking.IMessageHandler;
import uk.ac.vamsas.client.picking.IPickManager;
import uk.ac.vamsas.client.picking.Message;
import uk.ac.vamsas.client.simpleclient.SimpleClientFactory;
import uk.ac.vamsas.objects.core.AlignmentSequence;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.test.objects.Core;
import uk.ac.vamsas.test.simpleclient.ArchiveReports;

public class ExampleApplication {
    private ClientHandle app;
    private UserHandle user;
    private IClientFactory clientfactory;
    private IClient vorbaclient;
    private byte[] mydata;
    private Vector vamsasObjects;
    private boolean isUpdated = false;
    private boolean isShuttingdown = false;
    private boolean isFinalizing = false;
    private int totalUpdates = 9;
    private VorbaId recover = null;
    private int calls = 0;
    private long mdatahash = 0L;
    private long muserdatahash = 0L;
    private int appdatareads = 0;
    boolean clientappd = true;
    boolean userappd = false;
    public String Usage = "ExampleApplication :/n [-arena <vamsasFileDirectory>][-session <vamsasSessionURN>] <action> [+<arguments>]\n<action> is one of :\n\tsave,new,watch\n-arena and -session are not yet supported";
    String sess = null;
    String importFile = null;
    String outputFile = null;
    boolean newSession = false;
    boolean imported = false;
    long shutdown = -1L;

    private void processVamsasDocument(IClientDocument doc) {
        if (doc.getVamsasRoots().length < 4) {
            doc.addVamsasRoot(Core.getDemoVamsas());
        } else {
            try {
                DataSet ds = doc.getVamsasRoots()[1].getDataSet(0);
                AlignmentSequence alsq = ds.getAlignment(0).getAlignmentSequence(0);
                if (this.recover == null) {
                    this.recover = alsq.getVorbaId();
                } else {
                    Vobject recoverd = doc.getObject(this.recover);
                    System.out.println("Recovery of " + this.recover + " was " + (recoverd == null ? "A FAILURE" : "SUCCESSFUL"));
                }
                System.out.println("Modifying Sequence:\n" + alsq.hashCode());
                alsq.setSequence(alsq.getSequence() + ds.getAlignment(0).getGapChar());
                System.out.println("Modifying Sequence:\n" + alsq.hashCode());
                System.out.println("Modified Sequence:\n" + alsq.getSequence());
                doc.setVamsasRoots(doc.getVamsasRoots());
            }
            catch (Exception ee) {
                // empty catch block
            }
        }
        System.out.println("Trying to get appdata and modify it.....");
        try {
            this.processAppData(doc);
            System.out.println(".....Finished.");
        }
        catch (Exception e) {
            System.err.println("Failed to process appdata for our application.");
            e.printStackTrace(System.err);
        }
        this.vorbaclient.updateDocument(doc);
    }

    private void processAppData(IClientDocument doc) throws Exception {
        ++this.appdatareads;
        boolean writtenonce = false;
        if (doc != null) {
            IClientAppdata appd = doc.getClientAppdata();
            if (this.clientappd) {
                if (appd.hasClientAppdata() && this.appdatareads % 2 != 0) {
                    System.out.println("Testing read from inputstream");
                    String cappds = this.readData(appd.getClientInputStream());
                    System.out.println("Client appdata\n" + cappds + "\nEnd of Appdata\n");
                } else if (!writtenonce) {
                    String newapd = "Client Appdata:";
                    if (appd.hasClientAppdata()) {
                        AppDataInputStream is = appd.getClientInputStream();
                        newapd = this.readData(is);
                        is.close();
                    }
                    writtenonce = true;
                    this.writeData(appd.getClientOutputStream(), newapd + " : Client Appdata for all users written on " + this.appdatareads + " read by " + this.vorbaclient.getUserHandle());
                    System.out.println("Written to ClientAppdata stream.");
                }
            }
            if (this.userappd) {
                if (appd.hasUserAppdata() && this.appdatareads % 2 != 0) {
                    byte[] cappd = appd.getUserAppdata();
                    if (cappd != null) {
                        System.out.println("User appdata\n" + new String(cappd) + "\nEnd of Users' Appdata\n");
                    } else {
                        System.out.println("No user appdata.");
                        appd.setUserAppdata(("no default - overwritten null byte set on " + this.appdatareads + " read by " + this.vorbaclient.getUserHandle() + "").getBytes());
                    }
                } else if (!writtenonce) {
                    writtenonce = true;
                    byte[] bts = this.makeappData("User Appdata for " + this.user + " written on " + this.appdatareads + " read at ");
                    System.out.println("Setting appData bytes to\n" + new String(bts) + "\nEnd.");
                    appd.setUserAppdata(bts);
                    System.out.println("Written to UserAppdata stream.");
                }
            }
        }
    }

    private byte[] makeappData(String message) {
        StringBuffer sb = new StringBuffer();
        sb.append(message);
        sb.append("on " + new Date());
        return sb.toString().getBytes();
    }

    private boolean writeData(AppDataOutputStream os, String message) {
        StringBuffer sb = new StringBuffer();
        sb.append(message);
        sb.append("on " + new Date());
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(sb.toString());
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            System.err.println("Problem serialising this message:\n" + sb);
            e.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    private String readData(AppDataInputStream is) {
        if (is != null) {
            try {
                if (is.available() > 0) {
                    ObjectInputStream ois = new ObjectInputStream(is);
                    String rs = (String)ois.readObject();
                    return rs;
                }
            }
            catch (Exception e) {
                System.err.println("Failed to read a string from input stream!");
                e.printStackTrace(System.err);
            }
        }
        return "";
    }

    private void addHandlers(IClient avorbaclient) {
        final ExampleApplication me = this;
        final IClient vorbaclient = avorbaclient;
        vorbaclient.addDocumentUpdateHandler(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("Vamsas document update for " + evt.getPropertyName() + ": " + evt.getOldValue() + " to " + evt.getNewValue());
                try {
                    IClientDocument cdoc = vorbaclient.getClientDocument();
                    if (ExampleApplication.this.calls > 2 && cdoc.getVamsasRoots().length > 0 && !cdoc.getVamsasRoots()[0].is__stored_in_document()) {
                        System.err.println("Pathological Update Detected - Document is zeroed!");
                    }
                    ExampleApplication.this.calls++;
                    ArchiveReports.rootReport(cdoc.getVamsasRoots(), true, System.out);
                    try {
                        if (cdoc.getVamsasRoots().length > 2) {
                            DataSet ds = cdoc.getVamsasRoots()[1].getDataSet(0);
                            AlignmentSequence alsq = ds.getAlignment(0).getAlignmentSequence(0);
                            if (alsq.isUpdated()) {
                                System.out.println("Seqeuence was updated since last time.");
                            }
                            alsq.setSequence(alsq.getSequence() + ds.getAlignment(0).getGapChar());
                            System.out.println("Newly Modified Sequence:\n" + alsq.getSequence());
                            cdoc.setVamsasRoots(cdoc.getVamsasRoots());
                        }
                    }
                    catch (Exception ee) {
                        System.err.println("Exception whilst updating :");
                        ee.printStackTrace(System.err);
                    }
                    vorbaclient.updateDocument(cdoc);
                }
                catch (Exception e) {
                    System.err.println("Exception whilst dumping document tree after an update.");
                    e.printStackTrace(System.err);
                }
                ExampleApplication.this.isUpdated = true;
            }
        });
        vorbaclient.addVorbaEventHandler("uk.ac.vamas.client.DocumentRequestToCloseEvent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("Received request to close vamsas document.");
                vorbaclient.storeDocument(new File("UserLocation"));
            }
        });
        vorbaclient.addVorbaEventHandler("uk.ac.vamsas.client.events.clientCreateEvent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("New Vamsas client for " + evt.getPropertyName() + ": " + evt.getOldValue() + " to " + evt.getNewValue());
            }
        });
        vorbaclient.addVorbaEventHandler("uk.ac.vamsas.client.events.clientFinalizationEvent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("Vamsas client finalizing for " + evt.getPropertyName() + ": " + evt.getOldValue() + " to " + evt.getNewValue());
            }
        });
        vorbaclient.addVorbaEventHandler("uk.ac.vamsas.client.events.SessionShutdownEvent", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("Session " + evt.getPropertyName() + " is shutting down.");
            }
        });
        vorbaclient.addVorbaEventHandler("uk.ac.vamsas.client.events.DocumentFinalizeAppData", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean finalized = false;
                System.out.println("Application received a DOCUMENT_FINALIZEAPPDATA event.");
                IClientDocument cdoc = null;
                try {
                    cdoc = vorbaclient.getClientDocument();
                    if (cdoc != null) {
                        IClientAppdata apd = cdoc.getClientAppdata();
                        if (apd != null) {
                            String userd = "";
                            if (apd.getUserAppdata() != null) {
                                userd = new String(apd.getUserAppdata());
                            }
                            String appdat = me.readData(apd.getClientInputStream());
                            me.writeData(apd.getClientOutputStream(), appdat + "\nUser Data merged\n" + userd + "\n");
                        }
                        finalized = true;
                        vorbaclient.updateDocument(cdoc);
                    }
                }
                catch (Exception e) {
                    if (!finalized) {
                        System.err.println("Probable library problem - exception when trying to update document after writing merged appdata.");
                        e.printStackTrace(System.err);
                    } else {
                        System.err.println("Recovering from exception when writing merged appdata");
                        e.printStackTrace(System.err);
                        try {
                            if (cdoc != null) {
                                vorbaclient.updateDocument(cdoc);
                            }
                        }
                        catch (Exception e2) {
                            System.err.println("Probable library problem - exception when trying to update document after an exception when writing merged appdata.");
                            e2.printStackTrace(System.err);
                        }
                    }
                    return;
                }
                System.out.println("Application finalized appdata successfuly.");
            }
        });
    }

    private boolean parseArgs(String[] args) {
        if (args.length == 0) {
            return false;
        }
        int cpos = 0;
        boolean parsed = false;
        while (!parsed && cpos < args.length) {
            if (args[cpos].toLowerCase().equals("new") && cpos + 1 < args.length) {
                this.importFile = args[cpos + 1];
                this.newSession = true;
                cpos += 2;
                continue;
            }
            if (args[cpos].toLowerCase().equals("save") && cpos + 1 < args.length) {
                this.outputFile = args[cpos + 1];
                cpos += 2;
                continue;
            }
            if (!args[cpos].toLowerCase().equals("watch")) {
                this.sess = args[cpos];
            }
            ++cpos;
        }
        return true;
    }

    public void runMe(String[] args) {
        File vfile;
        if (!this.parseArgs(args)) {
            System.err.print(this.Usage);
        }
        try {
            this.clientfactory = new SimpleClientFactory();
        }
        catch (IOException e) {
            System.err.println(e + "\n" + this.Usage);
            System.exit(1);
        }
        this.app = new ClientHandle("uk.ac.vamsas.test.ExampleApplication", "0.1");
        this.user = new UserHandle("arnolduser", "deathsdoor");
        if (this.sess != null && this.importFile != null) {
            System.err.println("Import of an existing document into an existing session is not fully supported yet.");
            System.exit(3);
        }
        try {
            if (this.sess != null) {
                System.out.println("Connecting to " + this.sess);
                this.vorbaclient = this.clientfactory.getIClient(this.app, this.user, this.sess);
            } else if (this.newSession) {
                if (this.importFile == null) {
                    System.out.println("Connecting to a new VAMSAS Session.");
                    this.vorbaclient = this.clientfactory.getNewSessionIClient(this.app, this.user);
                } else {
                    System.out.println("Connecting to a new VAMSAS Session to share data in existing document:" + this.importFile);
                    vfile = new File(this.importFile);
                    this.vorbaclient = this.clientfactory.openAsNewSessionIClient(this.app, this.user, vfile);
                    System.out.println("Succesfully imported document into new session.");
                    this.imported = true;
                    this.importFile = null;
                }
            } else {
                this.vorbaclient = this.clientfactory.getIClient(this.app, this.user);
            }
        }
        catch (InvalidSessionDocumentException e) {
            System.err.println("Failed to create a session to share " + this.importFile);
            System.err.println("Sorry it didn't work out. This is what went wrong:");
            e.printStackTrace(System.err);
            System.exit(3);
        }
        catch (NoDefaultSessionException e) {
            System.err.println("There appear to be several sessions to choose from :");
            String[] sessions = this.clientfactory.getCurrentSessions();
            for (int s = 0; s < sessions.length; ++s) {
                System.err.println(sessions[s]);
            }
            System.exit(2);
        }
        this.addHandlers(this.vorbaclient);
        try {
            this.vorbaclient.joinSession();
        }
        catch (Exception se) {
            se.printStackTrace();
            System.err.println(se + " when joining session.\n" + this.Usage);
            System.exit(1);
        }
        if (this.importFile != null) {
            vfile = new File(this.importFile);
            try {
                this.vorbaclient.importDocument(vfile);
                this.imported = true;
            }
            catch (Exception e) {
                System.err.println("Failed to import file " + this.importFile);
                System.err.println("Exception received was " + e);
                e.printStackTrace(System.err);
            }
        }
        if (this.outputFile != null) {
            vfile = new File(this.outputFile);
            try {
                this.vorbaclient.storeDocument(vfile);
            }
            catch (Exception e) {
                System.err.println("Failed to export session as file " + this.outputFile);
                System.err.println("Exception received was " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            IClientDocument cdoc = this.vorbaclient.getClientDocument();
            if (this.imported && (cdoc.getVamsasRoots() == null || cdoc.getVamsasRoots()[0].getDataSetCount() < 1)) {
                System.err.println("Imported an Empty vamsas document. Is this correct ?");
            }
            this.processVamsasDocument(cdoc);
        }
        catch (Exception e) {
            System.err.println("Unexpected exception when retrieving the client document for the first time!");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        int update = 0;
        ExamplePicker picker = new ExamplePicker(this.vorbaclient.getClientHandle().getClientUrn(), this.vorbaclient.getPickManager());
        picker.start();
        if (picker.pm != null) {
            picker.pm.registerMessageHandler(new IMessageHandler(){

                public void handleMessage(Message message) {
                    System.out.println("Received |" + message.getRawMessage() + "|");
                    ExampleApplication.this.shutdown += 100L;
                }
            });
        }
        this.shutdown = System.currentTimeMillis() + 10000L;
        while (!this.isShuttingdown && update < this.totalUpdates) {
            if (this.isUpdated) {
                System.out.println("Update handler called " + ++update + " times");
                System.out.println("******************************************");
                this.isUpdated = false;
                this.shutdown = System.currentTimeMillis() + 10000L;
                if (update % 2 == 1) {
                    try {
                        IClientDocument cdoc = this.vorbaclient.getClientDocument();
                        this.processVamsasDocument(cdoc);
                    }
                    catch (Exception e) {
                        System.err.println("Error when updating document after an even numbered update.");
                        e.printStackTrace(System.err);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception e) {}
                }
            } else if (System.currentTimeMillis() > this.shutdown) {
                this.isShuttingdown = true;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception e) {}
        }
        System.out.println("Finalizing.");
        this.vorbaclient.finalizeClient();
        System.out.println("Shutting down picker.");
        picker.pm = null;
        while (picker.isAlive()) {
            System.out.println("Waiting for picker to die...");
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {}
        }
        this.vorbaclient = null;
        this.clientfactory = null;
        System.out.println("Byee!");
    }

    public static void main(String[] args) {
        ExampleApplication example = new ExampleApplication();
        example.runMe(args);
    }

    class ExamplePicker
    extends Thread {
        String me = null;
        public IPickManager pm = null;

        ExamplePicker(String me, IPickManager pm) {
            this.me = me;
            this.pm = pm;
        }

        public void run() {
            int mcount = 1;
            while (this.pm != null) {
                try {
                    Thread.sleep(1000L + (long)Math.random() * 10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.pm == null) continue;
                this.pm.sendMessage(new CustomMessage("Message " + mcount++ + " from " + this.me));
            }
        }
    }
}

