/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.util.Vector;
import uk.ac.vamsas.objects.utils.MapList;

public class Mapping {
    MapList map = null;

    public Mapping(MapList map) {
        this.map = map;
    }

    public Mapping(int[] local, int[] mapped, int i, int j) {
        this(new MapList(local, mapped, i, j));
    }

    public Mapping(Mapping map2) {
        if (map2 != this && map2 != null && map2.map != null) {
            this.map = new MapList(map2.map);
        }
    }

    public MapList getMap() {
        return this.map;
    }

    public void setMap(MapList map) {
        this.map = map;
    }

    public boolean equals(Mapping other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.map != null && other.map == null || this.map == null && other.map != null) {
            return false;
        }
        return this.map.equals(other.map);
    }

    public int getPosition(int mpos) {
        int[] mp;
        if (this.map != null && (mp = this.map.shiftTo(mpos)) != null) {
            return mp[0];
        }
        return mpos;
    }

    public int[] getWord(int mpos) {
        if (this.map != null) {
            return this.map.getToWord(mpos);
        }
        return null;
    }

    public int getWidth() {
        if (this.map != null) {
            return this.map.getFromRatio();
        }
        return 1;
    }

    public int getMappedWidth() {
        if (this.map != null) {
            return this.map.getToRatio();
        }
        return 1;
    }

    public int getMappedPosition(int pos) {
        int[] mp;
        if (this.map != null && (mp = this.map.shiftFrom(pos)) != null) {
            return mp[0];
        }
        return pos;
    }

    public int[] getMappedWord(int pos) {
        int[] mp;
        if (this.map != null && (mp = this.map.shiftFrom(pos)) != null) {
            return new int[]{mp[0], mp[0] + mp[2] * (this.map.getToRatio() - 1)};
        }
        return null;
    }

    public int[] locateFeature(int begin, int end) {
        if (this.map != null) {
            int[] frange = this.map.locateInFrom(begin, end);
            return frange;
        }
        return new int[]{begin, end};
    }

    public int[] locateRange(int from, int to) {
        if (this.map != null) {
            if (from <= to) {
                from = this.map.getToLowest() < from ? from : this.map.getToLowest();
                int n = to = this.map.getToHighest() > to ? to : this.map.getToHighest();
                if (from > to) {
                    return null;
                }
            } else {
                from = this.map.getToHighest() > from ? from : this.map.getToHighest();
                int n = to = this.map.getToLowest() < to ? to : this.map.getToLowest();
                if (from < to) {
                    return null;
                }
            }
            return this.map.locateInFrom(from, to);
        }
        return new int[]{from, to};
    }

    public int[] locateMappedRange(int from, int to) {
        if (this.map != null) {
            if (from <= to) {
                from = this.map.getFromLowest() < from ? from : this.map.getFromLowest();
                int n = to = this.map.getFromHighest() > to ? to : this.map.getFromHighest();
                if (from > to) {
                    return null;
                }
            } else {
                from = this.map.getFromHighest() > from ? from : this.map.getFromHighest();
                int n = to = this.map.getFromLowest() < to ? to : this.map.getFromLowest();
                if (from < to) {
                    return null;
                }
            }
            return this.map.locateInTo(from, to);
        }
        return new int[]{from, to};
    }

    public Mapping intersectVisContigs(int[] viscontigs) {
        Mapping copy = new Mapping(this);
        if (this.map != null) {
            int f;
            Vector<int[]> toRange = new Vector<int[]>();
            Vector<int[]> fromRange = new Vector<int[]>();
            for (int vc = 0; vc < viscontigs.length; vc += 2) {
                int[] mpr = this.locateMappedRange(1 + viscontigs[vc], viscontigs[vc + 1] - 1);
                if (mpr == null) continue;
                for (int m = 0; m < mpr.length; m += 2) {
                    toRange.addElement(new int[]{mpr[m], mpr[m + 1]});
                    int[] xpos = this.locateRange(mpr[m], mpr[m + 1]);
                    for (int x = 0; x < xpos.length; x += 2) {
                        fromRange.addElement(new int[]{xpos[x], xpos[x + 1]});
                    }
                }
            }
            int[] from = new int[fromRange.size() * 2];
            int[] to = new int[toRange.size() * 2];
            int fSize = fromRange.size();
            for (f = 0; f < fSize; ++f) {
                int[] r = (int[])fromRange.elementAt(f);
                from[f * 2] = r[0];
                from[f * 2 + 1] = r[1];
            }
            fSize = toRange.size();
            for (f = 0; f < fSize; ++f) {
                int[] r = (int[])toRange.elementAt(f);
                to[f * 2] = r[0];
                to[f * 2 + 1] = r[1];
            }
            copy.setMap(new MapList(from, to, this.map.getFromRatio(), this.map.getToRatio()));
        }
        return copy;
    }

    public static void main(String[] args) {
        MapList fk = new MapList(new int[]{1, 6, 8, 13, 15, 23}, new int[]{1, 7}, 3, 1);
        Mapping m = new Mapping(fk);
        Mapping m_1 = m.intersectVisContigs(new int[]{fk.getFromLowest(), fk.getFromHighest()});
        Mapping m_2 = m.intersectVisContigs(new int[]{1, 7, 11, 20});
        System.out.println("" + m_1.map.getFromRanges());
    }
}

