/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient.impl;

import io.github.warownia1.simplehttpclient.HttpRequest;
import io.github.warownia1.simplehttpclient.impl.EmptyRequestBody;
import io.github.warownia1.simplehttpclient.impl.HttpHeadersBuilder;
import io.github.warownia1.simplehttpclient.impl.ImmutableHttpRequest;
import java.net.URI;
import java.time.Duration;
import java.util.Locale;
import java.util.Objects;

public class SimpleHttpRequestBuilder
implements HttpRequest.Builder {
    URI uri;
    String method = "GET";
    HttpHeadersBuilder headers = new HttpHeadersBuilder();
    HttpRequest.Body body = EmptyRequestBody.getInstance();
    Duration timeout;

    @Override
    public SimpleHttpRequestBuilder uri(URI uri) {
        Objects.requireNonNull(uri);
        SimpleHttpRequestBuilder.checkURI(uri);
        this.uri = uri;
        return this;
    }

    static void checkURI(URI uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("URI with undefined scheme");
        }
        if (!(scheme = scheme.toLowerCase(Locale.US)).equals("https") && !scheme.equals("http")) {
            throw new IllegalArgumentException(String.format("invalid URI scheme %s", scheme));
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException(String.format("unsupported URI %s", uri));
        }
    }

    @Override
    public SimpleHttpRequestBuilder header(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.headers.addHeader(name, value);
        return this;
    }

    @Override
    public SimpleHttpRequestBuilder HEAD() {
        return this.method("HEAD", EmptyRequestBody.getInstance());
    }

    @Override
    public SimpleHttpRequestBuilder GET() {
        return this.method("GET", EmptyRequestBody.getInstance());
    }

    @Override
    public SimpleHttpRequestBuilder POST(HttpRequest.Body body) {
        Objects.requireNonNull(body);
        return this.method("POST", body);
    }

    @Override
    public SimpleHttpRequestBuilder PUT(HttpRequest.Body body) {
        Objects.requireNonNull(body);
        return this.method("PUT", body);
    }

    @Override
    public SimpleHttpRequestBuilder DELETE() {
        return this.method("DELETE", EmptyRequestBody.getInstance());
    }

    @Override
    public SimpleHttpRequestBuilder method(String method, HttpRequest.Body body) {
        Objects.requireNonNull(method);
        if (method.equals("")) {
            throw new IllegalArgumentException("illegal method <empty string>");
        }
        this.method = method;
        this.body = Objects.requireNonNull(body);
        return this;
    }

    @Override
    public SimpleHttpRequestBuilder timeout(Duration duration) {
        if (duration == null) {
            this.timeout = null;
            return this;
        }
        if (duration.isNegative() || duration.isZero()) {
            throw new IllegalArgumentException("invalid duration: " + duration);
        }
        this.timeout = duration;
        return this;
    }

    @Override
    public ImmutableHttpRequest build() {
        if (this.uri == null) {
            throw new IllegalStateException("uri is null");
        }
        return new ImmutableHttpRequest(this);
    }
}

