/*
 * Decompiled with CFR 0.152.
 */
package io.github.warownia1.simplehttpclient;

import io.github.warownia1.simplehttpclient.HttpClient;
import io.github.warownia1.simplehttpclient.HttpHeaders;
import io.github.warownia1.simplehttpclient.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;

public interface HttpResponse<T> {
    public int statusCode();

    public HttpRequest request();

    public HttpHeaders headers();

    public T body();

    public URI uri();

    public static class BodyHandlers {
        private BodyHandlers() {
        }

        public static BodyHandler<String> ofString() {
            return (info, stream) -> new String(stream.readAllBytes());
        }

        public static BodyHandler<Void> discarding() {
            return (info, stream) -> null;
        }

        public static BodyHandler<InputStream> ofInputStream() {
            return (info, stream) -> stream;
        }
    }

    @FunctionalInterface
    public static interface BodyHandler<T> {
        public T apply(ResponseInfo var1, InputStream var2) throws IOException;
    }

    public static interface ResponseInfo {
        public int statusCode();

        public HttpHeaders headers();

        public HttpClient.Version version();
    }
}

