/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    private DateUtils() {
    }

    public static boolean isDateISO8601(String dateString) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            if (dateString == null) {
                                return false;
                            }
                            try {
                                if (dateString.charAt(4) == '-') break block8;
                                return false;
                            }
                            catch (StringIndexOutOfBoundsException ex) {
                                return false;
                            }
                        }
                        if (dateString.charAt(7) == '-') break block9;
                        return false;
                    }
                    if (dateString.charAt(10) == 'T') break block10;
                    return false;
                }
                if (dateString.charAt(13) == ':') break block11;
                return false;
            }
            if (dateString.charAt(16) == ':') break block12;
            return false;
        }
        return dateString.charAt(19) == '-' || dateString.charAt(19) == '+';
    }

    public static Date getDateFromISO8601(String dateString) {
        String tz = "-08:00";
        if (dateString.endsWith(":00")) {
            tz = dateString.substring(dateString.length() - 6);
        }
        String dateNoTimeZone = dateString.substring(0, dateString.length() - 6);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone timezone = TimeZone.getTimeZone("GMT" + tz);
        Calendar cal = Calendar.getInstance(timezone);
        format.setCalendar(cal);
        Date date = null;
        try {
            date = format.parse(dateNoTimeZone);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public static String getDateInISO8601(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        int offset = cal.getTimeZone().getOffset(date.getTime());
        char delta = '+';
        if (offset < 0) {
            delta = '-';
            offset = Math.abs(offset);
        }
        StringBuffer result = new StringBuffer(30);
        result.append(format.format(date));
        result.append(delta);
        int hourOffset = offset / 3600000;
        if (hourOffset < 10) {
            result.append("0");
        }
        result.append(hourOffset);
        result.append(":00");
        return result.toString();
    }

    static boolean areDatesEqualEnough(Date d1, Date d2) {
        long t2;
        long t1 = d1.getTime();
        if (t1 == (t2 = d2.getTime())) {
            return true;
        }
        return Math.abs(t1 - t2) < 999L;
    }

    public static void main(String[] args) {
        Date d1 = new Date();
        String test = DateUtils.getDateInISO8601(d1);
        Date d2 = DateUtils.getDateFromISO8601(test);
        if (DateUtils.areDatesEqualEnough(d1, d2)) {
            System.out.println("Dates match");
        }
        System.out.println(DateUtils.isDateISO8601(test));
        System.out.println(DateUtils.isDateISO8601("2003-10-08T14:05:31-08:00"));
        System.out.println(DateUtils.isDateISO8601("2003-10-08X14:05:31-08:00"));
        System.out.println(DateUtils.isDateISO8601("2003-11-10T20:01:17"));
        System.out.println(DateUtils.isDateISO8601(d2.toString()));
    }
}

