/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.dundee.compbio.jpred;

import io.github.warownia1.simplehttpclient.HttpClient;
import io.github.warownia1.simplehttpclient.HttpRequest;
import io.github.warownia1.simplehttpclient.HttpResponse;
import io.github.warownia1.simplehttpclient.impl.ByteArrayRequestBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import uk.ac.dundee.compbio.jpred.JPredRequest;
import uk.ac.dundee.compbio.jpred.Utils;

public class JPredClient {
    private static final String delim = "\u00a3\u20ac\u00a3\u20ac";
    private final HttpClient client = HttpClient.newHttpClient();
    private final URL jpredURL;

    public JPredClient(URL url) {
        this.jpredURL = url;
    }

    public JPredClient() {
        this(JPredClient.getDefaultURL());
    }

    private static URL getDefaultURL() {
        try {
            return new URL("https://www.compbio.dundee.ac.uk/jpred4");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getURL() {
        return this.jpredURL;
    }

    public String submit(JPredRequest request) throws IOException {
        int numChars;
        StringBuilder bodyBuilder = new StringBuilder();
        String format = this.getFormatName(request.getMode(), request.getFormat());
        bodyBuilder.append("format=").append(format).append(delim);
        bodyBuilder.append("skipPDB=").append(request.getSkipPDB() ? "on" : "off").append(delim);
        if (request.getEmail() != null) {
            bodyBuilder.append("email=").append(request.getEmail()).append(delim);
        }
        if (request.getName() != null) {
            bodyBuilder.append("name=").append(request.getName()).append(delim);
        }
        if (request.getFormat() == JPredRequest.Format.SEQ) {
            bodyBuilder.append(">query\n");
        }
        Reader reader = request.getInputReader();
        char[] cbuf = new char[1024];
        while ((numChars = reader.read(cbuf)) > 0) {
            bodyBuilder.append(cbuf, 0, numChars);
        }
        ByteBuffer bbuf = StandardCharsets.UTF_8.encode(CharBuffer.wrap(bodyBuilder));
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.jpredURL.toString() + "/cgi-bin/rest/job")).header("Content-Type", "text/txt").POST((HttpRequest.Body)new ByteArrayRequestBody(bbuf.array(), bbuf.position(), bbuf.limit() - bbuf.position())).build();
        HttpResponse response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 202) {
            throw new IOException((String)response.body());
        }
        String body = (String)response.body();
        int urlStart = body.indexOf("<a href=\"");
        if (urlStart == -1) {
            throw new IOException((String)response.body());
        }
        int urlEnd = body.indexOf("\"", urlStart + 9);
        String resourceUrl = body.substring(urlStart + 9, urlEnd);
        int querySeparator = resourceUrl.indexOf("?");
        if (querySeparator == -1) {
            throw new IOException((String)response.body());
        }
        return resourceUrl.substring(querySeparator + 1);
    }

    private String getFormatName(JPredRequest.Mode mode, JPredRequest.Format format) {
        switch (mode) {
            case SINGLE: {
                switch (format) {
                    case FASTA: 
                    case SEQ: {
                        return "seq";
                    }
                }
                throw Utils.newIAE("illegal mode and format combination");
            }
            case MSA: {
                switch (format) {
                    case FASTA: {
                        return "fasta";
                    }
                    case MSF: {
                        return "msf";
                    }
                    case BLC: {
                        return "blc";
                    }
                }
                throw Utils.newIAE("illegal mode and format combination");
            }
            case BATCH: {
                if (format == JPredRequest.Format.FASTA) {
                    return "batch";
                }
                throw Utils.newIAE("illegal mode and format combination");
            }
        }
        throw Utils.newIAE("illegal mode");
    }

    public Status getStatus(String jobId) throws IOException {
        String path = String.format("/cgi-bin/rest/job/id/%s", jobId);
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.jpredURL.toString() + path)).build();
        HttpResponse response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofString());
        if (((String)response.body()).contains("due to run before yours") || ((String)response.body()).contains("next to be submitted")) {
            return Status.PENDING;
        }
        if (((String)response.body()).contains("complete")) {
            return Status.RUNNING;
        }
        if (((String)response.body()).contains("finished")) {
            return Status.FINISHED;
        }
        if (((String)response.body()).contains("malformed")) {
            return Status.MALFORMED;
        }
        if (((String)response.body()).contains("does not exist")) {
            return Status.NOT_EXIST;
        }
        if (((String)response.body()).contains("No job")) {
            return Status.NO_JOB;
        }
        throw new IOException((String)response.body());
    }

    public URL getResultURL(String jobId, String resource) {
        String fn = resource.equalsIgnoreCase("log") ? "LOG" : (resource.equalsIgnoreCase("readme") ? "README" : String.format("%s.%s", jobId, resource));
        String path = this.jpredURL.getPath() + String.format("/results/%s/%s", jobId, fn);
        try {
            return new URL(this.jpredURL, path);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    public InputStream getResultStream(String jobId, String resource) throws IOException {
        URI uri;
        try {
            uri = this.getResultURL(jobId, resource).toURI();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        HttpRequest httpRequest = HttpRequest.newBuilder((URI)uri).build();
        HttpResponse response = this.client.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
        return (InputStream)response.body();
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED,
        MALFORMED,
        NOT_EXIST,
        NO_JOB;

    }
}

