/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.params;

import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SimpleParamSet
implements WsParamSetI {
    protected String name;
    protected String description;
    protected String[] applicableUrls;
    protected String sourceFile;
    protected boolean modifiable;
    protected List<ArgumentI> arguments;

    protected SimpleParamSet(Builder builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.applicableUrls = builder.applicableUrls.toArray(new String[0]);
        this.sourceFile = null;
        this.modifiable = builder.modifiable;
        this.setArguments(builder.arguments);
    }

    public SimpleParamSet(WsParamSetI copy) {
        this.name = copy.getName();
        this.description = copy.getDescription();
        String[] urls = copy.getApplicableUrls();
        this.applicableUrls = Arrays.copyOf(urls, urls.length);
        this.sourceFile = copy.getSourceFile();
        this.modifiable = copy.isModifiable();
        this.setArguments(copy.getArguments());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String[] getApplicableUrls() {
        return this.applicableUrls;
    }

    public void setApplicableUrls(String[] urls) {
        this.applicableUrls = urls;
    }

    @Override
    public String getSourceFile() {
        return this.sourceFile;
    }

    @Override
    public void setSourceFile(String newFile) {
        this.sourceFile = newFile;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    @Override
    public List<ArgumentI> getArguments() {
        return this.arguments;
    }

    @Override
    public void setArguments(List<ArgumentI> args) {
        if (!this.isModifiable()) {
            throw new UnsupportedOperationException("Attempting to modify an unmodifiable parameter set");
        }
        this.arguments = Collections.unmodifiableList(new ArrayList<ArgumentI>(args));
    }

    public static class Builder {
        private String name = "default";
        private String description = "";
        private List<String> applicableUrls = new ArrayList<String>();
        private boolean modifiable = false;
        private List<ArgumentI> arguments = new ArrayList<ArgumentI>();

        public void name(String val) {
            this.name = val;
        }

        public void description(String val) {
            this.description = val;
        }

        public void url(String val) {
            this.applicableUrls.add(val);
        }

        public void urls(String[] val) {
            this.applicableUrls.clear();
            for (String url : val) {
                this.applicableUrls.add(url);
            }
        }

        public void modifiable(boolean val) {
            this.modifiable = val;
        }

        public void argument(ArgumentI val) {
            this.arguments.add(val);
        }

        public void arguments(List<? extends ArgumentI> val) {
            this.arguments.clear();
            this.arguments.addAll(val);
        }

        public SimpleParamSet build() {
            return new SimpleParamSet(this);
        }
    }
}

