/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.ebi;

import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileParse;
import jalview.io.StockholmFile;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.simple.BooleanOption;
import jalview.ws.params.simple.DoubleParameter;
import jalview.ws.params.simple.IntegerParameter;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.api.WebServiceJobHandle;
import jalview.ws2.client.api.AlignmentWebServiceClientI;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.List;
import uk.ac.dundee.compbio.hmmerclient.PhmmerClient;
import uk.ac.dundee.compbio.hmmerclient.PhmmerRequest;

public class PhmmerWSClient
implements AlignmentWebServiceClientI {
    final PhmmerClient client;

    PhmmerWSClient(PhmmerClient client) {
        this.client = client;
    }

    @Override
    public String getUrl() {
        return this.client.getURL().toString();
    }

    @Override
    public String getClientName() {
        return "ebi-job-dispatcher";
    }

    @Override
    public WebServiceJobHandle submit(List<SequenceI> sequences, List<ArgumentI> args, Credentials credentials) throws IOException {
        PhmmerRequest.Builder request = PhmmerRequest.newBuilder();
        String sequence = FileFormat.Fasta.getWriter(null).print(new SequenceI[]{sequences.get(0)}, false);
        request.sequence((Reader)new StringReader(sequence));
        PhmmerWSClient.populateRequestArguments(request, args);
        String email = credentials.getEmail() != null ? credentials.getEmail() : "nouser@jalview.org";
        String jobId = this.client.submit(request.build(), email);
        Console.debug("Phmmer client submitted new job with id " + jobId);
        return new WebServiceJobHandle(this.getClientName(), "phmmer", this.getUrl(), jobId);
    }

    private static void populateRequestArguments(PhmmerRequest.Builder request, List<ArgumentI> args) {
        boolean useBitScore = false;
        boolean useEValue = false;
        for (ArgumentI arg : args) {
            if (!arg.getName().equals("cut-offs")) continue;
            if (arg.getValue().equals("E")) {
                useEValue = true;
                continue;
            }
            if (arg.getValue().equals("T")) {
                useBitScore = true;
                continue;
            }
            throw new IllegalArgumentException("cut-offs argument contains value other than \"E\" or \"T\": " + arg.getValue());
        }
        assert (!(!useBitScore && !useEValue || useBitScore && useEValue));
        for (ArgumentI arg : args) {
            switch (arg.getName()) {
                case "incE": {
                    request.incE(useEValue ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "incdomE": {
                    request.incdomE(useEValue ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "E": {
                    request.E(useEValue ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "domE": {
                    request.domE(useEValue ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "incT": {
                    request.incT(useBitScore ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "incdomT": {
                    request.incdomT(useBitScore ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "T": {
                    request.T(useBitScore ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "domT": {
                    request.domT(useBitScore ? DoubleParameter.parseFloat(arg) : null);
                    break;
                }
                case "popen": {
                    request.popen(DoubleParameter.parseFloat(arg));
                    break;
                }
                case "pextend": {
                    request.pextend(DoubleParameter.parseFloat(arg));
                    break;
                }
                case "mx": {
                    request.mx(PhmmerWSClient.parseSubstitutionMatrix(arg));
                    break;
                }
                case "nobias": {
                    request.noBias(BooleanOption.parseBoolean(arg).booleanValue());
                    break;
                }
                case "compressedout": {
                    request.compressedOut(BooleanOption.parseBoolean(arg).booleanValue());
                    break;
                }
                case "alignView": {
                    request.compressedOut(BooleanOption.parseBoolean(arg).booleanValue());
                    break;
                }
                case "database": {
                    request.database(PhmmerWSClient.parseSequenceDatabase(arg));
                    break;
                }
                case "evalue": {
                    request.evalue(DoubleParameter.parseFloat(arg));
                    break;
                }
                case "nhits": {
                    request.nhits(IntegerParameter.parseInt(arg));
                }
            }
        }
    }

    private static PhmmerRequest.SubstitutionMatrix parseSubstitutionMatrix(ArgumentI arg) {
        if (arg.getValue() == null) {
            return null;
        }
        switch (arg.getValue()) {
            case "BLOSUM45": {
                return PhmmerRequest.SubstitutionMatrix.BLOSUM45;
            }
            case "BLOSUM62": {
                return PhmmerRequest.SubstitutionMatrix.BLOSUM62;
            }
            case "BLOSUM90": {
                return PhmmerRequest.SubstitutionMatrix.BLOSUM90;
            }
            case "PAM30": {
                return PhmmerRequest.SubstitutionMatrix.PAM30;
            }
            case "PAM70": {
                return PhmmerRequest.SubstitutionMatrix.PAM70;
            }
        }
        throw new IllegalArgumentException("invalid matrix " + arg.getValue());
    }

    private static PhmmerRequest.SequenceDatabase parseSequenceDatabase(ArgumentI arg) {
        if (arg.getValue() == null) {
            return null;
        }
        switch (arg.getValue()) {
            case "swissprot": {
                return PhmmerRequest.SequenceDatabase.SWISS_PROT;
            }
            case "uniprotrefprot": {
                return PhmmerRequest.SequenceDatabase.REFERENCE_PROTEOMES;
            }
            case "uniprotkb": {
                return PhmmerRequest.SequenceDatabase.UNIPROTKB;
            }
            case "pdb": {
                return PhmmerRequest.SequenceDatabase.PDB;
            }
            case "rp75": {
                return PhmmerRequest.SequenceDatabase.RP75;
            }
            case "rp55": {
                return PhmmerRequest.SequenceDatabase.RP55;
            }
            case "rp35": {
                return PhmmerRequest.SequenceDatabase.RP35;
            }
            case "rp15": {
                return PhmmerRequest.SequenceDatabase.RP15;
            }
            case "ensembl": {
                return PhmmerRequest.SequenceDatabase.ENSEMBL;
            }
            case "merops": {
                return PhmmerRequest.SequenceDatabase.MEROPS;
            }
            case "qfo": {
                return PhmmerRequest.SequenceDatabase.QUEST_FOR_ORTHOLOGS;
            }
            case "chembl": {
                return PhmmerRequest.SequenceDatabase.CHEMBL;
            }
        }
        throw new IllegalArgumentException("invalid database " + arg.getValue());
    }

    @Override
    public JobStatus getStatus(WebServiceJobHandle job) throws IOException {
        PhmmerClient.Status status = this.client.getStatus(job.getJobId());
        switch (status) {
            case PENDING: {
                return JobStatus.SUBMITTED;
            }
            case QUEUED: {
                return JobStatus.QUEUED;
            }
            case RUNNING: {
                return JobStatus.RUNNING;
            }
            case FINISHED: {
                return JobStatus.COMPLETED;
            }
            case FAILURE: {
                return JobStatus.FAILED;
            }
            case ERROR: {
                return JobStatus.SERVER_ERROR;
            }
            case NOT_FOUND: {
                return JobStatus.SERVER_ERROR;
            }
            case UNDEFINED: {
                return JobStatus.UNKNOWN;
            }
        }
        return JobStatus.UNKNOWN;
    }

    @Override
    public String getLog(WebServiceJobHandle job) throws IOException {
        return "";
    }

    @Override
    public String getErrorLog(WebServiceJobHandle job) throws IOException {
        if (this.getStatus(job) != JobStatus.FAILED) {
            return "";
        }
        try (InputStream stream = this.client.getResultStream(job.getJobId(), "error");){
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            stream.transferTo(out);
            String string = out.toString();
            return string;
        }
    }

    @Override
    public void cancel(WebServiceJobHandle job) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("ebi job dispatcher does not support job cancellation");
    }

    @Override
    public AlignmentI getAlignment(WebServiceJobHandle job) throws IOException {
        URI url = this.client.getResultURL(job.getJobId(), "sto");
        try (InputStream stream = this.client.getResultStream(job.getJobId(), "sto");){
            StockholmFile file = new StockholmFile(new FileParse(new BufferedReader(new InputStreamReader(stream)), url.toString(), DataSourceType.URL));
            Alignment aln = new Alignment(file.getSeqsAsArray());
            for (AlignmentAnnotation annotation : file.getAnnotations()) {
                aln.addAnnotation(annotation);
            }
            Alignment alignment = aln;
            return alignment;
        }
    }
}

