/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.client.ebi;

import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import jalview.ws.params.simple.BooleanOption;
import jalview.ws.params.simple.DoubleParameter;
import jalview.ws.params.simple.IntegerParameter;
import jalview.ws.params.simple.Option;
import jalview.ws.params.simple.StringParameter;
import jalview.ws2.params.SimpleParamDatastore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ParamStores {
    static final List<ArgumentI> phmmerParameters;

    ParamStores() {
    }

    private static URL resolveURL(URL base, String spec) {
        try {
            return new URL(base, spec);
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static ParamDatastoreI newPhmmerDatastore(URL url, ParamManager manager) {
        return new SimpleParamDatastore(url, phmmerParameters, Collections.emptyList(), manager);
    }

    static {
        URL baseURL;
        ArrayList<Option> parameters = new ArrayList<Option>();
        try {
            baseURL = new URL("https://www.ebi.ac.uk/Tools/services/rest/hmmer3_phmmer/");
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
        Option.Builder builder = StringParameter.newBuilder();
        builder.setName("cut-offs");
        builder.setLabel("Cut-offs");
        builder.setDescription("Set the method of controlling which target sequences match your query.");
        builder.setRequired(true);
        builder.setValue("E");
        builder.setDefaultValue("E");
        builder.setPossibleValues(List.of("E", "T"));
        builder.setDisplayValues(List.of("E-values", "Bit scores"));
        parameters.add(((StringParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("incE");
        builder.setLabel("Significance E-values[Sequence]");
        builder.setDescription("Significance E-values[Sequence]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(0.01);
        ((DoubleParameter.Builder)builder).setDefaultValue(0.01);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        ((DoubleParameter.Builder)builder).setMax(10.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/incE"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("incdomE");
        builder.setLabel("Significance E-values[Hit]");
        builder.setDescription("Significance E-values[Hit]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(0.03);
        ((DoubleParameter.Builder)builder).setDefaultValue(0.03);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        ((DoubleParameter.Builder)builder).setMax(10.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/incdomE"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("E");
        builder.setLabel("Report E-values[Sequence]");
        builder.setDescription("Report E-values[Sequence]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(1.0);
        ((DoubleParameter.Builder)builder).setDefaultValue(1.0);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        ((DoubleParameter.Builder)builder).setMax(10.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/E"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("domE");
        builder.setLabel("Report E-values[Hit]");
        builder.setDescription("Report E-values[Hit]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(1.0);
        ((DoubleParameter.Builder)builder).setDefaultValue(1.0);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        ((DoubleParameter.Builder)builder).setMax(10.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/domE"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("incT");
        builder.setLabel("Significance bit scores[Sequence]");
        builder.setDescription("Significance bit scores[Sequence]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(25.0);
        ((DoubleParameter.Builder)builder).setDefaultValue(25.0);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/incT"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("incdomT");
        builder.setLabel("Significance bit scores[Hit]");
        builder.setDescription("Significance bit scores[Hit]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(22.0);
        ((DoubleParameter.Builder)builder).setDefaultValue(22.0);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/incdomT"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("T");
        builder.setLabel("Report bit scores[Sequence]");
        builder.setDescription("Report bit scores[Sequence]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(7.0);
        ((DoubleParameter.Builder)builder).setDefaultValue(7.0);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/T"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("domT");
        builder.setLabel("Report bit scores[Hit]");
        builder.setDescription("Report bit scores[Hit]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(5.0);
        ((DoubleParameter.Builder)builder).setDefaultValue(5.0);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/domT"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("popen");
        builder.setLabel("Gap Penalties[open]");
        builder.setDescription("Gap Penalties[open]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(0.02);
        ((DoubleParameter.Builder)builder).setDefaultValue(0.02);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        ((DoubleParameter.Builder)builder).setMax(0.5);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/popen"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("pextend");
        builder.setLabel("Gap Penalties[extend]");
        builder.setDescription("Gap Penalties[extend]");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(0.4);
        ((DoubleParameter.Builder)builder).setDefaultValue(0.4);
        ((DoubleParameter.Builder)builder).setMin(0.0);
        ((DoubleParameter.Builder)builder).setMax(1.0);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/pextend"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = StringParameter.newBuilder();
        builder.setName("mx");
        builder.setLabel("Gap Penalties[Substitution scoring matrix]");
        builder.setDescription("Gap Penalties[Substitution scoring matrix]");
        builder.setRequired(false);
        builder.setValue("BLOSUM62");
        builder.setDefaultValue("BLOSUM62");
        builder.setPossibleValues(List.of("BLOSUM45", "BLOSUM62", "BLOSUM90", "PAM30", "PAM70"));
        builder.setDisplayValues(List.of("BLOSUM45", "BLOSUM62", "BLOSUM90", "PAM30", "PAM70"));
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/mx"));
        parameters.add(((StringParameter.Builder)builder).build());
        builder = BooleanOption.newBuilder();
        builder.setName("nobias");
        builder.setLabel("No bias filter");
        builder.setDescription("The '--nobias' option turns off (bypasses) the biased composition filter which is on by default.");
        builder.setRequired(false);
        ((BooleanOption.Builder)builder).setValue(false);
        ((BooleanOption.Builder)builder).setDefaultValue(false);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/nobias"));
        parameters.add(((BooleanOption.Builder)builder).build());
        builder = BooleanOption.newBuilder();
        builder.setName("compressedout");
        builder.setLabel("Compressed Output");
        builder.setDescription("By default it runs hmm2c plus post-processing (default output), whereas with compressedout, it gets compressed output only.");
        builder.setRequired(false);
        ((BooleanOption.Builder)builder).setValue(false);
        ((BooleanOption.Builder)builder).setDefaultValue(false);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/compressedout"));
        parameters.add(((BooleanOption.Builder)builder).build());
        builder = BooleanOption.newBuilder();
        builder.setName("alignView");
        builder.setLabel("Output Alignment");
        builder.setDescription("Output alignment in result");
        builder.setRequired(false);
        ((BooleanOption.Builder)builder).setValue(true);
        ((BooleanOption.Builder)builder).setDefaultValue(true);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/alignView"));
        parameters.add(((BooleanOption.Builder)builder).build());
        builder = StringParameter.newBuilder();
        builder.setName("database");
        builder.setLabel("Sequence Database");
        builder.setDescription("Sequence Database Selection");
        builder.setRequired(true);
        builder.setValue("uniprotkb");
        builder.setDefaultValue("uniprotkb");
        builder.setPossibleValues(List.of("swissprot", "uniprotrefprot", "uniprotkb", "pdb", "rp75", "rp55", "rp35", "rp15", "ensembl", "merops", "qfo", "chembl"));
        builder.setDisplayValues(List.of("SwissProt", "Reference Proteomes", "UniProtKB", "PDB", "rp75", "rp55", "rp35", "rp15", "Ensembl", "MEROPS", "Quest for Orthologs", "ChEMBL"));
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/database"));
        parameters.add(((StringParameter.Builder)builder).build());
        builder = DoubleParameter.newBuilder();
        builder.setName("evalue");
        builder.setLabel("Expectation Value Threshold");
        builder.setDescription("Expectation value cut-off for reporting target profiles in the per-target output.");
        builder.setRequired(false);
        ((DoubleParameter.Builder)builder).setValue(0.01);
        ((DoubleParameter.Builder)builder).setDefaultValue(0.01);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/evalue"));
        parameters.add(((DoubleParameter.Builder)builder).build());
        builder = IntegerParameter.newBuilder();
        builder.setName("nhits");
        builder.setLabel("Number of Hits Displayed");
        builder.setDescription("Number of hits to be displayed.");
        builder.setRequired(false);
        ((IntegerParameter.Builder)builder).setValue(100);
        ((IntegerParameter.Builder)builder).setDefaultValue(100);
        builder.setDetailsUrl(ParamStores.resolveURL(baseURL, "parameterdetails/nhits"));
        parameters.add(((IntegerParameter.Builder)builder).build());
        phmmerParameters = Collections.unmodifiableList(parameters);
    }
}

