/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions.hmmer;

import jalview.analysis.AlignSeq;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import jalview.ws.params.ArgumentI;
import jalview.ws2.actions.BaseJob;
import jalview.ws2.actions.BaseTask;
import jalview.ws2.actions.ServiceInputInvalidException;
import jalview.ws2.api.Credentials;
import jalview.ws2.api.JobStatus;
import jalview.ws2.client.api.AlignmentWebServiceClientI;
import java.io.IOException;
import java.util.List;

class PhmmerTask
extends BaseTask<BaseJob, AlignmentI> {
    private final AlignmentWebServiceClientI client;
    private final AlignmentView view;

    PhmmerTask(AlignmentWebServiceClientI client, List<ArgumentI> args, Credentials credentials, AlignmentView view) {
        super(client, args, credentials);
        this.client = client;
        this.view = view;
    }

    @Override
    protected List<BaseJob> prepareJobs() throws ServiceInputInvalidException {
        Console.info("Preparing sequence for phmmer job");
        SequenceI sequence = this.view.getVisibleAlignment('-').getSequenceAt(0);
        Sequence seq = new Sequence(sequence.getName(), AlignSeq.extractGaps(Comparison.GapChars, sequence.getSequenceAsString()));
        BaseJob job = new BaseJob(List.of(seq)){

            @Override
            public boolean isInputValid() {
                return true;
            }
        };
        job.setStatus(JobStatus.READY);
        return List.of(job);
    }

    @Override
    protected AlignmentI collectResult(List<BaseJob> jobs) throws IOException {
        BaseJob job = jobs.get(0);
        JobStatus status = job.getStatus();
        Console.info(String.format("phmmer finished job \"%s\" with status %s", new Object[]{job.getServerJob().getJobId(), status}));
        if (status != JobStatus.COMPLETED) {
            return null;
        }
        AlignmentI outputAlignment = this.client.getAlignment(job.getServerJob());
        SequenceI querySeq = job.getInputSequences().get(0).deriveSequence();
        AlignmentAnnotation refpos = null;
        for (AlignmentAnnotation annot : outputAlignment.getAlignmentAnnotation()) {
            if (annot.sequenceRef != null || !annot.label.equals("Reference Positions")) continue;
            refpos = annot;
            break;
        }
        if (refpos != null) {
            querySeq = this.alignQeuryToReferencePositions(querySeq, refpos);
        }
        outputAlignment.insertSequenceAt(0, querySeq);
        return outputAlignment;
    }

    private SequenceI alignQeuryToReferencePositions(SequenceI query, AlignmentAnnotation refpos) {
        StringBuilder sequenceBuilder = new StringBuilder();
        int index = 0;
        for (Annotation a : refpos.annotations) {
            if (a != null && a.displayCharacter.equals("x")) {
                char c;
                while (Comparison.isGap(c = query.getCharAt(index++))) {
                }
                sequenceBuilder.append(c);
                continue;
            }
            sequenceBuilder.append('-');
        }
        query.setSequence(sequenceBuilder.toString());
        return query;
    }
}

