/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws2.actions;

import jalview.datamodel.SequenceI;
import jalview.util.MathUtils;
import jalview.ws2.actions.api.JobI;
import jalview.ws2.api.JobStatus;
import jalview.ws2.api.WebServiceJobHandle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;

public abstract class BaseJob
implements JobI {
    protected final long internalId = MathUtils.getUID();
    protected final List<SequenceI> inputSeqs;
    protected JobStatus status = JobStatus.CREATED;
    protected String log = "";
    protected String errorLog = "";
    protected WebServiceJobHandle serverJob;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public BaseJob(List<SequenceI> inputSeqs) {
        this.inputSeqs = inputSeqs;
    }

    @Override
    public final long getInternalId() {
        return this.internalId;
    }

    public List<SequenceI> getInputSequences() {
        return this.inputSeqs;
    }

    public abstract boolean isInputValid();

    public boolean isCompleted() {
        return !this.isInputValid() || this.getStatus().isDone();
    }

    @Override
    public final JobStatus getStatus() {
        return this.status;
    }

    public final void setStatus(JobStatus status) {
        JobStatus oldStatus = this.status;
        this.status = status;
        this.pcs.firePropertyChange("status", (Object)oldStatus, (Object)status);
    }

    @Override
    public final String getLog() {
        return this.log;
    }

    public final void setLog(String log) {
        String oldLog = this.log;
        this.log = log;
        this.pcs.firePropertyChange("log", oldLog, log);
    }

    @Override
    public final String getErrorLog() {
        return this.errorLog;
    }

    public final void setErrorLog(String errorLog) {
        String oldLog = this.errorLog;
        this.errorLog = errorLog;
        this.pcs.firePropertyChange("errorLog", oldLog, errorLog);
    }

    public final WebServiceJobHandle getServerJob() {
        return this.serverJob;
    }

    public final void setServerJob(WebServiceJobHandle job) {
        this.serverJob = job;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

