/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.slivkaws;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FormatAdapter;
import jalview.ws.api.JobId;
import jalview.ws.api.MultipleSequenceAlignmentI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.InvalidArgumentException;
import jalview.ws.params.WsParamSetI;
import jalview.ws.slivkaws.SlivkaWSInstance;
import java.io.IOError;
import java.io.IOException;
import java.rmi.ServerError;
import java.util.Collection;
import java.util.List;
import uk.ac.dundee.compbio.slivkaclient.RemoteFile;
import uk.ac.dundee.compbio.slivkaclient.SlivkaClient;
import uk.ac.dundee.compbio.slivkaclient.SlivkaService;

public class SlivkaMsaServiceInstance
extends SlivkaWSInstance
implements MultipleSequenceAlignmentI {
    SlivkaMsaServiceInstance(SlivkaClient client, SlivkaService service, String category) {
        super(client, service, category);
        this.style = ServiceWithParameters.ServiceClient.MSAWSCLIENT;
    }

    @Override
    public JobId align(List<SequenceI> toalign, WsParamSetI parameters, List<ArgumentI> list) throws Throwable {
        return super.submit(toalign, parameters, list);
    }

    @Override
    public AlignmentI getAlignmentFor(JobId jobId) throws InvalidArgumentException, ServerError, IOError {
        try {
            Collection files = this.client.fetchFilesList(jobId.getJobId());
            for (RemoteFile f : files) {
                if (f.getMediaType().equals("application/clustal")) {
                    return new FormatAdapter().readFile(f.getContentUrl().toString(), DataSourceType.URL, (FileFormatI)FileFormat.Clustal);
                }
                if (!f.getMediaType().equals("application/fasta")) continue;
                return new FormatAdapter().readFile(f.getContentUrl().toString(), DataSourceType.URL, (FileFormatI)FileFormat.Fasta);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return null;
    }
}

