/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.JABAService;
import compbio.data.msa.MsaWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import jalview.bin.Console;
import jalview.gui.Desktop;
import jalview.util.MessageManager;
import jalview.ws.api.JalviewServiceEndpointProviderI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.jabaws2.AADisorderClient;
import jalview.ws.jws2.jabaws2.JabawsMsaInstance;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import java.io.Closeable;
import java.net.URL;

public class Jws2Instance
extends ServiceWithParameters
implements JalviewServiceEndpointProviderI,
AutoCloseable {
    public JABAService service;
    PresetManager presets = null;
    public JabaParamStore paramStore = null;
    private boolean hasParams = false;
    private boolean lookedForParams = false;

    public Jws2Instance(String hosturl, String serviceType, String action, String description, JABAService service) {
        super(action, action, serviceType, description, hosturl);
        this.service = service;
        if (service instanceof MsaWS) {
            this.style = ServiceWithParameters.ServiceClient.MSAWSCLIENT;
        } else if (service instanceof SequenceAnnotation) {
            this.style = ServiceWithParameters.ServiceClient.SEQUENCEANNOTATIONWSCLIENT;
        }
        int p = description.indexOf("MORE INFORMATION:");
        if (p > -1) {
            String docUrl = description.substring(description.indexOf("http", p)).trim();
            if (docUrl.indexOf(10) > -1) {
                docUrl = docUrl.substring(0, docUrl.indexOf("\n")).trim();
            }
            if (docUrl.length() > 0) {
                try {
                    URL url = new URL(docUrl);
                    if (url != null) {
                        this.setDocumentationUrl(docUrl);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public PresetManager getPresets() {
        if (this.presets == null) {
            try {
                if (this.service instanceof MsaWS) {
                    this.presets = ((MsaWS)this.service).getPresets();
                }
                if (this.service instanceof SequenceAnnotation) {
                    this.presets = ((SequenceAnnotation)this.service).getPresets();
                }
            }
            catch (Exception ex) {
                Console.errPrintln("Exception when retrieving presets for service " + this.getServiceType() + " at " + this.getHostURL());
            }
        }
        return this.presets;
    }

    public RunnerConfig getRunnerConfig() {
        if (this.service instanceof MsaWS) {
            return ((MsaWS)this.service).getRunnerOptions();
        }
        if (this.service instanceof SequenceAnnotation) {
            return ((SequenceAnnotation)this.service).getRunnerOptions();
        }
        throw new Error(MessageManager.formatMessage("error.implementation_error_runner_config_not_available", new String[]{this.getServiceType(), this.service.getClass().toString()}));
    }

    @Override
    public void close() {
        if (this.service != null) {
            try {
                ((Closeable)this.service).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public ParamDatastoreI getParamStore() {
        if (this.paramStore == null) {
            try {
                this.paramStore = new JabaParamStore(this, Desktop.getInstance() != null ? Desktop.getUserParameterStore() : null);
            }
            catch (Exception ex) {
                Console.errPrintln("Unexpected exception creating JabaParamStore.");
                ex.printStackTrace();
            }
        }
        return this.paramStore;
    }

    @Override
    public boolean hasParameters() {
        if (!this.lookedForParams) {
            this.lookedForParams = true;
            try {
                this.hasParams = this.getRunnerConfig().getArguments().size() > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.hasParams;
    }

    @Override
    public void initParamStore(ParamManager userParameterStore) {
        if (this.paramStore == null) {
            this.paramStore = new JabaParamStore(this, userParameterStore);
        }
    }

    @Override
    public Object getEndpoint() {
        if (this.service instanceof MsaWS) {
            if (this.aaui != null) {
                throw new Error("JABAWS MsaWS based instant calculation not implemented.");
            }
            return new JabawsMsaInstance(this);
        }
        if (this.service instanceof SequenceAnnotation) {
            if (this.aaui != null) {
                try {
                    return this.aaui.getClient().getConstructor(this.getClass()).newInstance(this);
                }
                catch (Throwable t) {
                    throw new Error("Implementation Error in web service framework", t);
                }
            }
            return new AADisorderClient(this);
        }
        return null;
    }
}

