/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.FastaSequence;
import compbio.metadata.ResultNotAvailableException;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.ws.api.CancellableI;
import jalview.ws.api.JobId;
import jalview.ws.api.MultipleSequenceAlignmentI;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.jabaws2.JabawsServiceInstance;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.InvalidArgumentException;
import jalview.ws.params.WsParamSetI;
import java.io.IOError;
import java.rmi.ServerError;
import java.util.ArrayList;
import java.util.List;

public class JabawsMsaInstance
extends JabawsServiceInstance<MsaWS>
implements MultipleSequenceAlignmentI,
CancellableI {
    @Override
    public JobId align(List<SequenceI> toalign, WsParamSetI parameters, List<ArgumentI> arguments) throws Throwable {
        ArrayList<FastaSequence> seqs = new ArrayList<FastaSequence>();
        for (SequenceI seq : toalign) {
            seqs.add(new FastaSequence(seq.getName(), seq.getSequenceAsString()));
        }
        String jobid = null;
        jobid = parameters != null ? (parameters instanceof JabaPreset ? ((MsaWS)this.service).presetAlign(seqs, ((JabaPreset)parameters).getJabaPreset()) : ((MsaWS)this.service).customAlign(seqs, JabaParamStore.getJabafromJwsArgs(parameters.getArguments()))) : (arguments != null && arguments.size() > 0 ? ((MsaWS)this.service).customAlign(seqs, JabaParamStore.getJabafromJwsArgs(arguments)) : ((MsaWS)this.service).align(seqs));
        if (jobid == null) {
            return null;
        }
        return new JobId(this.our.getServiceType(), this.our.getName(), jobid);
    }

    @Override
    public AlignmentI getAlignmentFor(JobId jobId) throws InvalidArgumentException, ServerError, IOError {
        compbio.data.sequence.Alignment alignment = null;
        try {
            alignment = ((MsaWS)this.service).getResult(jobId.getJobId());
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            // empty catch block
        }
        int alseq_l = 0;
        if (alignment.getSequences().size() == 0) {
            return null;
        }
        SequenceI[] alseqs = new SequenceI[alignment.getSequences().size()];
        for (FastaSequence seq : alignment.getSequences()) {
            alseqs[alseq_l++] = new Sequence(seq.getId(), seq.getSequence());
        }
        Alignment jv_al = new Alignment(alseqs);
        jv_al.setGapCharacter(alignment.getMetadata().getGapchar());
        return jv_al;
    }

    public JabawsMsaInstance(Jws2Instance handle) {
        super(handle);
    }
}

