/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.bin.Cache;
import jalview.util.Platform;
import jalview.ws.dbsources.Xfam;
import java.util.Locale;

public abstract class Pfam
extends Xfam {
    public static final String FULL = "full";
    public static final String RP35 = "rp35";
    public static final String RP15 = "rp15";
    public static final String RP75 = "rp75";
    public static final String RP55 = "rp55";
    public static final String SEED = "seed";
    public static final String UNIPROT = "uniprot";
    static final String PFAM_BASEURL_KEY = "PFAM_INTERPRO_URL_TEMPLATE";
    protected String alignmentType;
    private static final String DEFAULT_PFAM_BASEURL = "https://www.ebi.ac.uk/interpro/api/entry/pfam/$PFAMID$/?annotation=alignment:$ALTYPE$";

    public String getPfamDownloadURL(String id, String alType) {
        String url = Cache.getDefault(PFAM_BASEURL_KEY, DEFAULT_PFAM_BASEURL);
        url = url.replace("$PFAMID$", id);
        url = url.replace("$ALTYPE$", alType);
        return url;
    }

    @Override
    String getURL(String queries) {
        return this.getPfamDownloadURL(queries.trim().toUpperCase(Locale.ROOT), this.alignmentType);
    }

    @Override
    public String getAccessionSeparator() {
        return null;
    }

    @Override
    public Regex getAccessionValidator() {
        return null;
    }

    @Override
    public String getDbVersion() {
        return null;
    }

    @Override
    protected String getURLPrefix() {
        return Cache.getDefault(PFAM_BASEURL_KEY, DEFAULT_PFAM_BASEURL);
    }

    @Override
    public boolean isValidReference(String accession) {
        return accession.indexOf("PF") == 0;
    }

    @Override
    public String getXfamSource() {
        return "PFAM";
    }

    static {
        Platform.addJ2SDirectDatabaseCall(DEFAULT_PFAM_BASEURL);
    }
}

