/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.StructureFrequency;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.workers.AlignCalcWorker;
import java.util.Hashtable;

public class StrucConsensusThread
extends AlignCalcWorker {
    AlignmentAnnotation strucConsensus;
    Hashtable[] hStrucConsensus;
    private long nseq = -1L;

    public StrucConsensusThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    @Override
    public void run() {
        if (this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        AlignmentI alignment = this.alignViewport.getAlignment();
        int aWidth = -1;
        if (alignment == null || (aWidth = alignment.getWidth()) < 0) {
            return;
        }
        this.strucConsensus = this.alignViewport.getAlignmentStrucConsensusAnnotation();
        this.hStrucConsensus = this.alignViewport.getRnaStructureConsensusHash();
        this.strucConsensus.annotations = null;
        this.strucConsensus.annotations = new Annotation[aWidth];
        this.hStrucConsensus = new Hashtable[aWidth];
        AlignmentAnnotation[] aa = this.alignViewport.getAlignment().getAlignmentAnnotation();
        AlignmentAnnotation rnaStruc = null;
        if (aa != null) {
            for (int i = 0; i < aa.length; ++i) {
                if (!aa[i].isForDisplay() || !aa[i].isRNA() || !aa[i].isValidStruc()) continue;
                rnaStruc = aa[i];
                break;
            }
        }
        if (rnaStruc == null || !rnaStruc.isValidStruc()) {
            return;
        }
        try {
            SequenceI[] arr = alignment.getSequencesArray();
            this.nseq = arr.length;
            StructureFrequency.calculate(arr, 0, alignment.getWidth(), this.hStrucConsensus, true, rnaStruc);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            return;
        }
        this.alignViewport.setRnaStructureConsensusHash(this.hStrucConsensus);
        this.updateResultAnnotation(true);
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }

    public void updateResultAnnotation(boolean immediate) {
        if (immediate || !this.calcMan.isWorking(this) && this.strucConsensus != null && this.hStrucConsensus != null) {
            StructureFrequency.completeConsensus(this.strucConsensus, this.hStrucConsensus, 0, this.hStrucConsensus.length, this.alignViewport.isIgnoreGapsConsensus(), this.alignViewport.isShowSequenceLogo(), this.nseq);
        }
    }
}

