/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.AAFrequency;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SequenceI;
import jalview.renderer.ResidueShaderI;
import jalview.workers.AlignCalcWorker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecondaryStructureConsensusThread
extends AlignCalcWorker {
    public SecondaryStructureConsensusThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    @Override
    public void run() {
        List<AlignmentAnnotation> ssConsensus = this.getSSConsensusAnnotation();
        if (ssConsensus == null) {
            return;
        }
        if (this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        AlignmentI alignment = this.alignViewport.getAlignment();
        int aWidth = -1;
        if (alignment == null || (aWidth = alignment.getWidth()) < 0) {
            return;
        }
        this.alignViewport.setSecondaryStructureSources();
        this.eraseSSConsensus(aWidth);
        this.computeSSConsensus(alignment);
        this.updateResultAnnotation(true);
        if (this.ap != null) {
            this.ap.adjustAnnotationHeight();
        }
    }

    protected void eraseSSConsensus(int aWidth) {
        List<AlignmentAnnotation> ssConsensuses = this.getSSConsensusAnnotation();
        for (AlignmentAnnotation ssConsensus : ssConsensuses) {
            if (ssConsensus == null) continue;
            ssConsensus.annotations = new Annotation[aWidth];
        }
        AlignmentAnnotation gap = this.getGapAnnotation();
        if (gap != null) {
            gap.annotations = new Annotation[aWidth];
        }
    }

    protected void computeSSConsensus(AlignmentI alignment) {
        SequenceI[] aseqs = this.getSequences();
        int width = alignment.getWidth();
        HashMap<String, ProfilesI> hSSConsensusProfileMap = new HashMap<String, ProfilesI>();
        List<String> ssSources = this.getSecondaryStructureSources();
        for (String ssSource : ssSources) {
            ProfilesI hSSConsensus = AAFrequency.calculateSS(aseqs, width, 0, width, true, ssSource, null);
            hSSConsensusProfileMap.put(ssSource, hSSConsensus);
        }
        this.alignViewport.setSequenceSSConsensusHash(hSSConsensusProfileMap);
        this.setColourSchemeConsensus(hSSConsensusProfileMap);
    }

    protected SequenceI[] getSequences() {
        return this.alignViewport.getAlignment().getSequencesArray();
    }

    protected void setColourSchemeConsensus(Map<String, ProfilesI> ssConsensusProfileMap) {
        ResidueShaderI cs = this.alignViewport.getResidueShading();
        if (cs != null) {
            cs.setSSConsensusProfileMap(ssConsensusProfileMap);
        }
    }

    protected List<AlignmentAnnotation> getSSConsensusAnnotation() {
        return this.alignViewport.getAlignmentSecondaryStructureConsensusAnnotation();
    }

    protected List<String> getSecondaryStructureSources() {
        return this.alignViewport.getSecondaryStructureSources();
    }

    protected AlignmentAnnotation getGapAnnotation() {
        return this.alignViewport.getAlignmentGapAnnotation();
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }

    public void updateResultAnnotation(boolean immediate) {
        List<AlignmentAnnotation> ssConsensuses = this.getSSConsensusAnnotation();
        Map<String, ProfilesI> ssConsensusProfileMap = this.getViewportSSConsensus();
        if (ssConsensuses == null || ssConsensusProfileMap == null) {
            return;
        }
        boolean singleProvider = false;
        if (ssConsensusProfileMap.keySet() != null && ssConsensusProfileMap.keySet().size() == 2) {
            singleProvider = true;
        }
        for (AlignmentAnnotation ssConsensus : ssConsensuses) {
            ProfilesI ssConsensusProfile = null;
            for (String source : ssConsensusProfileMap.keySet()) {
                if (!ssConsensus.description.startsWith(source)) continue;
                ssConsensusProfile = ssConsensusProfileMap.get(source);
                ssConsensus.visible = !source.equals("All") || !singleProvider;
                break;
            }
            if (ssConsensusProfile == null || !immediate && (this.calcMan.isWorking(this) || ssConsensus == null || ssConsensusProfile == null)) continue;
            this.deriveSSConsensus(ssConsensus, ssConsensusProfile);
            if (ssConsensusProfile.get(1) != null) {
                ssConsensus.setNoOfSequencesIncluded(ssConsensusProfile.get(1).getSeqWithSSCount());
            }
            ssConsensus.setNoOfTracksIncluded(ssConsensusProfile.getCount());
            boolean bl = ssConsensus.hasData = ssConsensusProfile.getCount() > 0;
            if (ssConsensus.hasData) continue;
            ssConsensus.visible = false;
        }
    }

    protected void deriveSSConsensus(AlignmentAnnotation ssConsensus, ProfilesI hSSConsensus) {
        long nseq = this.getSequences().length;
        AAFrequency.completeSSConsensus(ssConsensus, hSSConsensus, hSSConsensus.getStartColumn(), hSSConsensus.getEndColumn() + 1, this.alignViewport.isIgnoreGapsConsensus(), this.alignViewport.isShowSequenceLogo(), nseq);
    }

    protected void deriveGap(AlignmentAnnotation gapAnnotation, ProfilesI hconsensus) {
        long nseq = this.getSequences().length;
        AAFrequency.completeGapAnnot(gapAnnotation, hconsensus, hconsensus.getStartColumn(), hconsensus.getEndColumn() + 1, nseq);
    }

    protected Map<String, ProfilesI> getViewportSSConsensus() {
        return this.alignViewport.getSequenceSSConsensusHash();
    }
}

