/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.analysis.Conservation;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.workers.AlignCalcWorker;
import java.util.ArrayList;

public class ConservationThread
extends AlignCalcWorker {
    private int ConsPercGaps = 25;
    private Conservation cons;
    AlignmentAnnotation conservation;
    AlignmentAnnotation quality;
    int alWidth;

    public ConservationThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
        this.ConsPercGaps = alignViewport.getConsPercGaps();
    }

    @Override
    public void run() {
        if (this.alignViewport == null || this.calcMan == null || this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        ArrayList<AlignmentAnnotation> ourAnnot = new ArrayList<AlignmentAnnotation>();
        AlignmentI alignment = this.alignViewport.getAlignment();
        this.conservation = this.alignViewport.getAlignmentConservationAnnotation();
        this.quality = this.alignViewport.getAlignmentQualityAnnot();
        ourAnnot.add(this.conservation);
        ourAnnot.add(this.quality);
        this.ourAnnots = ourAnnot;
        this.ConsPercGaps = this.alignViewport.getConsPercGaps();
        if (alignment == null || (this.alWidth = alignment.getWidth()) < 0) {
            return;
        }
        try {
            this.cons = Conservation.calculateConservation("All", alignment.getSequences(), 0, this.alWidth - 1, false, this.ConsPercGaps, this.quality != null, this.alignViewport.is3di() ? ScoreModels.getInstance().getFOLDSEEK3DI() : ScoreModels.getInstance().getDefaultModel(true));
        }
        catch (Throwable x) {
            return;
        }
        this.updateResultAnnotation(true);
        if (this.alignViewport == null || this.calcMan == null || this.alignViewport.isClosed()) {
            this.abortAndDestroy();
            return;
        }
        if (this.ap != null) {
            this.ap.paintAlignment(true, true);
        }
    }

    private void updateResultAnnotation(boolean b) {
        if (b || !this.calcMan.isWorking(this) && this.cons != null && this.conservation != null && this.quality != null) {
            this.alignViewport.setConservation(this.cons);
            this.cons.completeAnnotations(this.conservation, this.quality, 0, this.alWidth);
        }
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }
}

