/*
 * Decompiled with CFR 0.152.
 */
package jalview.workers;

import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import jalview.util.MappingUtils;
import jalview.workers.AlignCalcWorker;
import java.util.ArrayList;
import java.util.List;

public class AlignmentComparisonThread
extends AlignCalcWorker {
    Annotation[] correspondence = new Annotation[1];
    AlignmentAnnotation comparisonAnnot = null;
    int alWidth;
    private int maxCor = 1;

    public AlignmentComparisonThread(AlignViewportI alignViewport, AlignmentViewPanel alignPanel) {
        super(alignViewport, alignPanel);
    }

    @Override
    public void run() {
        this.comparisonAnnot = this.alignViewport.getComparisonAnnotation();
        if (this.alignViewport == null || this.calcMan == null || this.alignViewport.isClosed()) {
            return;
        }
        ArrayList<AlignmentAnnotation> ourAnnot = new ArrayList<AlignmentAnnotation>();
        AlignmentI alignment = this.alignViewport.getAlignment();
        AlignViewportI codingComplement = this.alignViewport.getCodingComplement();
        if (alignment == null || (this.alWidth = alignment.getWidth()) < 0 || codingComplement == null) {
            return;
        }
        this.comparisonAnnot.annotations = this.correspondence;
        ourAnnot.add(this.comparisonAnnot);
        this.ourAnnots = ourAnnot;
        this.computeColumnCorrespondence(this.alignViewport, codingComplement);
        this.updateResultAnnotation(true);
        if (this.ap != null) {
            this.ap.paintAlignment(true, true);
        }
    }

    private void computeColumnCorrespondence(AlignViewportI alignViewport, AlignViewportI codingComplement) {
        List<SequenceI> us = alignViewport.getAlignment().getSequences();
        List<AlignedCodonFrame> ourMappings = alignViewport.getAlignment().getCodonFrames();
        List<SequenceI> them = codingComplement.getAlignment().getSequences();
        if (us == null || them == null || us.isEmpty() || them.isEmpty()) {
            return;
        }
        int colEnd = alignViewport.getAlignment().getWidth();
        Annotation[] colCorrsp = new Annotation[colEnd];
        this.maxCor = 0;
        for (int col = 0; col < colEnd; ++col) {
            int[] theirWidth = MappingUtils.findMappedColumns(col, ourMappings, us, them, alignViewport.getGapCharacter());
            int wid = theirWidth != null ? Math.abs(theirWidth[1] - theirWidth[0]) : 0;
            colCorrsp[col] = new Annotation(wid);
            this.maxCor = Math.max(this.maxCor, wid);
        }
        this.correspondence = colCorrsp;
    }

    private void updateResultAnnotation(boolean b) {
        if (b || !this.calcMan.isWorking(this) && this.correspondence != null) {
            this.comparisonAnnot.annotations = this.correspondence;
            this.comparisonAnnot.graphMax = this.maxCor;
            this.comparisonAnnot.validateRangeAndDisplay();
            this.ap.paintAlignment(false, false);
        }
    }

    @Override
    public void updateAnnotation() {
        this.updateResultAnnotation(false);
    }
}

