/*
 * Decompiled with CFR 0.152.
 */
package jalview.util.imagemaker;

import jalview.bin.Cache;

public class BitmapImageSizing {
    private final float scale;
    private final int width;
    private final int height;
    private boolean isDefault = false;
    public static final String BITMAP_SCALE = "BITMAP_SCALE";
    public static final String BITMAP_HEIGHT = "BITMAP_HEIGHT";
    public static final String BITMAP_WIDTH = "BITMAP_WIDTH";

    public BitmapImageSizing(float scale, int width, int height, boolean isDefault) {
        this.scale = scale;
        this.width = width;
        this.height = height;
        this.isDefault = isDefault;
    }

    public boolean isNull() {
        return this.scale == 0.0f && this.width == 0 && this.height == 0;
    }

    public static BitmapImageSizing nullBitmapImageSizing() {
        return new BitmapImageSizing(0.0f, 0, 0, false);
    }

    public static BitmapImageSizing defaultBitmapImageSizing() {
        return new BitmapImageSizing(0.0f, 0, 0, true);
    }

    private float defaultScale() {
        return Cache.getDefault(BITMAP_SCALE, 0.0f);
    }

    private int defaultWidth() {
        return Cache.getDefault(BITMAP_WIDTH, 0);
    }

    private int defaultHeight() {
        return Cache.getDefault(BITMAP_HEIGHT, 0);
    }

    public float scale() {
        return this.isDefault() ? this.defaultScale() : this.scale;
    }

    public int width() {
        return this.isDefault() ? this.defaultWidth() : this.width;
    }

    public int height() {
        return this.isDefault() ? this.defaultHeight() : this.height;
    }

    public boolean isDefault() {
        return this.isDefault;
    }
}

