/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.util.ChannelProperties;
import jalview.util.ErrorLog;
import jalview.util.HttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class LaunchUtils {
    public static final boolean isMac = System.getProperty("os.name").indexOf("Mac") > -1;
    public static final boolean isWindows = System.getProperty("os.name").indexOf("Win") > -1;
    private static boolean isJS = false;
    public static final String LOGFILE_HANDOVER = "LOGFILE_HANDOVER";
    private static Properties userPreferences = null;
    public static int JAVA_COMPILE_VERSION = 0;
    public static int JAVA_VERSION = 0;

    public static void loadChannelProps(File dir) {
        ChannelProperties.loadProps(dir);
    }

    public static String getUserPreference(String key) {
        if (userPreferences == null) {
            String channelPrefsFilename = ChannelProperties.getProperty("preferences.filename");
            if (channelPrefsFilename == null) {
                return null;
            }
            File propertiesFile = new File(System.getProperty("user.home"), channelPrefsFilename);
            if (!propertiesFile.exists()) {
                return null;
            }
            try {
                userPreferences = new Properties();
                userPreferences.load(new FileInputStream(propertiesFile));
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                ErrorLog.errPrintln(e.getMessage());
                return null;
            }
        }
        return userPreferences.getProperty(key);
    }

    public static boolean getBooleanUserPreference(String key) {
        return Boolean.parseBoolean(LaunchUtils.getUserPreference(key));
    }

    public static int getJavaCompileVersion() {
        if (isJS) {
            return -1;
        }
        if (JAVA_COMPILE_VERSION > 0) {
            return JAVA_COMPILE_VERSION;
        }
        String buildDetails = "jar:".concat(LaunchUtils.class.getProtectionDomain().getCodeSource().getLocation().toString().concat("!/.build_properties"));
        try {
            URL localFileURL = new URL(buildDetails);
            InputStream in = HttpUtils.openStream(localFileURL);
            Properties buildProperties = new Properties();
            buildProperties.load(in);
            in.close();
            String JCV = buildProperties.getProperty("JAVA_COMPILE_VERSION", null);
            if (JCV == null) {
                ErrorLog.errPrintln("Could not obtain JAVA_COMPILE_VERSION for comparison");
                return -2;
            }
            JAVA_COMPILE_VERSION = Integer.parseInt(JCV);
        }
        catch (MalformedURLException e) {
            ErrorLog.errPrintln("Could not find " + buildDetails);
            return -3;
        }
        catch (IOException e) {
            ErrorLog.errPrintln("Could not load " + buildDetails);
            return -4;
        }
        catch (NumberFormatException e) {
            ErrorLog.errPrintln("Could not parse JAVA_COMPILE_VERSION");
            return -5;
        }
        return JAVA_COMPILE_VERSION;
    }

    public static int getJavaVersion() {
        if (isJS) {
            return -1;
        }
        if (JAVA_VERSION > 0) {
            return JAVA_VERSION;
        }
        try {
            String JV = System.getProperty("java.version");
            if (JV == null) {
                ErrorLog.errPrintln("Could not obtain java.version for comparison");
                return -2;
            }
            if (JV.startsWith("1.")) {
                JV = JV.substring(2);
            }
            JAVA_VERSION = JV.indexOf(".") == -1 ? Integer.parseInt(JV) : Integer.parseInt(JV.substring(0, JV.indexOf(".")));
        }
        catch (NumberFormatException e) {
            ErrorLog.errPrintln("Could not parse java.version");
            return -3;
        }
        return JAVA_VERSION;
    }

    public static String getJarPath(Class c) {
        try {
            return c.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        }
        catch (URISyntaxException e) {
            ErrorLog.errPrintln("Problem with class source location");
            return null;
        }
    }

    public static boolean checkJavaVersion() {
        if (isJS) {
            return true;
        }
        String buildDetails = "jar:".concat(LaunchUtils.class.getProtectionDomain().getCodeSource().getLocation().toString().concat("!/.build_properties"));
        int java_compile_version = LaunchUtils.getJavaCompileVersion();
        int java_version = LaunchUtils.getJavaVersion();
        if (java_compile_version <= 0 || java_version <= 0) {
            ErrorLog.errPrintln("Could not make Java version check");
            return true;
        }
        return java_version < 11 || java_compile_version >= 11;
    }

    public static String findJavaBin(boolean winConsole) {
        return LaunchUtils.findJavaBin(System.getProperty("java.home"), winConsole, true, true);
    }

    public static String findJavaBin(boolean winConsole, boolean applicationName, boolean generic) {
        return LaunchUtils.findJavaBin(System.getProperty("java.home"), winConsole, applicationName, generic);
    }

    public static String findJavaBin(String javaHome, boolean winConsole, boolean applicationName, boolean generic) {
        Object javaBin = null;
        String javaExe = winConsole ? "java.exe" : "javaw.exe";
        String java = "java";
        if (javaHome != null) {
            String propertyAppName = null;
            String appName = null;
            if (applicationName) {
                propertyAppName = System.getProperty("channel.app_name");
                appName = propertyAppName != null && propertyAppName.length() > 0 ? propertyAppName : ChannelProperties.getProperty("app_name");
            }
            String javaBinDir = javaHome + File.separator + "bin" + File.separator;
            ArrayList<String> potentialJavaBin = new ArrayList<String>();
            if (applicationName) {
                if (appName != null) {
                    potentialJavaBin.add(appName);
                }
                if ("Jalview" != null) {
                    potentialJavaBin.add("Jalview");
                }
            }
            potentialJavaBin.add("java");
            potentialJavaBin.add(javaExe);
            for (String name : potentialJavaBin) {
                if (name == null || !LaunchUtils.checkJVMSymlink(javaBinDir + name, winConsole)) continue;
                javaBin = javaBinDir + name;
                break;
            }
        }
        if (javaBin == null && generic) {
            javaBin = isWindows ? javaExe : "java";
        }
        return javaBin;
    }

    private static boolean checkJVMSymlink(String testBin, boolean winConsole) {
        String javaExe;
        File testBinFile = new File(testBin);
        if (!testBinFile.exists()) {
            return false;
        }
        File targetFile = null;
        try {
            targetFile = testBinFile.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        String string = javaExe = winConsole ? "java.exe" : "javaw.exe";
        return targetFile != null && ("java".equals(targetFile.getName()) || javaExe.equals(targetFile.getName()));
    }

    public static int startNewJvm(String javaBinary, List<String> removeJvmArguments, List<String> addJvmArguments, List<String> prependToClasspath, List<String> appendToClasspath, List<String> removeFromClasspath, String startClass, List<String> removeAppArguments, List<String> addAppArguments, List<String> appArguments, boolean launcherprint, boolean launcherwait, boolean launcherstop, boolean debug, boolean quiet) {
        if (javaBinary == null) {
            javaBinary = LaunchUtils.findJavaBin(false, true, true);
        }
        ArrayList<String> classpathDirs = new ArrayList<String>();
        if (prependToClasspath != null) {
            classpathDirs.addAll(prependToClasspath);
        }
        String classpath = ManagementFactory.getRuntimeMXBean().getClassPath();
        if (removeFromClasspath != null) {
            HashSet<String> removeCp = new HashSet<String>();
            for (String dcp : removeFromClasspath) {
                try {
                    String canPath = new File(dcp).getCanonicalPath();
                    removeCp.add(canPath);
                }
                catch (IOException e) {
                    ErrorLog.errPrintln("Problem getting canonical path. " + e.getMessage());
                }
            }
            for (String cp : classpath.split(File.pathSeparator)) {
                try {
                    String canPath = new File(cp).getCanonicalPath();
                    if (removeCp.contains(canPath)) continue;
                    classpathDirs.add(cp);
                }
                catch (IOException e) {
                    ErrorLog.errPrintln("Problem getting canonical path. " + e.getMessage());
                }
            }
        } else {
            classpathDirs.addAll(Arrays.asList(classpath.split(File.pathSeparator)));
        }
        if (appendToClasspath != null) {
            classpathDirs.addAll(appendToClasspath);
        }
        ArrayList<String> jvmArguments = new ArrayList<String>();
        List<String> originalJvmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (removeJvmArguments != null && removeJvmArguments.size() > 0) {
            for (String jvmArg : originalJvmArguments) {
                boolean addArg = true;
                for (String rmArg : removeJvmArguments) {
                    if (!jvmArg.startsWith(rmArg)) continue;
                    addArg = false;
                    break;
                }
                if (!addArg) continue;
                jvmArguments.add(jvmArg);
            }
        } else {
            jvmArguments.addAll(originalJvmArguments);
        }
        if (addJvmArguments != null) {
            jvmArguments.addAll(addJvmArguments);
        }
        if (startClass == null) {
            startClass = System.getProperty("sun.java.command");
        }
        ArrayList<String> applicationArguments = new ArrayList<String>();
        if (removeAppArguments != null && removeAppArguments.size() > 0) {
            HashSet<String> removeArgs = new HashSet<String>(removeAppArguments);
            for (String appArg : appArguments) {
                if (removeArgs.contains(appArg)) continue;
                applicationArguments.add(appArg);
            }
        } else {
            applicationArguments.addAll(appArguments);
        }
        if (addAppArguments != null) {
            applicationArguments.addAll(addAppArguments);
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaBinary);
        command.add("-cp");
        command.add(String.join((CharSequence)File.pathSeparator, classpathDirs));
        command.addAll(jvmArguments);
        command.add(startClass);
        command.addAll(applicationArguments);
        return LaunchUtils.runProcess(command, launcherprint, launcherwait, launcherstop, debug, quiet);
    }

    private static int runProcess(List<String> command, boolean launcherprint, boolean launcherwait, boolean launcherstop, boolean debug, boolean quiet) {
        ProcessBuilder builder = new ProcessBuilder(command);
        Process p = null;
        int exitValue = -1;
        if (Boolean.parseBoolean(System.getProperty("launcherprint", "false")) || launcherprint) {
            LaunchUtils.syserr(debug, quiet, "COMMAND : \"" + String.join((CharSequence)"\" \"", builder.command()) + "\"");
        }
        if (Boolean.parseBoolean(System.getProperty("launcherstop", "false")) || debug && launcherstop) {
            LaunchUtils.syserr(debug, quiet, "System property 'launcherstop' is set and not 'false'. Exiting.");
            System.exit(0);
        }
        try {
            Process process;
            builder.inheritIO();
            p = process = builder.start();
            if (launcherwait) {
                LaunchUtils.syserr(debug, quiet, "Launching application process");
                exitValue = process.waitFor();
                LaunchUtils.syserr(debug, quiet, "Application process return with value " + exitValue);
            } else {
                int waitInt = 0;
                LaunchUtils.syserr(debug, quiet, "Wait time for application process is " + waitInt + "ms");
                exitValue = process.waitFor(waitInt, TimeUnit.MILLISECONDS) ? process.exitValue() : -2;
            }
            LaunchUtils.syserr(debug, quiet, "Launcher process ending");
        }
        catch (IOException e) {
            if (e.getMessage().toLowerCase(Locale.ROOT).contains("memory")) {
                LaunchUtils.syserr(true, quiet, "Caught a memory exception: " + e.getMessage());
                ArrayList<String> commandNoMem = new ArrayList<String>();
                for (int i = 0; i < command.size(); ++i) {
                    if (command.get(i).startsWith("-Xmx")) continue;
                    commandNoMem.add(command.get(i));
                }
                ProcessBuilder builderNoMem = new ProcessBuilder(commandNoMem);
                LaunchUtils.syserr(true, quiet, "Command without memory setting: " + String.join((CharSequence)" ", builderNoMem.command()));
                try {
                    Process processNoMem;
                    builderNoMem.inheritIO();
                    p = processNoMem = builderNoMem.start();
                    exitValue = processNoMem.waitFor();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            p.getOutputStream().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exitValue;
    }

    public static int compareGetdownLauncherJarVersions(File f0, File f1) {
        String v0 = f0.exists() ? LaunchUtils.getJarImplementationVersion(f0) : null;
        return LaunchUtils.compareGetdownLauncherJarVersions(v0, f1);
    }

    public static int compareGetdownLauncherJarVersions(String v0, File f1) {
        String v1 = f1.exists() ? LaunchUtils.getJarImplementationVersion(f1) : null;
        return LaunchUtils.compareGetdownLauncherJarVersions(v0, v1);
    }

    public static int compareGetdownLauncherJarVersions(String v0, String v1) {
        LaunchUtils.syserr(v0 != null && !v0.equals(v1), false, "Got launcher versions '" + v0 + "' and '" + v1 + "'");
        if (v0 == null && v1 == null) {
            return 0;
        }
        if (v0 == null) {
            return -1;
        }
        if (v1 == null) {
            return 1;
        }
        if (v0.endsWith("JVL")) {
            v0 = v0.substring(0, v0.lastIndexOf(95));
        }
        if (v1.endsWith("JVL")) {
            v1 = v1.substring(0, v1.lastIndexOf(95));
        }
        String[] v0parts = v0.split("-");
        String[] v1parts = v1.split("-");
        int compare = 0;
        for (int j = 0; j < Math.min(v0parts.length, v1parts.length); ++j) {
            compare = LaunchUtils.compareVersions(v0parts[j], v1parts[j]);
            if (compare == 0) continue;
            return compare;
        }
        return v0parts.length - v1parts.length;
    }

    public static int compareVersions(String v0, String v1) {
        if (v0 == null && v1 == null) {
            return 0;
        }
        if (v0 == null) {
            return -1;
        }
        if (v1 == null) {
            return 1;
        }
        String[] v0dots = v0.split("\\.");
        String[] v1dots = v1.split("\\.");
        int compare = 0;
        for (int i = 0; i < Math.min(v0dots.length, v1dots.length); ++i) {
            if (v0dots[i].equals(v1dots[i])) continue;
            try {
                compare = Integer.parseInt(v0dots[i]) - Integer.parseInt(v1dots[i]);
            }
            catch (NumberFormatException e) {
                LaunchUtils.syserr(true, false, "Couldn't parse one of '" + v0dots[i] + "' or '" + v1dots[i] + "': " + e.getMessage());
                LaunchUtils.syserr(true, false, "Comparing as strings.");
                compare = v0dots[i].compareTo(v1dots[i]);
            }
            if (compare == 0) continue;
            return compare;
        }
        return v0dots.length - v1dots.length;
    }

    public static String getJarImplementationVersion(File jarFile) {
        String implementationVersion = null;
        try {
            JarInputStream j0 = new JarInputStream(new FileInputStream(jarFile));
            Manifest m0 = j0.getManifest();
            if (m0 == null) {
                System.err.println("No manifest in " + jarFile.getAbsolutePath());
            } else {
                implementationVersion = m0.getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
        }
        catch (IOException e) {
            System.err.println("Exception opening " + jarFile.getAbsolutePath() + " to check version: " + e.getMessage());
        }
        return implementationVersion;
    }

    public static void syserr(boolean debug, boolean quiet, String message) {
        if (debug && !quiet) {
            ErrorLog.errPrintln("DEBUG - " + message);
        }
    }
}

