/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.util.Arrays;
import java.util.Objects;

public class ArrayUtils {
    public static void reverseIntArray(int[] arr) {
        if (arr != null) {
            int last = arr.length - 1;
            for (int k = 0; k < arr.length / 2; ++k) {
                int temp = arr[k];
                arr[k] = arr[last - k];
                arr[last - k] = temp;
            }
        }
    }

    public static <T> T[] concatArrays(T[] ... arrays) {
        if (arrays == null) {
            return null;
        }
        if (arrays.length == 1) {
            return arrays[0];
        }
        T[] result = arrays[0];
        for (int i = 1; i < arrays.length; ++i) {
            result = ArrayUtils.concatTwoArrays(result, arrays[i]);
        }
        return result;
    }

    private static <T> T[] concatTwoArrays(T[] array1, T[] array2) {
        T[] result = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static int indexOf(Object[] arr, Object item) {
        for (int i = 0; i < arr.length; ++i) {
            if (!Objects.equals(arr[i], item)) continue;
            return i;
        }
        return -1;
    }
}

