/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.ScoreColourScheme;
import java.awt.Color;

public class BuriedColourScheme
extends ScoreColourScheme {
    public BuriedColourScheme() {
        super(ResidueProperties.aaIndex, ResidueProperties.buried, 0.05, 4.6);
    }

    @Override
    public Color makeColour(float c) {
        return new Color(0.0f, (float)(1.0 - (double)c), c);
    }

    @Override
    public boolean isPeptideSpecific() {
        return true;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.Buried.toString();
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new BuriedColourScheme();
    }
}

