/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.ApplicationSingletonProvider;
import jalview.bin.Console;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FileFormats
implements ApplicationSingletonProvider.ApplicationSingletonI {
    private Map<String, FileFormatI> formats;
    private Set<FileFormatI> identifiable;

    public static FileFormats getInstance() {
        return ApplicationSingletonProvider.getInstance(FileFormats.class);
    }

    private FileFormats() {
        this.reset();
    }

    public synchronized void reset() {
        this.formats = new LinkedHashMap<String, FileFormatI>();
        this.identifiable = new HashSet<FileFormatI>();
        for (FileFormat format : FileFormat.values()) {
            this.registerFileFormat(format, format.isIdentifiable());
        }
    }

    public boolean isIdentifiable(FileFormatI f) {
        return this.identifiable.contains(f);
    }

    public void registerFileFormat(FileFormatI format) {
        boolean isIdentifiable = format instanceof FileFormat && ((FileFormat)format).isIdentifiable();
        this.registerFileFormat(format, isIdentifiable);
    }

    protected void registerFileFormat(FileFormatI format, boolean isIdentifiable) {
        String name = format.getName().toUpperCase(Locale.ROOT);
        if (this.formats.containsKey(name)) {
            Console.errPrintln("Overwriting file format: " + format.getName());
        }
        this.formats.put(name, format);
        if (isIdentifiable) {
            this.identifiable.add(format);
        }
    }

    public void deregisterFileFormat(String name) {
        FileFormatI ff = this.formats.remove(name.toUpperCase(Locale.ROOT));
        this.identifiable.remove(ff);
    }

    public List<String> getWritableFormats(boolean textOnly) {
        ArrayList<String> l = new ArrayList<String>();
        for (FileFormatI ff : this.formats.values()) {
            if (!ff.isWritable() || textOnly && !ff.isTextFormat()) continue;
            l.add(ff.getName());
        }
        return l;
    }

    public List<String> getReadableFormats() {
        ArrayList<String> l = new ArrayList<String>();
        for (FileFormatI ff : this.formats.values()) {
            if (!ff.isReadable()) continue;
            l.add(ff.getName());
        }
        return l;
    }

    public FileFormatI forName(String format) {
        return format == null ? null : this.formats.get(format.toUpperCase(Locale.ROOT));
    }

    public Iterable<FileFormatI> getFormats() {
        return this.formats.values();
    }
}

