/*
 * Decompiled with CFR 0.152.
 */
package jalview.hmmer;

import jalview.analysis.SeqsetUtils;
import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.ResidueCount;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.JvOptionPane;
import jalview.hmmer.HmmerCommand;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.HMMFile;
import jalview.util.FileUtils;
import jalview.util.MessageManager;
import jalview.ws.params.ArgumentI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HMMBuild
extends HmmerCommand {
    static final String ARG_AMINO = "--amino";
    static final String ARG_DNA = "--dna";
    static final String ARG_RNA = "--rna";

    public HMMBuild(AlignFrame alignFrame, List<ArgumentI> args) {
        super(alignFrame, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.params == null || this.params.isEmpty()) {
            Console.error("No parameters to HMMBuild!|");
            return;
        }
        long msgID = System.currentTimeMillis();
        this.af.setProgressBar(MessageManager.getString("status.running_hmmbuild"), msgID);
        AlignViewport viewport = this.af.getViewport();
        try {
            List<AnnotatedCollectionI> runBuildFor = this.parseParameters(viewport);
            for (AnnotatedCollectionI grp : runBuildFor) {
                this.runHMMBuild(grp);
            }
        }
        finally {
            this.af.setProgressBar("", msgID);
            viewport.alignmentChanged(this.af.alignPanel);
            this.af.buildColourMenu();
        }
    }

    protected List<AnnotatedCollectionI> parseParameters(AlignViewportI viewport) {
        ArrayList<AnnotatedCollectionI> runBuildFor = new ArrayList<AnnotatedCollectionI>();
        boolean foundArg = false;
        for (ArgumentI arg : this.params) {
            String name = arg.getName();
            if (MessageManager.getString("label.hmmbuild_for").equals(name)) {
                foundArg = true;
                String value = arg.getValue();
                if (MessageManager.getString("label.alignment").equals(value)) {
                    runBuildFor.add(viewport.getAlignmentView(false).getVisibleAlignment('-'));
                    continue;
                }
                if (MessageManager.getString("label.groups_and_alignment").equals(value)) {
                    runBuildFor.add(viewport.getAlignmentView(false).getVisibleAlignment('-'));
                    runBuildFor.addAll(viewport.getAlignment().getGroups());
                    continue;
                }
                if (MessageManager.getString("label.groups").equals(value)) {
                    runBuildFor.addAll(viewport.getAlignment().getGroups());
                    continue;
                }
                if (!MessageManager.getString("label.selected_group").equals(value)) continue;
                runBuildFor.add(viewport.getSelectionGroup());
                continue;
            }
            if (!MessageManager.getString("label.use_reference").equals(name) || this.af.getViewport().hasReferenceAnnotation()) continue;
            JvOptionPane.showInternalMessageDialog(this.af, MessageManager.getString("warn.no_reference_annotation"));
        }
        if (!foundArg) {
            runBuildFor.add(this.alignment);
        }
        return runBuildFor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHMMBuild(AnnotatedCollectionI ac) {
        File hmmFile = null;
        File alignmentFile = null;
        try {
            Alignment al;
            hmmFile = FileUtils.createTempFile("hmm", ".hmm");
            alignmentFile = FileUtils.createTempFile("output", ".sto");
            if (ac instanceof Alignment && !(al = (Alignment)ac).isAligned()) {
                al.padGaps();
            }
            this.deleteHmmSequences(ac);
            ArrayList<SequenceI> copy = new ArrayList<SequenceI>();
            if (ac instanceof Alignment) {
                copy.addAll(ac.getSequences());
            } else {
                SequenceI[] sel;
                for (SequenceI seq : sel = ((SequenceGroup)ac).getSelectionAsNewSequences((AlignmentI)ac.getContext())) {
                    if (seq == null) continue;
                    copy.add(seq);
                }
            }
            SequenceI[] copyArray = copy.toArray(new SequenceI[copy.size()]);
            Map<String, SeqsetUtils.SequenceInfo> sequencesHash = this.stashSequences(copyArray);
            this.exportStockholm(copyArray, alignmentFile, ac);
            this.recoverSequences(sequencesHash, copy.toArray(new SequenceI[0]));
            boolean ran = this.runCommand(alignmentFile, hmmFile, ac);
            if (!ran) {
                JvOptionPane.showInternalMessageDialog(this.af, MessageManager.formatMessage("warn.command_failed", "hmmbuild"));
                return;
            }
            this.importData(hmmFile, ac);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (hmmFile != null) {
                hmmFile.delete();
            }
            if (alignmentFile != null) {
                alignmentFile.delete();
            }
        }
    }

    private boolean runCommand(File sequencesFile, File hmmFile, AnnotatedCollectionI group) throws IOException {
        String cmd = this.getCommandPath("hmmbuild");
        if (cmd == null) {
            return false;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(cmd);
        Object name = "";
        if (this.params != null) {
            for (ArgumentI arg : this.params) {
                String argName;
                switch (argName = arg.getName()) {
                    case "HMM Name": {
                        name = arg.getValue().trim();
                        break;
                    }
                    case "Use Reference Annotation": {
                        args.add("--hand");
                    }
                }
            }
        }
        if (group instanceof SequenceGroup) {
            name = ((SequenceGroup)group).getName() + "_HMM";
        }
        if ("".equals(name)) {
            name = this.af != null && this.af.getTitle().length() < 15 ? this.af.getTitle() : "Alignment_HMM";
        }
        args.add("-n");
        args.add(((String)name).replace(' ', '_'));
        if (!this.alignment.isNucleotide()) {
            args.add(ARG_AMINO);
        } else {
            args.add(ARG_DNA);
        }
        args.add(this.getFilePath(hmmFile, true));
        args.add(this.getFilePath(sequencesFile, true));
        return this.runCommand(args);
    }

    private void importData(File hmmFile, AnnotatedCollectionI ac) throws IOException {
        if (hmmFile.length() == 0L) {
            Console.error("Error: hmmbuild produced empty hmm file");
            return;
        }
        HMMFile file = new HMMFile(new FileParse(hmmFile.getAbsolutePath(), DataSourceType.FILE));
        SequenceI hmmSeq = file.getHMM().getConsensusSequence();
        ResidueCount counts = new ResidueCount(this.alignment.getSequences());
        hmmSeq.getHMM().setBackgroundFrequencies(counts);
        if (hmmSeq == null) {
            return;
        }
        if (ac instanceof SequenceGroup) {
            SequenceGroup grp = (SequenceGroup)ac;
            char gapChar = this.alignment.getGapCharacter();
            hmmSeq.insertCharAt(0, ac.getStartRes(), gapChar);
            hmmSeq.insertCharAt(ac.getEndRes() + 1, this.alignment.getWidth() - ac.getEndRes() - 1, gapChar);
            SequenceI topSeq = grp.getSequencesInOrder(this.alignment)[0];
            int topIndex = this.alignment.findIndex(topSeq);
            this.alignment.insertSequenceAt(topIndex, hmmSeq);
            ac.setSeqrep(hmmSeq);
            grp.addSequence(hmmSeq, false);
        } else {
            this.alignment.insertSequenceAt(0, hmmSeq);
        }
    }
}

